/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.chests.block;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stat;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.rezolv.obsidanum.chests.block.ObsidanumChestsTypes;
import net.rezolv.obsidanum.chests.block.entity.AbstractObsidanumChestBlockEntity;

public abstract class AbstractObsidanumChestBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);
    private static final DoubleBlockCombiner.Combiner<AbstractObsidanumChestBlockEntity, Optional<Container>> CHEST_COMBINER = new DoubleBlockCombiner.Combiner<AbstractObsidanumChestBlockEntity, Optional<Container>>(){

        public Optional<Container> acceptDouble(AbstractObsidanumChestBlockEntity blockEntityOne, AbstractObsidanumChestBlockEntity blockEntityTwo) {
            return Optional.of(new CompoundContainer((Container)blockEntityOne, (Container)blockEntityTwo));
        }

        public Optional<Container> acceptSingle(AbstractObsidanumChestBlockEntity blockEntity) {
            return Optional.of(blockEntity);
        }

        public Optional<Container> acceptNone() {
            return Optional.empty();
        }
    };
    private static final DoubleBlockCombiner.Combiner<AbstractObsidanumChestBlockEntity, Optional<MenuProvider>> MENU_PROVIDER_COMBINER = new DoubleBlockCombiner.Combiner<AbstractObsidanumChestBlockEntity, Optional<MenuProvider>>(){

        public Optional<MenuProvider> acceptDouble(AbstractObsidanumChestBlockEntity blockEntityOne, AbstractObsidanumChestBlockEntity blockEntityTwo) {
            return Optional.empty();
        }

        public Optional<MenuProvider> acceptSingle(AbstractObsidanumChestBlockEntity blockEntity) {
            return Optional.of(blockEntity);
        }

        public Optional<MenuProvider> acceptNone() {
            return Optional.empty();
        }
    };
    private final ObsidanumChestsTypes type;
    protected final Supplier<BlockEntityType<? extends AbstractObsidanumChestBlockEntity>> blockEntityType;

    public AbstractObsidanumChestBlock(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends AbstractObsidanumChestBlockEntity>> blockEntityType, ObsidanumChestsTypes type) {
        super(properties);
        this.type = type;
        this.blockEntityType = blockEntityType;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState blockState) {
        return DoubleBlockCombiner.BlockType.SINGLE;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Deprecated
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState facingState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return super.m_7417_(blockState, direction, facingState, levelAccessor, currentPos, facingPos);
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return AABB;
    }

    public static Direction getConnectedDirection(BlockState blockState) {
        return ((Direction)blockState.m_61143_((Property)FACING)).m_122428_();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_8125_().m_122424_();
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
    }

    @Deprecated
    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof AbstractObsidanumChestBlockEntity) {
            ((AbstractObsidanumChestBlockEntity)blockEntity).wasPlaced(livingEntity, itemStack);
            if (itemStack.m_41788_()) {
                ((AbstractObsidanumChestBlockEntity)blockEntity).m_58638_(itemStack.m_41786_());
            }
        }
    }

    @Deprecated
    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState newState, boolean isMoving) {
        if (!blockState.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof AbstractObsidanumChestBlockEntity) {
                ((AbstractObsidanumChestBlockEntity)blockEntity).removeAdornments();
                Containers.m_19002_((Level)level, (BlockPos)blockPos, (Container)((AbstractObsidanumChestBlockEntity)blockEntity));
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, newState, isMoving);
        }
    }

    @Deprecated
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        MenuProvider menuProvider = this.m_7246_(blockState, level, blockPos);
        if (menuProvider != null) {
            player.m_5893_(menuProvider);
            player.m_36246_(this.getOpenChestStat());
        }
        return InteractionResult.CONSUME;
    }

    protected Stat<ResourceLocation> getOpenChestStat() {
        return Stats.f_12988_.m_12902_((Object)Stats.f_12968_);
    }

    public BlockEntityType<? extends AbstractObsidanumChestBlockEntity> blockEntityType() {
        return this.blockEntityType.get();
    }

    @Nullable
    public static Container getContainer(AbstractObsidanumChestBlock chestBlock, BlockState blockState, Level level, BlockPos blockPos, boolean ignoreBlockedChest) {
        return ((Optional)chestBlock.combine(blockState, level, blockPos, ignoreBlockedChest).m_5649_(CHEST_COMBINER)).orElse(null);
    }

    public DoubleBlockCombiner.NeighborCombineResult<? extends AbstractObsidanumChestBlockEntity> combine(BlockState blockState, Level level, BlockPos blockPos, boolean ignoreBlockedChest) {
        BiPredicate<LevelAccessor, BlockPos> biPredicate = ignoreBlockedChest ? (levelAccessor, blockPos1) -> false : AbstractObsidanumChestBlock::isChestBlockedAt;
        return DoubleBlockCombiner.m_52822_(this.blockEntityType.get(), AbstractObsidanumChestBlock::getBlockType, AbstractObsidanumChestBlock::getConnectedDirection, (DirectionProperty)FACING, (BlockState)blockState, (LevelAccessor)level, (BlockPos)blockPos, biPredicate);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState blockState, Level level, BlockPos blockPos) {
        return ((Optional)this.combine(blockState, level, blockPos, false).m_5649_(MENU_PROVIDER_COMBINER)).orElse(null);
    }

    public static DoubleBlockCombiner.Combiner<AbstractObsidanumChestBlockEntity, Float2FloatFunction> opennessCombiner(final LidBlockEntity lidBlockEntity) {
        return new DoubleBlockCombiner.Combiner<AbstractObsidanumChestBlockEntity, Float2FloatFunction>(){

            public Float2FloatFunction acceptDouble(AbstractObsidanumChestBlockEntity blockEntityOne, AbstractObsidanumChestBlockEntity blockEntityTwo) {
                return lidBlockEntity -> Math.max(blockEntityOne.m_6683_(lidBlockEntity), blockEntityTwo.m_6683_(lidBlockEntity));
            }

            public Float2FloatFunction acceptSingle(AbstractObsidanumChestBlockEntity blockEntity) {
                return blockEntity::m_6683_;
            }

            public Float2FloatFunction acceptNone() {
                return arg_0 -> ((LidBlockEntity)lidBlockEntity).m_6683_(arg_0);
            }
        };
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? AbstractObsidanumChestBlock.m_152132_(blockEntityType, this.blockEntityType(), AbstractObsidanumChestBlockEntity::lidAnimateTick) : null;
    }

    public static boolean isChestBlockedAt(LevelAccessor levelAccessor, BlockPos blockPos) {
        return AbstractObsidanumChestBlock.isBlockedChestByBlock((BlockGetter)levelAccessor, blockPos) || AbstractObsidanumChestBlock.isCatSittingOnChest(levelAccessor, blockPos);
    }

    private static boolean isBlockedChestByBlock(BlockGetter blockGetter, BlockPos blockPos) {
        BlockPos above = blockPos.m_7494_();
        return blockGetter.m_8055_(above).m_60796_(blockGetter, above);
    }

    private static boolean isCatSittingOnChest(LevelAccessor levelAccessor, BlockPos blockPos) {
        List list = levelAccessor.m_45976_(Cat.class, new AABB((double)blockPos.m_123341_(), (double)(blockPos.m_123342_() + 1), (double)blockPos.m_123343_(), (double)(blockPos.m_123341_() + 1), (double)(blockPos.m_123342_() + 2), (double)(blockPos.m_123343_() + 1)));
        if (!list.isEmpty()) {
            for (Cat cat : list) {
                if (!cat.m_21825_()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_7278_(BlockState blockState) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level level, BlockPos blockPos) {
        return AbstractContainerMenu.m_38938_((Container)AbstractObsidanumChestBlock.getContainer(this, blockState, level, blockPos, false));
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.m_61104_(new Property[]{FACING, WATERLOGGED});
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource random) {
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof AbstractObsidanumChestBlockEntity) {
            ((AbstractObsidanumChestBlockEntity)blockEntity).recheckOpen();
        }
    }

    @Nullable
    public static ObsidanumChestsTypes getTypeFromItem(Item itemIn) {
        return AbstractObsidanumChestBlock.getTypeFromBlock(Block.m_49814_((Item)itemIn));
    }

    @Nullable
    public static ObsidanumChestsTypes getTypeFromBlock(Block block) {
        return block instanceof AbstractObsidanumChestBlock ? ((AbstractObsidanumChestBlock)block).getType() : null;
    }

    public ObsidanumChestsTypes getType() {
        return this.type;
    }
}

