/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.chests.inventory;

import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rezolv.obsidanum.chests.block.ObsidanumChestsTypes;
import net.rezolv.obsidanum.chests.inventory.ObsidanumChestsContainerTypes;

public class ObsidanumChestMenu
extends AbstractContainerMenu {
    private final Container container;
    private final ObsidanumChestsTypes chestType;

    private ObsidanumChestMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory) {
        this(menuType, containerId, playerInventory, (Container)new SimpleContainer(ObsidanumChestsTypes.WOOD.size), ObsidanumChestsTypes.WOOD);
    }

    public static ObsidanumChestMenu createAzureObsidianContainer(int containerId, Inventory playerInventory) {
        return new ObsidanumChestMenu((MenuType)ObsidanumChestsContainerTypes.AZURE_OBSIDIAN_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(ObsidanumChestsTypes.AZURE_OBSIDIAN.size), ObsidanumChestsTypes.AZURE_OBSIDIAN);
    }

    public static ObsidanumChestMenu createAzureObsidianContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new ObsidanumChestMenu((MenuType)ObsidanumChestsContainerTypes.AZURE_OBSIDIAN_CHEST.get(), containerId, playerInventory, inventory, ObsidanumChestsTypes.AZURE_OBSIDIAN);
    }

    public static ObsidanumChestMenu createObsidianContainer(int containerId, Inventory playerInventory) {
        return new ObsidanumChestMenu((MenuType)ObsidanumChestsContainerTypes.OBSIDIAN_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(ObsidanumChestsTypes.OBSIDIAN.size), ObsidanumChestsTypes.OBSIDIAN);
    }

    public static ObsidanumChestMenu createObsidianContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new ObsidanumChestMenu((MenuType)ObsidanumChestsContainerTypes.OBSIDIAN_CHEST.get(), containerId, playerInventory, inventory, ObsidanumChestsTypes.OBSIDIAN);
    }

    public static ObsidanumChestMenu createRunicObsidianContainer(int containerId, Inventory playerInventory) {
        return new ObsidanumChestMenu((MenuType)ObsidanumChestsContainerTypes.RUNIC_OBSIDIAN_CHEST.get(), containerId, playerInventory, (Container)new SimpleContainer(ObsidanumChestsTypes.RUNIC_OBSIDIAN.size), ObsidanumChestsTypes.RUNIC_OBSIDIAN);
    }

    public static ObsidanumChestMenu createRunicObsidianContainer(int containerId, Inventory playerInventory, Container inventory) {
        return new ObsidanumChestMenu((MenuType)ObsidanumChestsContainerTypes.RUNIC_OBSIDIAN_CHEST.get(), containerId, playerInventory, inventory, ObsidanumChestsTypes.RUNIC_OBSIDIAN);
    }

    protected ObsidanumChestMenu(@Nullable MenuType<?> menuType, int containerId, Inventory playerInventory, Container inventory, ObsidanumChestsTypes chestType) {
        super(menuType, containerId);
        ObsidanumChestMenu.m_38869_((Container)inventory, (int)chestType.size);
        this.container = inventory;
        this.chestType = chestType;
        inventory.m_5856_(playerInventory.f_35978_);
        for (int chestRow = 0; chestRow < chestType.getRowCount(); ++chestRow) {
            for (int chestCol = 0; chestCol < chestType.rowLength; ++chestCol) {
                this.m_38897_(new Slot(inventory, chestCol + chestRow * chestType.rowLength, 12 + chestCol * 18, 18 + chestRow * 18));
            }
        }
        int leftCol = (chestType.xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.m_38897_(new Slot((Container)playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, chestType.ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotHarSlot = 0; hotHarSlot < 9; ++hotHarSlot) {
            this.m_38897_(new Slot((Container)playerInventory, hotHarSlot, leftCol + hotHarSlot * 18, chestType.ySize - 24));
        }
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.chestType.size ? !this.m_38903_(itemstack1, this.chestType.size, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.chestType.size, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.container.m_5785_(playerIn);
    }

    public Container getContainer() {
        return this.container;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ObsidanumChestsTypes getChestType() {
        return this.chestType;
    }
}

