/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.effect.effects.effect_overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.rezolv.obsidanum.effect.EffectsObs;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class CustomHeartsRenderer {
    private static final ResourceLocation CUSTOM_HEARTS = new ResourceLocation("obsidanum", "textures/gui/custom_hearts.png");
    private static final int HEART_WIDTH = 9;
    private static final int HEART_HEIGHT = 9;
    private static final int U_EMPTY = 0;
    private static final int U_FULL = 9;
    private static final int U_HALF = 18;
    private static final int V_ALL = 0;

    @SubscribeEvent
    public static void onRenderHealthBar(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() == VanillaGuiOverlay.PLAYER_HEALTH.type()) {
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player == null) {
                return;
            }
            if (player.m_7500_() || player.m_5833_()) {
                return;
            }
            MobEffectInstance flashEffect = player.m_21124_((MobEffect)EffectsObs.MOROK.get());
            if (flashEffect != null) {
                event.setCanceled(true);
                CustomHeartsRenderer.drawCustomHearts(event.getGuiGraphics(), player, event.getWindow().m_85445_(), event.getWindow().m_85446_());
            }
        }
    }

    private static void drawCustomHearts(GuiGraphics guiGraphics, LocalPlayer player, int screenWidth, int screenHeight) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float health = player.m_21223_();
        int maxHealth = (int)player.m_21233_();
        int heartsCount = (int)Math.ceil((double)maxHealth / 2.0);
        int xBase = screenWidth / 2 - 91;
        int yBase = screenHeight - 39;
        for (int i = 0; i < heartsCount; ++i) {
            int x = xBase + i * 8;
            float remainingHealth = health - (float)(i * 2);
            if (remainingHealth >= 2.0f) {
                CustomHeartsRenderer.blitHeart(guiGraphics, x, yBase, 9, 0);
                continue;
            }
            if (remainingHealth >= 1.0f) {
                CustomHeartsRenderer.blitHeart(guiGraphics, x, yBase, 18, 0);
                continue;
            }
            CustomHeartsRenderer.blitHeart(guiGraphics, x, yBase, 0, 0);
        }
        RenderSystem.disableBlend();
    }

    private static void blitHeart(GuiGraphics guiGraphics, int x, int y, int u, int v) {
        guiGraphics.m_280163_(CUSTOM_HEARTS, x, y, (float)u, (float)v, 9, 9, 27, 9);
    }
}

