/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.effect.effects.effect_overlay;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.rezolv.obsidanum.effect.EffectsObs;
import net.rezolv.obsidanum.item.item_entity.pot_grenade.fog.PotGrenadeFog;

@Mod.EventBusSubscriber(modid="obsidanum")
public class FogEffectHandler {
    private static final Map<UUID, PlayerFogState> SERVER_PLAYER_STATES = new HashMap<UUID, PlayerFogState>();
    private static final int FIRST_EFFECT_DELAY = 100;
    private static final int SECOND_EFFECT_DELAY = 200;
    private static final int EFFECT_DURATION = 400;
    private static final int FIRST_EFFECT_LEVEL = 0;
    private static final int SECOND_EFFECT_LEVEL = 1;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !(event.player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        UUID playerId = player.m_20148_();
        boolean inFog = FogEffectHandler.isPlayerInFog(player);
        PlayerFogState state = SERVER_PLAYER_STATES.computeIfAbsent(playerId, k -> new PlayerFogState());
        if (inFog) {
            ++state.ticksInFog;
            if (state.ticksInFog >= 200 && !state.secondEffectGiven) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectsObs.MOROK.get(), 400, 1, false, true));
                state.secondEffectGiven = true;
                state.firstEffectGiven = true;
            } else if (state.ticksInFog >= 100 && !state.firstEffectGiven) {
                player.m_7292_(new MobEffectInstance((MobEffect)EffectsObs.MOROK.get(), 400, 0, false, true));
                state.firstEffectGiven = true;
            }
        } else {
            state.reset();
        }
    }

    private static boolean isPlayerInFog(ServerPlayer player) {
        return !player.m_9236_().m_45976_(PotGrenadeFog.class, player.m_20191_()).isEmpty();
    }

    private static class PlayerFogState {
        int ticksInFog = 0;
        boolean firstEffectGiven = false;
        boolean secondEffectGiven = false;

        private PlayerFogState() {
        }

        void reset() {
            this.ticksInFog = 0;
            this.firstEffectGiven = false;
            this.secondEffectGiven = false;
        }
    }
}

