/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.effect.effects.effect_overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.rezolv.obsidanum.item.item_entity.pot_grenade.fog.PotGrenadeFog;

public class PreConfusionOverlay {
    private static final ResourceLocation[] OVERLAY_TEXTURES = new ResourceLocation[]{new ResourceLocation("obsidanum", "textures/overlay/morok_stage_1.png"), new ResourceLocation("obsidanum", "textures/overlay/morok_stage_2.png")};
    private static final float MAX_EXPOSURE_TIME_LVL1 = 100.0f;
    private static final float MAX_EXPOSURE_TIME_LVL2 = 200.0f;
    private static final float FADE_IN_SPEED = 0.4f;
    private static final float FADE_OUT_SPEED = 2.5f;
    private static final Map<UUID, PlayerFogState> playerStates = new HashMap<UUID, PlayerFogState>();
    public static final IGuiOverlay PRE_CONFUSION_OVERLAY = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        UUID playerId = player.m_20148_();
        PlayerFogState state = playerStates.computeIfAbsent(playerId, k -> new PlayerFogState());
        boolean currentlyInFog = PreConfusionOverlay.isPlayerInFog((Player)player);
        state.fogExposureTime = currentlyInFog ? Mth.m_14036_((float)(state.fogExposureTime + 0.4f), (float)0.0f, (float)200.0f) : Mth.m_14036_((float)(state.fogExposureTime - 2.5f), (float)0.0f, (float)200.0f);
        if (state.fogExposureTime > 0.0f) {
            float stage1Progress = Mth.m_14036_((float)(state.fogExposureTime / 100.0f), (float)0.0f, (float)1.0f);
            float stage1Alpha = PreConfusionOverlay.smoothStep(0.1f, 0.7f, stage1Progress);
            PreConfusionOverlay.drawOverlay(guiGraphics, OVERLAY_TEXTURES[0], stage1Alpha, screenWidth, screenHeight);
            if (state.fogExposureTime > 100.0f) {
                float stage2Progress = Mth.m_14036_((float)((state.fogExposureTime - 100.0f) / 100.0f), (float)0.0f, (float)1.0f);
                float stage2Alpha = PreConfusionOverlay.smoothStep(0.2f, 0.8f, stage2Progress);
                PreConfusionOverlay.drawOverlay(guiGraphics, OVERLAY_TEXTURES[1], stage2Alpha, screenWidth, screenHeight);
            }
        }
        playerStates.keySet().removeIf(uuid -> {
            if (minecraft.f_91073_ == null) {
                return true;
            }
            Player p = minecraft.f_91073_.m_46003_(uuid);
            return p == null || !p.m_6084_();
        });
    };

    private static float smoothStep(float edge0, float edge1, float x) {
        x = Mth.m_14036_((float)((x - edge0) / (edge1 - edge0)), (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    private static boolean isPlayerInFog(Player player) {
        return !player.m_9236_().m_45976_(PotGrenadeFog.class, player.m_20191_()).isEmpty();
    }

    private static void drawOverlay(GuiGraphics guiGraphics, ResourceLocation texture, float alpha, int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_(0.0, (double)height, 0.0).m_7421_(0.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)width, (double)height, 0.0).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_5483_((double)width, 0.0, 0.0).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 0.0f).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
    }

    private static class PlayerFogState {
        float fogExposureTime = 0.0f;

        private PlayerFogState() {
        }
    }
}

