/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.rezolv.obsidanum.Obsidanum;
import net.rezolv.obsidanum.damage_source.ObsidianTotemDamageSource;
import net.rezolv.obsidanum.event.TotemAnimationMessage;
import net.rezolv.obsidanum.item.ItemsObs;
import net.rezolv.obsidanum.sound.SoundsObs;

@Mod.EventBusSubscriber
public class EventObsidianTotemImmortal {
    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        ItemStack totem;
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21223_() - event.getAmount() <= 0.0f && !(totem = EventObsidianTotemImmortal.getObsidianTotem((Player)player)).m_41619_()) {
            event.setCanceled(true);
            EventObsidianTotemImmortal.revivePlayer((Player)player);
            Obsidanum.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new TotemAnimationMessage());
            EventObsidianTotemImmortal.playSound((LevelAccessor)player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundsObs.OBSIDIAN_TOTEM.get());
            EventObsidianTotemImmortal.applyTotemEffects((Player)player);
            totem.m_41774_(1);
            EventObsidianTotemImmortal.pushAndDamageNearbyEntities((Player)player);
            EventObsidianTotemImmortal.spawnPortalParticles((LevelAccessor)player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_());
        }
    }

    public static void spawnPortalParticles(LevelAccessor world, double x, double y, double z) {
        if (world instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)world;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, x, y, z, 80, 2.0, 2.0, 2.0, 0.2);
        }
    }

    public static void playSound(LevelAccessor world, double x, double y, double z, SoundEvent sound) {
        world.m_5594_(null, BlockPos.m_274561_((double)x, (double)y, (double)z), sound, SoundSource.NEUTRAL, 1.0f, 2.0f);
    }

    private static ItemStack getObsidianTotem(Player player) {
        if (player.m_21206_().m_41720_() == ItemsObs.OBSIDIAN_TOTEM_OF_IMMORTALITY.get()) {
            return player.m_21206_();
        }
        if (player.m_21205_().m_41720_() == ItemsObs.OBSIDIAN_TOTEM_OF_IMMORTALITY.get()) {
            return player.m_21205_();
        }
        return ItemStack.f_41583_;
    }

    private static void revivePlayer(Player player) {
        player.m_21153_(player.m_21233_() * 0.5f);
        player.m_21219_();
    }

    private static void pushAndDamageNearbyEntities(Player player) {
        double radius = 7.0;
        AABB area = new AABB(player.m_20183_()).m_82400_(radius);
        List nearbyEntities = player.m_9236_().m_6249_((Entity)player, area, entity -> entity instanceof LivingEntity);
        for (Entity entity2 : nearbyEntities) {
            double dz;
            if (!(entity2 instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity2;
            Holder.Reference damageTypeHolder = player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("obsidanum:obsidian_totem")));
            livingEntity.m_6469_((DamageSource)new ObsidianTotemDamageSource((Holder<DamageType>)damageTypeHolder, (Entity)player), 10.0f);
            double dx = entity2.m_20185_() - player.m_20185_();
            double distance = Math.sqrt(dx * dx + (dz = entity2.m_20189_() - player.m_20189_()) * dz);
            if (distance == 0.0) continue;
            double strength = 7.0;
            entity2.m_20334_(dx / distance * strength, 0.5, dz / distance * strength);
        }
    }

    private static void applyTotemEffects(Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 3));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 700, 3));
    }
}

