/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.gui.forge_crucible.recipes_render;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.rezolv.obsidanum.Obsidanum;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;
import net.rezolv.obsidanum.gui.ObsidanumMenus;
import org.jetbrains.annotations.Nullable;

public class ForgeCrucibleGuiMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.f_39287_;
    public IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    protected ForgeCrucibleGuiMenu(@Nullable MenuType<?> pMenuType, int pContainerId, Level world, Player entity) {
        super(pMenuType, pContainerId);
        this.world = world;
        this.entity = entity;
    }

    @Nullable
    public ForgeCrucibleEntity getBlockEntity() {
        if (this.world == null) {
            return null;
        }
        BlockEntity be = this.world.m_7702_(new BlockPos(this.x, this.y, this.z));
        return be instanceof ForgeCrucibleEntity ? (ForgeCrucibleEntity)be : null;
    }

    public ForgeCrucibleGuiMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ObsidanumMenus.FORGE_CRUCIBLE_GUI.get(), id);
        int si;
        this.entity = inv.f_35978_;
        this.world = inv.f_35978_.m_9236_();
        BlockPos pos = extraData.m_130135_();
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.access = ContainerLevelAccess.m_39289_((Level)this.world, (BlockPos)pos);
        final ForgeCrucibleEntity blockEntity = (ForgeCrucibleEntity)this.world.m_7702_(pos);
        if (blockEntity != null) {
            this.internal = blockEntity.itemHandler;
            this.bound = true;
        } else {
            this.internal = new ItemStackHandler(12);
        }
        this.m_38897_((Slot)new SlotItemHandler(this.internal, 6, 118, 26){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(this.internal, 7, 118, 52){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(this.internal, 8, 98, 49){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(this.internal, 9, 138, 49){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(this.internal, 10, 78, 46){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.m_38897_((Slot)new SlotItemHandler(this.internal, 11, 158, 46){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (int i = 0; i < 6; ++i) {
            final int slotIndex = i;
            this.m_38897_((Slot)new SlotItemHandler(this.internal, slotIndex, 74 + i * 18, 73){

                public boolean m_5857_(ItemStack stack) {
                    if (blockEntity == null) {
                        return false;
                    }
                    CompoundTag data = blockEntity.getReceivedData();
                    if (!data.m_128441_("Ingredients")) {
                        return false;
                    }
                    ListTag ingredients = data.m_128437_("Ingredients", 10);
                    if (slotIndex >= ingredients.size()) {
                        return false;
                    }
                    try {
                        CompoundTag entry = ingredients.m_128728_(slotIndex);
                        JsonObject json = JsonParser.parseString((String)entry.m_128461_("IngredientJson")).getAsJsonObject();
                        return ForgeCrucibleGuiMenu.this.matchesIngredient(stack, json);
                    }
                    catch (Exception e) {
                        Obsidanum.LOGGER.error("Error checking ingredient match: {}", (Object)e.getMessage());
                        return false;
                    }
                }
            });
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.m_38897_(new Slot((Container)inv, sj + (si + 1) * 9, 47 + sj * 18, 131 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.m_38897_(new Slot((Container)inv, si, 47 + si * 18, 189));
        }
    }

    private boolean matchesIngredient(ItemStack stack, JsonObject ingredientJson) {
        if (stack.m_41619_()) {
            return false;
        }
        if (ingredientJson.has("item")) {
            ResourceLocation itemId = new ResourceLocation(ingredientJson.get("item").getAsString());
            return ForgeRegistries.ITEMS.getValue(itemId) == stack.m_41720_();
        }
        if (ingredientJson.has("tag")) {
            ResourceLocation tagId = new ResourceLocation(ingredientJson.get("tag").getAsString());
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
            return stack.m_204117_(tag);
        }
        return false;
    }

    public boolean m_6875_(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.m_58900_().m_60734_());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.m_6084_();
            }
        }
        return true;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack copiedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack originalStack = slot.m_7993_();
            copiedStack = originalStack.m_41777_();
            if (index >= 12 ? !this.m_38903_(originalStack, 0, 12, false) : !this.m_38903_(originalStack, 12, 48, false)) {
                return ItemStack.f_41583_;
            }
            if (originalStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (originalStack.m_41613_() == copiedStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, originalStack);
        }
        return copiedStack;
    }

    protected boolean m_38903_(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return super.m_38903_(stack, startIndex, endIndex, reverseDirection);
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

