/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.gui.forge_crucible.recipes_render.render_types;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.rezolv.obsidanum.Obsidanum;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;
import net.rezolv.obsidanum.gui.forge_crucible.recipes_render.ForgeCrucibleGuiMenu;

public class RecipeIngredientsRenderer {
    private static final ResourceLocation[] INGREDIENT_TEXTURES = new ResourceLocation[]{new ResourceLocation("obsidanum:textures/gui/forge_crucible_ingredients_no.png"), new ResourceLocation("obsidanum:textures/gui/forge_crucible_ingredients_yes.png")};
    private static final int SLOT_SIZE = 18;
    private static final int MAX_SLOTS = 6;
    private static final int START_X_OFFSET = 74;
    private static final int START_Y_OFFSET = 73;

    public static void render(GuiGraphics guiGraphics, Font font, ForgeCrucibleGuiMenu menu, Level level, BlockPos pos, int leftPos, int topPos) {
        ForgeCrucibleEntity crucible = RecipeIngredientsRenderer.getCrucible(level, pos);
        if (crucible == null) {
            return;
        }
        CompoundTag data = crucible.getReceivedData();
        if (!data.m_128441_("Ingredients")) {
            return;
        }
        ListTag ingredients = data.m_128437_("Ingredients", 10);
        if (ingredients.isEmpty()) {
            return;
        }
        RecipeIngredientsRenderer.renderIngredients(guiGraphics, font, menu, crucible, ingredients, leftPos, topPos);
    }

    private static ForgeCrucibleEntity getCrucible(Level level, BlockPos pos) {
        ForgeCrucibleEntity crucible;
        BlockEntity be = level.m_7702_(pos);
        return be instanceof ForgeCrucibleEntity ? (crucible = (ForgeCrucibleEntity)be) : null;
    }

    private static void renderIngredients(GuiGraphics guiGraphics, Font font, ForgeCrucibleGuiMenu menu, ForgeCrucibleEntity crucible, ListTag ingredients, int leftPos, int topPos) {
        int startX = leftPos + 74;
        int startY = topPos + 73;
        for (int i = 0; i < Math.min(6, ingredients.size()); ++i) {
            CompoundTag entry = ingredients.m_128728_(i);
            try {
                RecipeIngredientsRenderer.renderIngredientSlot(guiGraphics, font, menu, crucible, entry, i, startX, startY);
                continue;
            }
            catch (Exception e) {
                Obsidanum.LOGGER.error("Failed to render ingredient: {}", (Object)e.getMessage());
            }
        }
    }

    private static void renderIngredientSlot(GuiGraphics guiGraphics, Font font, ForgeCrucibleGuiMenu menu, ForgeCrucibleEntity crucible, CompoundTag entry, int slotIndex, int startX, int startY) throws Exception {
        boolean hasEnough;
        JsonObject json = JsonParser.parseString((String)entry.m_128461_("IngredientJson")).getAsJsonObject();
        int requiredCount = json.has("count") ? json.get("count").getAsInt() : 1;
        ItemStack displayStack = RecipeIngredientsRenderer.getDisplayStackForIngredient(json, slotIndex);
        if (displayStack.m_41619_()) {
            return;
        }
        Ingredient ingredient = RecipeIngredientsRenderer.getIngredientFromJson(json);
        int x = startX + slotIndex * 18;
        int y = startY;
        ItemStack slotStack = menu.internal.getStackInSlot(slotIndex);
        boolean satisfied = hasEnough = ingredient.test(slotStack) && slotStack.m_41613_() >= requiredCount;
        RecipeIngredientsRenderer.renderSlotBackground(guiGraphics, x, y, slotStack, hasEnough);
        RecipeIngredientsRenderer.renderIngredientItem(guiGraphics, font, displayStack, slotStack, satisfied, x, y, requiredCount);
    }

    private static void renderSlotBackground(GuiGraphics guiGraphics, int x, int y, ItemStack slotStack, boolean hasEnough) {
        if (!slotStack.m_41619_()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            int frame = RecipeIngredientsRenderer.getAnimationFrame();
            int textureIndex = hasEnough ? 1 : 0;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280163_(INGREDIENT_TEXTURES[textureIndex], x, y, 0.0f, (float)(frame * 16), 16, 16, 16, 128);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private static void renderIngredientItem(GuiGraphics guiGraphics, Font font, ItemStack displayStack, ItemStack slotStack, boolean satisfied, int x, int y, int requiredCount) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        if (!satisfied) {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
            guiGraphics.m_280480_(displayStack, x, y);
            RecipeIngredientsRenderer.renderCountText(guiGraphics, font, x, y, requiredCount);
        }
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        guiGraphics.m_280168_().m_85849_();
    }

    private static int getAnimationFrame() {
        return (int)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * 8.0f);
    }

    private static void renderCountText(GuiGraphics guiGraphics, Font font, int x, int y, int count) {
        String countText = String.valueOf(count);
        int textWidth = font.m_92895_(countText);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        guiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
        int textX = (int)(((float)(x + 16) - (float)textWidth * 0.75f) / 0.75f);
        int textY = (int)((float)(y + 11) / 0.75f);
        guiGraphics.m_280056_(font, countText, textX + 1, textY, 0, false);
        guiGraphics.m_280056_(font, countText, textX - 1, textY, 0, false);
        guiGraphics.m_280056_(font, countText, textX, textY + 1, 0, false);
        guiGraphics.m_280056_(font, countText, textX, textY - 1, 0, false);
        guiGraphics.m_280056_(font, countText, textX, textY, 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
    }

    public static ItemStack getDisplayStackForIngredient(JsonObject json, int slotIndex) {
        if (json.has("item")) {
            ResourceLocation itemId = new ResourceLocation(json.get("item").getAsString());
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            return item != null ? new ItemStack((ItemLike)item) : ItemStack.f_41583_;
        }
        if (json.has("tag")) {
            ResourceLocation tagId = new ResourceLocation(json.get("tag").getAsString());
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
            List items = ForgeRegistries.ITEMS.tags().getTag(tag).stream().toList();
            if (items.isEmpty()) {
                return ItemStack.f_41583_;
            }
            int idx = (int)(System.currentTimeMillis() / 500L % (long)items.size());
            return new ItemStack((ItemLike)items.get(idx));
        }
        return ItemStack.f_41583_;
    }

    public static Ingredient getIngredientFromJson(JsonObject json) {
        return Ingredient.m_43917_((JsonElement)json);
    }
}

