/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.gui.forge_crucible.recipes_render.render_types;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.rezolv.obsidanum.Obsidanum;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;

public class RecipeResultRenderer {
    private static final ResourceLocation[] RESULT_TEXTURES = new ResourceLocation[]{new ResourceLocation("obsidanum:textures/gui/forge_crucible_res_no.png"), new ResourceLocation("obsidanum:textures/gui/forge_crucible_res_yes.png")};

    public static void render(GuiGraphics guiGraphics, Font font, ForgeCrucibleEntity blockEntity, int leftPos, int topPos) {
        if (blockEntity == null) {
            return;
        }
        int xPos = leftPos + 118;
        int yPos = topPos + 26;
        ItemStack currentResult = blockEntity.itemHandler.getStackInSlot(6);
        CompoundTag data = blockEntity.getReceivedData();
        if (!data.m_128441_("Ingredients")) {
            RecipeResultRenderer.renderSimpleResult(guiGraphics, font, currentResult, xPos, yPos);
            return;
        }
        ListTag ingredients = data.m_128437_("Ingredients", 10);
        if (ingredients.isEmpty()) {
            RecipeResultRenderer.renderSimpleResult(guiGraphics, font, currentResult, xPos, yPos);
            return;
        }
        IngredientCheckResult checkResult = RecipeResultRenderer.checkIngredients(blockEntity, ingredients);
        if (checkResult.allEmpty()) {
            RecipeResultRenderer.renderEmptyState(guiGraphics, font, currentResult, data, xPos, yPos);
            return;
        }
        RecipeResultRenderer.renderAnimatedResult(guiGraphics, font, currentResult, data, xPos, yPos, checkResult.allSatisfied());
    }

    private static IngredientCheckResult checkIngredients(ForgeCrucibleEntity blockEntity, ListTag ingredients) {
        boolean allEmpty = true;
        boolean allSatisfied = true;
        for (int i = 0; i < Math.min(6, ingredients.size()); ++i) {
            JsonObject json;
            CompoundTag entry = ingredients.m_128728_(i);
            try {
                json = JsonParser.parseString((String)entry.m_128461_("IngredientJson")).getAsJsonObject();
            }
            catch (Exception e) {
                Obsidanum.LOGGER.error("Error parsing ingredient JSON: {}", (Object)e.getMessage());
                continue;
            }
            int requiredCount = json.has("count") ? json.get("count").getAsInt() : 1;
            ItemStack stackInSlot = blockEntity.itemHandler.getStackInSlot(i);
            if (!stackInSlot.m_41619_()) {
                allEmpty = false;
            }
            if (stackInSlot.m_41613_() >= requiredCount) continue;
            allSatisfied = false;
        }
        return new IngredientCheckResult(allEmpty, allSatisfied);
    }

    private static void renderSimpleResult(GuiGraphics guiGraphics, Font font, ItemStack currentResult, int xPos, int yPos) {
        if (!currentResult.m_41619_()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            int frame = RecipeResultRenderer.getAnimationFrame();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            guiGraphics.m_280163_(RESULT_TEXTURES[1], xPos - 4, yPos - 4, 0.0f, (float)(frame * 24), 24, 24, 24, 192);
            RenderSystem.disableBlend();
            guiGraphics.m_280480_(currentResult, xPos, yPos);
            guiGraphics.m_280370_(font, currentResult, xPos, yPos);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private static void renderEmptyState(GuiGraphics guiGraphics, Font font, ItemStack currentResult, CompoundTag data, int xPos, int yPos) {
        if (!currentResult.m_41619_()) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
            guiGraphics.m_280480_(currentResult, xPos, yPos);
            guiGraphics.m_280370_(font, currentResult, xPos, yPos);
            guiGraphics.m_280168_().m_85849_();
        } else if (data.m_128425_("RecipeResult", 9)) {
            RecipeResultRenderer.renderResultPreview(guiGraphics, font, data, xPos, yPos);
        }
    }

    private static void renderAnimatedResult(GuiGraphics guiGraphics, Font font, ItemStack currentResult, CompoundTag data, int xPos, int yPos, boolean allSatisfied) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 100.0f);
        int textureIndex = allSatisfied ? 1 : 0;
        int frame = RecipeResultRenderer.getAnimationFrame();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.m_280163_(RESULT_TEXTURES[textureIndex], xPos - 4, yPos - 4, 0.0f, (float)(frame * 24), 24, 24, 24, 192);
        RenderSystem.disableBlend();
        if (!currentResult.m_41619_()) {
            guiGraphics.m_280480_(currentResult, xPos, yPos);
            guiGraphics.m_280370_(font, currentResult, xPos, yPos);
        } else {
            RecipeResultRenderer.renderResultPreview(guiGraphics, font, data, xPos, yPos);
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private static void renderResultPreview(GuiGraphics guiGraphics, Font font, CompoundTag data, int xPos, int yPos) {
        ItemStack resultStack;
        ListTag resultList = data.m_128437_("RecipeResult", 10);
        if (!resultList.isEmpty() && !(resultStack = ItemStack.m_41712_((CompoundTag)resultList.m_128728_(0))).m_41619_()) {
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
            guiGraphics.m_280480_(resultStack, xPos, yPos);
            if (resultStack.m_41613_() > 1) {
                RecipeResultRenderer.renderCountText(guiGraphics, font, xPos, yPos, resultStack.m_41613_());
            }
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static int getAnimationFrame() {
        return (int)((float)(System.currentTimeMillis() % 1000L) / 1000.0f * 8.0f);
    }

    private static void renderCountText(GuiGraphics guiGraphics, Font font, int x, int y, int count) {
        String countText = String.valueOf(count);
        int textWidth = font.m_92895_(countText);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
        guiGraphics.m_280168_().m_85841_(0.75f, 0.75f, 1.0f);
        int textX = (int)(((float)(x + 16) - (float)textWidth * 0.75f) / 0.75f);
        int textY = (int)((float)(y + 11) / 0.75f);
        guiGraphics.m_280056_(font, countText, textX + 1, textY, 0, false);
        guiGraphics.m_280056_(font, countText, textX - 1, textY, 0, false);
        guiGraphics.m_280056_(font, countText, textX, textY + 1, 0, false);
        guiGraphics.m_280056_(font, countText, textX, textY - 1, 0, false);
        guiGraphics.m_280056_(font, countText, textX, textY, 0xFFFFFF, false);
        guiGraphics.m_280168_().m_85849_();
    }

    private record IngredientCheckResult(boolean allEmpty, boolean allSatisfied) {
    }
}

