/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.gui.forge_crucible.recipes_render.render_types;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.rezolv.obsidanum.block.custom.ForgeCrucible;
import net.rezolv.obsidanum.block.custom.RightForgeScroll;
import net.rezolv.obsidanum.block.entity.ForgeCrucibleEntity;
import net.rezolv.obsidanum.block.entity.RightForgeScrollEntity;
import net.rezolv.obsidanum.block.enum_blocks.ScrollType;
import net.rezolv.obsidanum.item.ItemsObs;

public class ScrollItemRenderer {
    public static void render(GuiGraphics guiGraphics, Font font, Level world, int x, int y, int z, int leftPos, int topPos) {
        ForgeCrucibleEntity crucible = ScrollItemRenderer.getCrucible(world, x, y, z);
        if (crucible == null) {
            return;
        }
        BlockPos scrollPos = ScrollItemRenderer.findScrollPosition(crucible);
        if (scrollPos == null) {
            return;
        }
        RightForgeScrollEntity scroll = ScrollItemRenderer.getScrollEntity(world, scrollPos);
        if (scroll == null) {
            return;
        }
        ItemStack scrollStack = ScrollItemRenderer.prepareScrollStack(world, scrollPos, scroll);
        if (scrollStack.m_41619_()) {
            return;
        }
        ScrollItemRenderer.renderScroll(guiGraphics, font, scrollStack, leftPos, topPos);
    }

    private static ForgeCrucibleEntity getCrucible(Level world, int x, int y, int z) {
        ForgeCrucibleEntity crucible;
        BlockEntity blockEntity = world.m_7702_(new BlockPos(x, y, z));
        return blockEntity instanceof ForgeCrucibleEntity ? (crucible = (ForgeCrucibleEntity)blockEntity) : null;
    }

    private static BlockPos findScrollPosition(ForgeCrucibleEntity crucible) {
        Direction facing = (Direction)crucible.m_58900_().m_61143_((Property)ForgeCrucible.FACING);
        return switch (facing) {
            case Direction.NORTH -> crucible.m_58899_().m_122024_();
            case Direction.SOUTH -> crucible.m_58899_().m_122029_();
            case Direction.EAST -> crucible.m_58899_().m_122012_();
            case Direction.WEST -> crucible.m_58899_().m_122019_();
            default -> null;
        };
    }

    private static RightForgeScrollEntity getScrollEntity(Level world, BlockPos scrollPos) {
        RightForgeScrollEntity scroll;
        BlockEntity scrollEntity = world.m_7702_(scrollPos);
        return scrollEntity instanceof RightForgeScrollEntity ? (scroll = (RightForgeScrollEntity)scrollEntity) : null;
    }

    private static ItemStack prepareScrollStack(Level world, BlockPos scrollPos, RightForgeScrollEntity scroll) {
        ScrollType scrollType = (ScrollType)((Object)world.m_8055_(scrollPos).m_61143_(RightForgeScroll.TYPE_SCROLL));
        if (scrollType == ScrollType.NONE) {
            return ItemStack.f_41583_;
        }
        ItemStack scrollStack = ScrollItemRenderer.getScrollItemStack(scrollType);
        CompoundTag nbt = scroll.getScrollNBT();
        if (!nbt.m_128456_()) {
            scrollStack.m_41751_(nbt.m_6426_());
        }
        return scrollStack;
    }

    private static void renderScroll(GuiGraphics guiGraphics, Font font, ItemStack scrollStack, int leftPos, int topPos) {
        int scrollX = leftPos + 119;
        int scrollY = topPos + 105;
        guiGraphics.m_280480_(scrollStack, scrollX, scrollY);
        guiGraphics.m_280370_(font, scrollStack, scrollX, scrollY);
    }

    private static ItemStack getScrollItemStack(ScrollType type) {
        return switch (type) {
            case ScrollType.NETHER -> ((Item)ItemsObs.NETHER_PLAN.get()).m_7968_();
            case ScrollType.ORDER -> ((Item)ItemsObs.ORDER_PLAN.get()).m_7968_();
            case ScrollType.CATACOMBS -> ((Item)ItemsObs.CATACOMBS_PLAN.get()).m_7968_();
            case ScrollType.UPDATE -> ((Item)ItemsObs.UPGRADE_PLAN.get()).m_7968_();
            default -> ItemStack.f_41583_;
        };
    }
}

