/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;

public class ObsidanAxe
extends AxeItem {
    private static final String ACTIVATED_TAG = "Activated";
    private static final String LAST_ACTIVATION_TAG = "LastActivationTime";
    private static final String COOLDOWN_END_TAG = "CooldownEndTime";
    private static final String DURABILITY_LOST_TAG = "DurabilityLost";
    private static final String CUSTOM_MODEL_DATA_TAG = "CustomModelData";
    private static final TagKey<Block> MINEABLE_LOGS_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "logs"));
    private static final TagKey<Block> MINEABLE_LEAVES_TAG = BlockTags.create((ResourceLocation)new ResourceLocation("minecraft", "leaves"));
    public static final long COOLDOWN_DURATION = 500L;
    private static final long ACTIVATION_DURATION = 100L;

    public ObsidanAxe(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, (float)pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){

            public float getCooldownPercent(ItemStack stack, Player player, float partialTicks) {
                long cooldownEnd;
                long currentTime = player.m_9236_().m_46467_();
                if (currentTime >= (cooldownEnd = ObsidanAxe.this.getCooldownEndTime(stack))) {
                    return 0.0f;
                }
                long cooldownDuration = 500L;
                long remaining = cooldownEnd - currentTime;
                return (float)remaining / (float)cooldownDuration;
            }
        });
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.isActivated(stack)) {
            long lastActivationTime = this.getLastActivationTime(stack);
            if (world.m_46467_() - lastActivationTime >= 100L && entity instanceof Player) {
                this.deactivate(stack, (Player)entity, world.m_46467_());
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        long currentTime = worldIn.m_46467_();
        if (!this.isActivated(stack) && currentTime >= this.getCooldownEndTime(stack)) {
            if (!worldIn.f_46443_) {
                this.activate(stack, currentTime);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public void activate(ItemStack stack, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, true);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_DATA_TAG, 1);
        stack.m_41784_().m_128379_(DURABILITY_LOST_TAG, false);
        this.setLastActivationTime(stack, currentTime);
    }

    public void deactivate(ItemStack stack, Player player, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, false);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_DATA_TAG, 0);
        stack.m_41784_().m_128379_(DURABILITY_LOST_TAG, false);
        this.setCooldownEndTime(stack, currentTime + 500L);
    }

    public boolean isActivated(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVATED_TAG);
    }

    private long getLastActivationTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(LAST_ACTIVATION_TAG);
    }

    private void setLastActivationTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(LAST_ACTIVATION_TAG, time);
    }

    private long getCooldownEndTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(COOLDOWN_END_TAG);
    }

    private void setCooldownEndTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(COOLDOWN_END_TAG, time);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.axe").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!world.f_46443_ && this.isActivated(stack) && entity instanceof Player) {
            if (state.m_204336_(MINEABLE_LOGS_TAG)) {
                this.chainBreak(world, pos, (Player)entity, stack, state);
                this.deactivate(stack, (Player)entity, world.m_46467_());
                return true;
            }
            if (state.m_204336_(MINEABLE_LEAVES_TAG)) {
                this.breakPlants(world, pos, (Player)entity, stack);
                this.deactivate(stack, (Player)entity, world.m_46467_());
                return true;
            }
            if (this.isNetherLog(state) || this.isNetherFungus(state)) {
                this.breakNetherTree(world, pos, (Player)entity, stack);
                this.deactivate(stack, (Player)entity, world.m_46467_());
                return true;
            }
        }
        return super.m_6813_(stack, world, state, pos, entity);
    }

    private boolean isNetherLog(BlockState state) {
        return state.m_60734_() == Blocks.f_50695_ || state.m_60734_() == Blocks.f_50686_;
    }

    private boolean isNetherFungus(BlockState state) {
        return state.m_60734_() == Blocks.f_50451_ || state.m_60734_() == Blocks.f_50692_ || state.m_60734_() == Blocks.f_50701_;
    }

    private void chainBreak(Level world, BlockPos pos, Player player, ItemStack stack, BlockState state) {
        if (this.isNetherLog(state) || this.isNetherFungus(state)) {
            this.breakNetherTree(world, pos, player, stack);
        } else if (state.m_204336_(MINEABLE_LOGS_TAG)) {
            this.breakTree(world, pos, player, stack);
        } else if (state.m_204336_(MINEABLE_LEAVES_TAG)) {
            this.breakPlants(world, pos, player, stack);
        }
    }

    private void breakTree(Level world, BlockPos startPos, Player player, ItemStack stack) {
        HashSet<BlockPos> logs = new HashSet<BlockPos>();
        HashSet<BlockPos> leaves = new HashSet<BlockPos>();
        Block startBlock = world.m_8055_(startPos).m_60734_();
        this.findConnectedBlocks(world, startPos, logs, startBlock, 1024);
        for (BlockPos logPos : logs) {
            this.findLeaves(world, logPos, leaves, 2048);
        }
        this.destroyBlocks(world, logs, player, stack);
        this.destroyBlocks(world, leaves, player, stack);
    }

    private void breakNetherTree(Level world, BlockPos startPos, Player player, ItemStack stack) {
        HashSet<BlockPos> netherBlocks = new HashSet<BlockPos>();
        this.findConnectedNetherTreeBlocks(world, startPos, netherBlocks, 2048);
        this.destroyBlocks(world, netherBlocks, player, stack);
    }

    private void findConnectedBlocks(Level world, BlockPos pos, Set<BlockPos> result, Block targetBlock, int max) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(pos);
        while (!queue.isEmpty() && result.size() < max) {
            BlockState state;
            BlockPos current = (BlockPos)queue.poll();
            if (result.contains(current) || (state = world.m_8055_(current)).m_60734_() != targetBlock) continue;
            result.add(current);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        if (dx == 0 && dy == 0 && dz == 0) continue;
                        queue.add(current.m_7918_(dx, dy, dz));
                    }
                }
            }
        }
    }

    private void findConnectedNetherTreeBlocks(Level world, BlockPos pos, Set<BlockPos> result, int max) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(pos);
        while (!queue.isEmpty() && result.size() < max) {
            BlockState state;
            BlockPos current = (BlockPos)queue.poll();
            if (result.contains(current) || !this.isNetherLog(state = world.m_8055_(current)) && !this.isNetherFungus(state)) continue;
            result.add(current);
            queue.add(current.m_7918_(1, 0, 0));
            queue.add(current.m_7918_(-1, 0, 0));
            queue.add(current.m_7918_(0, 0, 1));
            queue.add(current.m_7918_(0, 0, -1));
            queue.add(current.m_7918_(0, 1, 0));
            queue.add(current.m_7918_(0, -1, 0));
        }
    }

    private void findLeaves(Level world, BlockPos pos, Set<BlockPos> result, int max) {
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-5, -3, -5), (BlockPos)pos.m_7918_(5, 3, 5)).filter(p -> world.m_8055_(p).m_204336_(MINEABLE_LEAVES_TAG)).limit(max).forEach(p -> result.add(p.m_7949_()));
    }

    private void breakPlants(Level world, BlockPos pos, Player player, ItemStack stack) {
        AtomicInteger counter = new AtomicInteger(0);
        BlockPos.m_121990_((BlockPos)pos.m_7918_(-7, -3, -7), (BlockPos)pos.m_7918_(7, 3, 7)).filter(p -> world.m_8055_(p).m_204336_(MINEABLE_LEAVES_TAG)).limit(300L).forEach(p -> {
            if (counter.getAndIncrement() < 300) {
                world.m_46961_(p, true);
            }
        });
    }

    private void destroyBlocks(Level world, Collection<BlockPos> positions, Player player, ItemStack stack) {
        boolean durabilityLost = stack.m_41784_().m_128471_(DURABILITY_LOST_TAG);
        positions.forEach(p -> {
            if (p.m_123331_((Vec3i)player.m_20183_()) < 4096.0) {
                world.m_46961_(p, true);
                if (!durabilityLost) {
                    stack.m_41784_().m_128379_(DURABILITY_LOST_TAG, true);
                }
            }
        });
    }
}

