/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ObsidanPickaxe
extends PickaxeItem {
    private static final String ACTIVATED_TAG = "Activated";
    private static final String LAST_ACTIVATION_TAG = "LastActivationTime";
    private static final String COOLDOWN_END_TAG = "CooldownEndTime";
    private static final String CUSTOM_MODEL_TAG = "CustomModelData";
    public static final long COOLDOWN_DURATION = 2400L;
    private static final long ACTIVATION_DURATION = 100L;
    private static final Block[] INSTANT_BREAK_BLOCKS = new Block[]{Blocks.f_50069_, Blocks.f_50652_, Blocks.f_50228_, Blocks.f_50122_, Blocks.f_50334_, Blocks.f_152550_, Blocks.f_152551_};

    public ObsidanPickaxe(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        long lastActivationTime;
        long currentTime;
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.isActivated(stack) && (currentTime = world.m_46467_()) - (lastActivationTime = this.getLastActivationTime(stack)) >= 100L && entity instanceof Player) {
            this.deactivate(stack, (Player)entity, currentTime);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        long currentTime = worldIn.m_46467_();
        if (!this.isActivated(stack) && currentTime >= this.getCooldownEndTime(stack)) {
            if (!worldIn.f_46443_) {
                this.activate(stack, currentTime);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        Block block;
        if (!level.f_46443_ && this.isActivated(stack) && this.isInstantBreakBlock(block = state.m_60734_())) {
            level.m_46961_(pos, false);
            if (level.f_46441_.m_188501_() < 0.2f) {
                ItemStack diamond = new ItemStack((ItemLike)Items.f_42415_);
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)diamond);
            }
            if (entity instanceof Player) {
                this.deactivate(stack, (Player)entity, level.m_46467_());
            }
        }
        return super.m_6813_(stack, level, state, pos, entity);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.pickaxe").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private void activate(ItemStack stack, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, true);
        stack.m_41784_().m_128356_(LAST_ACTIVATION_TAG, currentTime);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_TAG, 1);
    }

    private void deactivate(ItemStack stack, Player player, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, false);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_TAG, 0);
        this.setCooldownEndTime(stack, currentTime + 2400L);
    }

    public boolean isActivated(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVATED_TAG);
    }

    private long getLastActivationTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(LAST_ACTIVATION_TAG);
    }

    private long getCooldownEndTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(COOLDOWN_END_TAG);
    }

    private void setCooldownEndTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(COOLDOWN_END_TAG, time);
    }

    private boolean isInstantBreakBlock(Block block) {
        for (Block instantBreakBlock : INSTANT_BREAK_BLOCKS) {
            if (block != instantBreakBlock) continue;
            return true;
        }
        return false;
    }
}

