/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ObsidanShovel
extends ShovelItem {
    private static final String ACTIVATED_TAG = "Activated";
    private static final String LAST_ACTIVATION_TAG = "LastActivationTime";
    private static final String COOLDOWN_END_TAG = "CooldownEndTime";
    private static final String CUSTOM_MODEL_TAG = "CustomModelData";
    public static final long COOLDOWN_DURATION = 1000L;
    private static final long ACTIVATION_DURATION = 100L;

    public ObsidanShovel(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, (float)pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        long lastActivationTime;
        long currentTime;
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.isActivated(stack) && (currentTime = world.m_46467_()) - (lastActivationTime = this.getLastActivationTime(stack)) >= 100L && entity instanceof Player) {
            this.deactivate(stack, (Player)entity, currentTime);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        long currentTime = worldIn.m_46467_();
        if (!this.isActivated(stack) && currentTime >= this.getCooldownEndTime(stack)) {
            if (!worldIn.f_46443_) {
                this.activate(stack, currentTime);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isActivated(stack)) {
            double knockbackY = 4.0;
            Vec3 motion = target.m_20184_();
            target.m_20334_(motion.f_82479_, knockbackY, motion.f_82481_);
            if (target instanceof Player) {
                ((Player)target).f_19864_ = true;
            }
            if (attacker instanceof Player) {
                this.deactivate(stack, (Player)attacker, attacker.m_9236_().m_46467_());
            }
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.shovel").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    private void activate(ItemStack stack, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, true);
        stack.m_41784_().m_128356_(LAST_ACTIVATION_TAG, currentTime);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_TAG, 1);
    }

    private void deactivate(ItemStack stack, Player player, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, false);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_TAG, 0);
        this.setCooldownEndTime(stack, currentTime + 1000L);
    }

    public boolean isActivated(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVATED_TAG);
    }

    private long getLastActivationTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(LAST_ACTIVATION_TAG);
    }

    private long getCooldownEndTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(COOLDOWN_END_TAG);
    }

    private void setCooldownEndTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(COOLDOWN_END_TAG, time);
    }
}

