/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.custom;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ObsidanSword
extends SwordItem {
    private static final String ACTIVATED_TAG = "Activated";
    private static final String LAST_ACTIVATION_TAG = "LastActivationTime";
    private static final String COOLDOWN_END_TAG = "CooldownEndTime";
    private static final String CUSTOM_MODEL_TAG = "CustomModelData";
    public static final long COOLDOWN_DURATION = 1600L;
    private static final long ACTIVATION_DURATION = 100L;

    public ObsidanSword(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public void m_7373_(ItemStack itemstack, Level world, List<Component> list, TooltipFlag flag) {
        super.m_7373_(itemstack, world, list, flag);
        if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift2").m_130940_(ChatFormatting.DARK_GRAY));
            list.add((Component)Component.m_237115_((String)"item.obsidan.description.sword").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.add((Component)Component.m_237115_((String)"obsidanum.press_shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        super.m_7836_(stack, world, player);
        stack.m_41784_().m_128379_(ACTIVATED_TAG, false);
        stack.m_41784_().m_128356_(LAST_ACTIVATION_TAG, 0L);
        stack.m_41784_().m_128356_(COOLDOWN_END_TAG, 0L);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        long lastActivationTime;
        long currentTime;
        super.m_6883_(stack, world, entity, slot, selected);
        if (!world.f_46443_ && this.isActivated(stack) && (currentTime = world.m_46467_()) - (lastActivationTime = this.getLastActivationTime(stack)) >= 100L && entity instanceof Player) {
            this.deactivate(stack, (Player)entity, currentTime);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        long currentTime = worldIn.m_46467_();
        if (!this.isActivated(stack) && currentTime >= this.getCooldownEndTime(stack)) {
            if (!worldIn.f_46443_) {
                this.activate(stack, currentTime);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (!player.m_7578_() && entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (this.isActivated(stack)) {
                float baseDamage = (float)player.m_21133_(Attributes.f_22281_);
                float additionalDamage = 4.0f;
                livingEntity.m_6469_(new DamageSource((Holder)player.m_20193_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_)), baseDamage * additionalDamage);
                this.deactivate(stack, player, player.m_9236_().m_46467_());
                return true;
            }
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    private void activate(ItemStack stack, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, true);
        stack.m_41784_().m_128356_(LAST_ACTIVATION_TAG, currentTime);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_TAG, 1);
    }

    private void deactivate(ItemStack stack, Player player, long currentTime) {
        stack.m_41784_().m_128379_(ACTIVATED_TAG, false);
        stack.m_41784_().m_128405_(CUSTOM_MODEL_TAG, 0);
        this.setCooldownEndTime(stack, currentTime + 1600L);
    }

    public boolean isActivated(ItemStack stack) {
        return stack.m_41784_().m_128471_(ACTIVATED_TAG);
    }

    private long getLastActivationTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(LAST_ACTIVATION_TAG);
    }

    private long getCooldownEndTime(ItemStack stack) {
        return stack.m_41784_().m_128454_(COOLDOWN_END_TAG);
    }

    private void setCooldownEndTime(ItemStack stack, long time) {
        stack.m_41784_().m_128356_(COOLDOWN_END_TAG, time);
    }
}

