/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.events_plans.right_click;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.rezolv.obsidanum.item.ItemsObs;
import net.rezolv.obsidanum.recipes.ForgeScrollNetherRecipe;
import net.rezolv.obsidanum.sound.SoundsObs;

@Mod.EventBusSubscriber(modid="obsidanum")
public class RightClickNetherPlan {
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        Level level = event.getLevel();
        ItemStack heldItem = event.getItemStack();
        if (heldItem.m_41720_() != ItemsObs.UN_NETHER_SCROLL.get() || level.m_5776_()) {
            return;
        }
        List recipes = level.m_7465_().m_44013_((RecipeType)ForgeScrollNetherRecipe.Type.FORGE_SCROLL_NETHER);
        if (recipes.isEmpty()) {
            return;
        }
        level.m_6263_(null, event.getEntity().m_20185_(), event.getEntity().m_20186_(), event.getEntity().m_20189_(), (SoundEvent)SoundsObs.LEARN.get(), SoundSource.PLAYERS, 1.0f, 0.8f + RANDOM.nextFloat() * 0.4f);
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
        ForgeScrollNetherRecipe randomRecipe = (ForgeScrollNetherRecipe)recipes.get(RANDOM.nextInt(recipes.size()));
        ItemStack planItem = new ItemStack((ItemLike)ItemsObs.NETHER_PLAN.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("RecipeID", randomRecipe.m_6423_().toString());
        ListTag resultList = new ListTag();
        CompoundTag resultTag = new CompoundTag();
        ItemStack result = randomRecipe.m_8043_(level.m_9598_());
        result.m_41739_(resultTag);
        resultList.add((Object)resultTag);
        tag.m_128365_("RecipeResult", (Tag)resultList);
        ListTag ingredientsList = new ListTag();
        for (JsonObject ingredientJson : randomRecipe.getIngredientJsons()) {
            CompoundTag ingredientTag = new CompoundTag();
            ingredientTag.m_128359_("IngredientJson", ingredientJson.toString());
            ingredientsList.add((Object)ingredientTag);
        }
        tag.m_128365_("Ingredients", (Tag)ingredientsList);
        if (!randomRecipe.getBonusOutputs().isEmpty()) {
            ListTag bonusOutputsList = new ListTag();
            for (ForgeScrollNetherRecipe.BonusOutput bonus : randomRecipe.getBonusOutputs()) {
                CompoundTag bonusTag = new CompoundTag();
                CompoundTag itemTag = new CompoundTag();
                bonus.itemStack().m_41739_(itemTag);
                bonusTag.m_128365_("Item", (Tag)itemTag);
                bonusTag.m_128350_("Chance", bonus.chance());
                bonusTag.m_128405_("Min", bonus.min());
                bonusTag.m_128405_("Max", bonus.max());
                bonusOutputsList.add((Object)bonusTag);
            }
            tag.m_128365_("BonusOutputs", (Tag)bonusOutputsList);
        }
        planItem.m_41751_(tag);
        heldItem.m_41774_(1);
        if (heldItem.m_41619_()) {
            event.getEntity().m_21008_(event.getHand(), planItem);
        } else {
            event.getEntity().m_150109_().m_36054_(planItem);
        }
        event.setCancellationResult(InteractionResult.SUCCESS);
        event.setCanceled(true);
    }
}

