/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.item_entity.obsidan_chakram;

import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.rezolv.obsidanum.item.ItemsObs;
import net.rezolv.obsidanum.item.entity.ModEntitiesItem;
import net.rezolv.obsidanum.sound.SoundsObs;

@OnlyIn(value=Dist.CLIENT, _interface=ItemSupplier.class)
public class ObsidianChakramEntity
extends ThrowableItemProjectile {
    public static final EntityDataAccessor<Float> STOPPED_YAW = SynchedEntityData.m_135353_(ObsidianChakramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Float> STOPPED_PITCH = SynchedEntityData.m_135353_(ObsidianChakramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Byte> ID_FLAGS = SynchedEntityData.m_135353_(ObsidianChakramEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private boolean stopped = false;
    private boolean inGround = false;
    private ItemStack tridentItem;
    private BlockState lastState;
    public int shakeTime;
    public AbstractArrow.Pickup pickup = AbstractArrow.Pickup.ALLOWED;

    public ObsidianChakramEntity(EntityType<? extends ObsidianChakramEntity> type, Level world) {
        super(type, world);
        this.tridentItem = new ItemStack((ItemLike)ItemsObs.OBSIDIAN_CHAKRAM.get());
    }

    public ObsidianChakramEntity(Level world, double x, double y, double z) {
        super((EntityType)ModEntitiesItem.OBSIDIAN_CHAKRAM.get(), x, y, z, world);
        this.tridentItem = new ItemStack((ItemLike)ItemsObs.OBSIDIAN_CHAKRAM.get());
    }

    public ObsidianChakramEntity(Level world, LivingEntity owner) {
        super((EntityType)ModEntitiesItem.OBSIDIAN_CHAKRAM.get(), owner, world);
        this.tridentItem = new ItemStack((ItemLike)ItemsObs.OBSIDIAN_CHAKRAM.get());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(STOPPED_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(STOPPED_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ID_FLAGS, (Object)0);
    }

    public void m_6686_(double x, double y, double z, float velocity, float inaccuracy) {
        super.m_6686_(x, y, z, velocity, inaccuracy);
        Vec3 motion = new Vec3(x, y, z).m_82541_();
        float yaw = (float)Math.toDegrees(Math.atan2(motion.f_82479_, motion.f_82481_));
        float pitch = (float)Math.toDegrees(Math.asin(motion.f_82480_));
        this.m_146922_(yaw);
        this.m_146926_(pitch);
        this.f_19859_ = yaw;
        this.f_19860_ = pitch;
        this.m_20088_().m_135381_(STOPPED_YAW, (Object)Float.valueOf(yaw));
        this.m_20088_().m_135381_(STOPPED_PITCH, (Object)Float.valueOf(pitch));
    }

    protected Item m_7881_() {
        return (Item)ItemsObs.OBSIDIAN_CHAKRAM.get();
    }

    protected ItemStack getPickupItem() {
        return this.tridentItem.m_41777_();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        Entity target = result.m_82443_();
        Entity owner = this.m_19749_();
        if (target != null && owner != null) {
            target.m_6469_(new DamageSource((Holder)this.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268464_)), 10.0f);
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult result) {
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)result);
        } else if (result.m_6662_() == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)result);
        }
    }

    protected void m_8060_(BlockHitResult pResult) {
        if (this.inGround) {
            return;
        }
        Direction hitDirection = pResult.m_82434_();
        Vec3 newPos = pResult.m_82450_().m_82520_((double)hitDirection.m_122436_().m_123341_() * 0.125, (double)hitDirection.m_122436_().m_123342_() * 0.125, (double)hitDirection.m_122436_().m_123343_() * 0.125);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        Vec3 motionBeforeHit = this.m_20184_();
        float horizontalSpeed = (float)Math.sqrt(motionBeforeHit.f_82479_ * motionBeforeHit.f_82479_ + motionBeforeHit.f_82481_ * motionBeforeHit.f_82481_);
        float yaw = horizontalSpeed > 0.001f ? (float)(Math.atan2(motionBeforeHit.f_82479_, motionBeforeHit.f_82481_) * 57.29577951308232) : this.m_146908_();
        float pitch = horizontalSpeed > 0.001f ? (float)(Math.atan2(motionBeforeHit.f_82480_, horizontalSpeed) * 57.29577951308232) : this.m_146909_();
        this.m_20088_().m_135381_(STOPPED_YAW, (Object)Float.valueOf(yaw));
        this.m_20088_().m_135381_(STOPPED_PITCH, (Object)Float.valueOf(pitch));
        this.lastState = this.m_9236_().m_8055_(pResult.m_82425_());
        this.m_20256_(Vec3.f_82478_);
        this.inGround = true;
        this.stopped = true;
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundsObs.CHAKRAM_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public float getStoppedYaw() {
        return ((Float)this.f_19804_.m_135370_(STOPPED_YAW)).floatValue();
    }

    public float getStoppedPitch() {
        return ((Float)this.f_19804_.m_135370_(STOPPED_PITCH)).floatValue();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.stopped) {
            this.m_20256_(Vec3.f_82478_);
        } else if (this.m_20184_().m_82556_() < 0.01 && !this.inGround) {
            this.m_20256_(this.m_20184_().m_82490_(1.05));
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void m_6123_(Player pEntity) {
        if (!this.m_9236_().f_46443_ && this.inGround && this.shakeTime <= 0 && this.tryPickup(pEntity)) {
            pEntity.m_7938_((Entity)this, 1);
            this.m_5496_(SoundEvents.f_12019_, 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    protected boolean tryPickup(Player pPlayer) {
        switch (this.pickup) {
            case ALLOWED: {
                return pPlayer.m_150109_().m_36054_(this.getPickupItem());
            }
            case CREATIVE_ONLY: {
                return pPlayer.m_150110_().f_35937_;
            }
        }
        return false;
    }

    public void dropAsItem() {
        if (!this.m_9236_().f_46443_) {
            this.m_5552_(this.getPickupItem(), 0.1f);
            this.m_146870_();
        }
    }
}

