/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.item.item_entity.pot_grenade.fog;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import net.rezolv.obsidanum.item.entity.ModEntitiesItem;
import org.slf4j.Logger;

public class PotGrenadeFog
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(AreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_COLOR = SynchedEntityData.m_135353_(AreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_WAITING = SynchedEntityData.m_135353_(AreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> DATA_PARTICLE = SynchedEntityData.m_135353_(AreaEffectCloud.class, (EntityDataSerializer)EntityDataSerializers.f_135036_);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    private Potion potion = Potions.f_43598_;
    private final List<MobEffectInstance> effects = Lists.newArrayList();
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean fixedColor;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    @Nullable
    private LivingEntity owner;
    @Nullable
    private UUID ownerUUID;

    public PotGrenadeFog(EntityType<? extends PotGrenadeFog> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    public PotGrenadeFog(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends PotGrenadeFog>)((EntityType)ModEntitiesItem.POT_GRENADE_FOG.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_COLOR, (Object)0);
        this.m_20088_().m_135372_(DATA_RADIUS, (Object)Float.valueOf(3.0f));
        this.m_20088_().m_135372_(DATA_WAITING, (Object)false);
        this.m_20088_().m_135372_(DATA_PARTICLE, (Object)ParticleTypes.f_123811_);
    }

    public void setRadius(float pRadius) {
        if (!this.m_9236_().f_46443_) {
            this.m_20088_().m_135381_(DATA_RADIUS, (Object)Float.valueOf(Mth.m_14036_((float)pRadius, (float)0.0f, (float)32.0f)));
        }
    }

    public void m_6210_() {
        double $$0 = this.m_20185_();
        double $$1 = this.m_20186_();
        double $$2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_($$0, $$1, $$2);
    }

    public float getRadius() {
        return ((Float)this.m_20088_().m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setPotion(Potion pPotion) {
        this.potion = pPotion;
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    private void updateColor() {
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.m_20088_().m_135381_(DATA_COLOR, (Object)0);
        } else {
            this.m_20088_().m_135381_(DATA_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(MobEffectInstance pEffectInstance) {
        this.effects.add(pEffectInstance);
        if (!this.fixedColor) {
            this.updateColor();
        }
    }

    public int getColor() {
        return (Integer)this.m_20088_().m_135370_(DATA_COLOR);
    }

    public void setFixedColor(int pColor) {
        this.fixedColor = true;
        this.m_20088_().m_135381_(DATA_COLOR, (Object)pColor);
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.m_20088_().m_135370_(DATA_PARTICLE);
    }

    public void setParticle(ParticleOptions pParticleOption) {
        this.m_20088_().m_135381_(DATA_PARTICLE, (Object)pParticleOption);
    }

    protected void setWaiting(boolean pWaiting) {
        this.m_20088_().m_135381_(DATA_WAITING, (Object)pWaiting);
    }

    public boolean isWaiting() {
        return (Boolean)this.m_20088_().m_135370_(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int pDuration) {
        this.duration = pDuration;
    }

    public void m_8119_() {
        block20: {
            ArrayList $$24;
            float $$1;
            block21: {
                boolean $$23;
                boolean $$0;
                block19: {
                    float $$4;
                    int $$3;
                    super.m_8119_();
                    $$0 = this.isWaiting();
                    $$1 = this.getRadius();
                    if (!this.m_9236_().f_46443_) break block19;
                    if ($$0 && this.f_19796_.m_188499_()) {
                        return;
                    }
                    ParticleOptions $$2 = this.getParticle();
                    if ($$0) {
                        $$3 = 2;
                        $$4 = 0.2f;
                    } else {
                        $$3 = Mth.m_14167_((float)((float)Math.PI * $$1 * $$1));
                        $$4 = $$1;
                    }
                    for (int $$7 = 0; $$7 < $$3; ++$$7) {
                        double $$16;
                        double $$15;
                        double $$14;
                        float $$8 = this.f_19796_.m_188501_() * ((float)Math.PI * 2);
                        float $$9 = Mth.m_14116_((float)this.f_19796_.m_188501_()) * $$4;
                        double $$10 = this.m_20185_() + (double)(Mth.m_14089_((float)$$8) * $$9);
                        double $$11 = this.m_20186_();
                        double $$12 = this.m_20189_() + (double)(Mth.m_14031_((float)$$8) * $$9);
                        if ($$2.m_6012_() == ParticleTypes.f_123811_) {
                            int $$13 = $$0 && this.f_19796_.m_188499_() ? 0xFFFFFF : this.getColor();
                            $$14 = (float)($$13 >> 16 & 0xFF) / 255.0f;
                            $$15 = (float)($$13 >> 8 & 0xFF) / 255.0f;
                            $$16 = (float)($$13 & 0xFF) / 255.0f;
                        } else if ($$0) {
                            $$14 = 0.0;
                            $$15 = 0.0;
                            $$16 = 0.0;
                        } else {
                            $$14 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                            $$15 = 0.01f;
                            $$16 = (0.5 - this.f_19796_.m_188500_()) * 0.15;
                        }
                        this.m_9236_().m_7107_($$2, $$10, $$11, $$12, $$14, $$15, $$16);
                    }
                    break block20;
                }
                if (this.f_19797_ >= this.waitTime + this.duration) {
                    this.m_146870_();
                    return;
                }
                boolean bl = $$23 = this.f_19797_ < this.waitTime;
                if ($$0 != $$23) {
                    this.setWaiting($$23);
                }
                if ($$23) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if (($$1 += this.radiusPerTick) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.setRadius($$1);
                }
                if (this.f_19797_ % 5 != 0) break block20;
                this.victims.entrySet().removeIf(p_287380_ -> this.f_19797_ >= (Integer)p_287380_.getValue());
                $$24 = Lists.newArrayList();
                for (MobEffectInstance $$25 : this.potion.m_43488_()) {
                    $$24.add(new MobEffectInstance($$25.m_19544_(), $$25.m_267696_(p_267926_ -> p_267926_ / 4), $$25.m_19564_(), $$25.m_19571_(), $$25.m_19572_()));
                }
                $$24.addAll(this.effects);
                if (!$$24.isEmpty()) break block21;
                this.victims.clear();
                break block20;
            }
            List $$26 = this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_());
            if ($$26.isEmpty()) break block20;
            for (LivingEntity $$27 : $$26) {
                double $$29;
                double $$28;
                double $$30;
                if (this.victims.containsKey($$27) || !$$27.m_5801_() || !(($$30 = ($$28 = $$27.m_20185_() - this.m_20185_()) * $$28 + ($$29 = $$27.m_20189_() - this.m_20189_()) * $$29) <= (double)($$1 * $$1))) continue;
                this.victims.put((Entity)$$27, this.f_19797_ + this.reapplicationDelay);
                for (MobEffectInstance $$31 : $$24) {
                    if ($$31.m_19544_().m_8093_()) {
                        $$31.m_19544_().m_19461_((Entity)this, (Entity)this.getOwner(), $$27, $$31.m_19564_(), 0.5);
                        continue;
                    }
                    $$27.m_147207_(new MobEffectInstance($$31), (Entity)this);
                }
                if (this.radiusOnUse != 0.0f) {
                    if (($$1 += this.radiusOnUse) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.setRadius($$1);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.m_146870_();
                return;
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float pRadiusOnUse) {
        this.radiusOnUse = pRadiusOnUse;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float pRadiusPerTick) {
        this.radiusPerTick = pRadiusPerTick;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int pDurationOnUse) {
        this.durationOnUse = pDurationOnUse;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int pWaitTime) {
        this.waitTime = pWaitTime;
    }

    public void setOwner(@Nullable LivingEntity pOwner) {
        this.owner = pOwner;
        this.ownerUUID = pOwner == null ? null : pOwner.m_20148_();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity $$0;
        if (this.owner == null && this.ownerUUID != null && this.m_9236_() instanceof ServerLevel && ($$0 = ((ServerLevel)this.m_9236_()).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            this.owner = (LivingEntity)$$0;
        }
        return this.owner;
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.f_19797_ = pCompound.m_128451_("Age");
        this.duration = pCompound.m_128451_("Duration");
        this.waitTime = pCompound.m_128451_("WaitTime");
        this.reapplicationDelay = pCompound.m_128451_("ReapplicationDelay");
        this.durationOnUse = pCompound.m_128451_("DurationOnUse");
        this.radiusOnUse = pCompound.m_128457_("RadiusOnUse");
        this.radiusPerTick = pCompound.m_128457_("RadiusPerTick");
        this.setRadius(pCompound.m_128457_("Radius"));
        if (pCompound.m_128403_("Owner")) {
            this.ownerUUID = pCompound.m_128342_("Owner");
        }
        if (pCompound.m_128425_("Particle", 8)) {
            try {
                this.setParticle(ParticleArgument.m_247456_((StringReader)new StringReader(pCompound.m_128461_("Particle")), (HolderLookup)BuiltInRegistries.f_257034_.m_255303_()));
            }
            catch (CommandSyntaxException $$1) {
                LOGGER.warn("Couldn't load custom particle {}", (Object)pCompound.m_128461_("Particle"), (Object)$$1);
            }
        }
        if (pCompound.m_128425_("Color", 99)) {
            this.setFixedColor(pCompound.m_128451_("Color"));
        }
        if (pCompound.m_128425_("Potion", 8)) {
            this.setPotion(PotionUtils.m_43577_((CompoundTag)pCompound));
        }
        if (pCompound.m_128425_("Effects", 9)) {
            ListTag $$2 = pCompound.m_128437_("Effects", 10);
            this.effects.clear();
            for (int $$3 = 0; $$3 < $$2.size(); ++$$3) {
                MobEffectInstance $$4 = MobEffectInstance.m_19560_((CompoundTag)$$2.m_128728_($$3));
                if ($$4 == null) continue;
                this.addEffect($$4);
            }
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128405_("Age", this.f_19797_);
        pCompound.m_128405_("Duration", this.duration);
        pCompound.m_128405_("WaitTime", this.waitTime);
        pCompound.m_128405_("ReapplicationDelay", this.reapplicationDelay);
        pCompound.m_128405_("DurationOnUse", this.durationOnUse);
        pCompound.m_128350_("RadiusOnUse", this.radiusOnUse);
        pCompound.m_128350_("RadiusPerTick", this.radiusPerTick);
        pCompound.m_128350_("Radius", this.getRadius());
        pCompound.m_128359_("Particle", this.getParticle().m_5942_());
        if (this.ownerUUID != null) {
            pCompound.m_128362_("Owner", this.ownerUUID);
        }
        if (this.fixedColor) {
            pCompound.m_128405_("Color", this.getColor());
        }
        if (this.potion != Potions.f_43598_) {
            pCompound.m_128359_("Potion", BuiltInRegistries.f_256980_.m_7981_((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListTag $$1 = new ListTag();
            for (MobEffectInstance $$2 : this.effects) {
                $$1.add((Object)$$2.m_19555_(new CompoundTag()));
            }
            pCompound.m_128365_("Effects", (Tag)$$1);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_RADIUS.equals(pKey)) {
            this.m_6210_();
        }
        super.m_7350_(pKey);
    }

    public Potion getPotion() {
        return this.potion;
    }

    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return EntityDimensions.m_20395_((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

