/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ForgeScrollCatacombsRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<JsonObject> ingredientJsons;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final ResourceLocation id;
    private final List<BonusOutput> bonusOutputs;

    public ForgeScrollCatacombsRecipe(NonNullList<Ingredient> ingredients, ItemStack output, ResourceLocation id, NonNullList<JsonObject> ingredientJsons, List<BonusOutput> bonusOutputs) {
        this.ingredients = ingredients;
        this.output = output != null ? output : ItemStack.f_41583_;
        this.id = id;
        this.ingredientJsons = ingredientJsons;
        this.bonusOutputs = bonusOutputs != null ? bonusOutputs : new ArrayList();
    }

    public NonNullList<JsonObject> getIngredientJsons() {
        return this.ingredientJsons;
    }

    public List<BonusOutput> getBonusOutputs() {
        return this.bonusOutputs;
    }

    public boolean matches(SimpleContainer container, Level level) {
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack stackInSlot;
            Ingredient requiredIngredient = (Ingredient)this.ingredients.get(i);
            if (requiredIngredient.test(stackInSlot = container.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        ItemStack result = this.output.m_41777_();
        CompoundTag tag = new CompoundTag();
        ListTag ingredientsTag = new ListTag();
        this.ingredientJsons.forEach(json -> ingredientsTag.add((Object)StringTag.m_129297_((String)json.toString())));
        tag.m_128365_("Ingredients", (Tag)ingredientsTag);
        if (!this.bonusOutputs.isEmpty()) {
            ListTag bonusesTag = new ListTag();
            for (BonusOutput bonus : this.bonusOutputs) {
                CompoundTag bonusTag = new CompoundTag();
                bonusTag.m_128365_("Item", (Tag)bonus.itemStack().m_41739_(new CompoundTag()));
                bonusTag.m_128350_("Chance", bonus.chance());
                bonusTag.m_128405_("Min", bonus.min());
                bonusTag.m_128405_("Max", bonus.max());
                bonusesTag.add((Object)bonusTag);
            }
            tag.m_128365_("BonusOutputs", (Tag)bonusesTag);
        }
        result.m_41751_(tag);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.FORGE_SCROLL_CATACOMBS;
    }

    public RecipeType<?> m_6671_() {
        return Type.FORGE_SCROLL_CATACOMBS;
    }

    public record BonusOutput(ItemStack itemStack, float chance, int min, int max) {
        public BonusOutput {
            if (itemStack == null) {
                itemStack = ItemStack.f_41583_;
            }
            if (chance < 0.0f) {
                chance = 0.0f;
            }
            if (chance > 1.0f) {
                chance = 1.0f;
            }
            if (min < 1) {
                min = 1;
            }
            if (max < min) {
                max = min;
            }
        }

        public BonusOutput(ItemStack itemStack, float chance) {
            this(itemStack, chance, 1, 1);
        }
    }

    public static class Serializer
    implements RecipeSerializer<ForgeScrollCatacombsRecipe> {
        public static final Serializer FORGE_SCROLL_CATACOMBS = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("obsidanum", "scrolls/forge_scroll_catacombs");

        public ForgeScrollCatacombsRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"output"));
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"ingredients");
            NonNullList ingredientJsons = NonNullList.m_122779_();
            NonNullList ingredients = NonNullList.m_122779_();
            for (JsonElement element : ingredientsJson) {
                Ingredient ingredient;
                JsonObject ingredientJson = element.getAsJsonObject();
                ingredientJsons.add((Object)ingredientJson.deepCopy());
                if (ingredientJson.has("tag")) {
                    ResourceLocation tagId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)ingredientJson, (String)"tag"));
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                    ingredient = Ingredient.m_204132_((TagKey)tag);
                } else {
                    Item item = GsonHelper.m_13909_((JsonObject)ingredientJson, (String)"item");
                    ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
                }
                ingredients.add((Object)ingredient);
            }
            ArrayList<BonusOutput> bonusOutputs = new ArrayList<BonusOutput>();
            if (serializedRecipe.has("bonus_outputs")) {
                JsonArray bonusesJson = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"bonus_outputs");
                for (JsonElement bonusElement : bonusesJson) {
                    JsonObject bonusObj = bonusElement.getAsJsonObject();
                    JsonObject itemObj = GsonHelper.m_13930_((JsonObject)bonusObj, (String)"item");
                    Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(GsonHelper.m_13906_((JsonObject)itemObj, (String)"item")));
                    int min = GsonHelper.m_13824_((JsonObject)itemObj, (String)"min", (int)1);
                    int max = GsonHelper.m_13824_((JsonObject)itemObj, (String)"max", (int)min);
                    ItemStack bonusStack = new ItemStack((ItemLike)item);
                    float chance = GsonHelper.m_13820_((JsonObject)bonusObj, (String)"chance", (float)0.5f);
                    bonusOutputs.add(new BonusOutput(bonusStack, chance, min, max));
                }
            }
            return new ForgeScrollCatacombsRecipe((NonNullList<Ingredient>)ingredients, output, recipeId, (NonNullList<JsonObject>)ingredientJsons, bonusOutputs);
        }

        @Nullable
        public ForgeScrollCatacombsRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int ingredientSize = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientSize, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientSize; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            NonNullList ingredientJsons = NonNullList.m_122779_();
            int jsonCount = buffer.m_130242_();
            for (int i = 0; i < jsonCount; ++i) {
                String jsonStr = buffer.m_130277_();
                JsonObject json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
                ingredientJsons.add((Object)json);
            }
            ItemStack output = buffer.m_130267_();
            ArrayList<BonusOutput> bonusOutputs = new ArrayList<BonusOutput>();
            int bonusCount = buffer.m_130242_();
            for (int i = 0; i < bonusCount; ++i) {
                ItemStack bonusStack = buffer.m_130267_();
                float chance = buffer.readFloat();
                int min = buffer.m_130242_();
                int max = buffer.m_130242_();
                bonusOutputs.add(new BonusOutput(bonusStack, chance, min, max));
            }
            return new ForgeScrollCatacombsRecipe((NonNullList<Ingredient>)ingredients, output, recipeId, (NonNullList<JsonObject>)ingredientJsons, bonusOutputs);
        }

        public void toNetwork(FriendlyByteBuf buffer, ForgeScrollCatacombsRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.ingredientJsons.size());
            for (JsonObject json : recipe.ingredientJsons) {
                buffer.m_130070_(json.toString());
            }
            buffer.writeItemStack(recipe.output, true);
            buffer.m_130130_(recipe.bonusOutputs.size());
            for (BonusOutput bonus : recipe.bonusOutputs) {
                buffer.m_130055_(bonus.itemStack());
                buffer.writeFloat(bonus.chance());
                buffer.m_130130_(bonus.min());
                buffer.m_130130_(bonus.max());
            }
        }
    }

    public static class Type
    implements RecipeType<ForgeScrollCatacombsRecipe> {
        public static final Type FORGE_SCROLL_CATACOMBS = new Type();
        public static final String ID = "scrolls/forge_scroll_catacombs";
    }
}

