/*
 * Decompiled with CFR 0.152.
 */
package net.rezolv.obsidanum.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ForgeScrollUpgradeRecipe
implements Recipe<SimpleContainer> {
    private final NonNullList<JsonObject> ingredientJsons;
    private final NonNullList<Ingredient> ingredients;
    private final Ingredient tool;
    private final NonNullList<String> toolTypes;
    private final NonNullList<String> toolKinds;
    private ItemStack output;
    private final ResourceLocation id;
    private final String upgrade;

    public NonNullList<JsonObject> getIngredientJsons() {
        return this.ingredientJsons;
    }

    public ForgeScrollUpgradeRecipe(NonNullList<Ingredient> ingredients, Ingredient tool, NonNullList<String> toolTypes, NonNullList<String> toolKinds, ItemStack output, ResourceLocation id, String upgrade, NonNullList<JsonObject> ingredientJsons) {
        this.ingredients = ingredients;
        this.ingredientJsons = ingredientJsons;
        this.tool = tool;
        this.toolTypes = toolTypes;
        this.toolKinds = toolKinds;
        this.output = output != null ? output : ItemStack.f_41583_;
        this.id = id;
        this.upgrade = upgrade;
    }

    public String getUpgrade() {
        return this.upgrade;
    }

    public void setOutput(ItemStack output) {
        this.output = output;
    }

    public NonNullList<String> getToolTypes() {
        return this.toolTypes;
    }

    public NonNullList<String> getToolKinds() {
        return this.toolKinds;
    }

    public boolean matches(SimpleContainer container, Level level) {
        if (!this.tool.test(container.m_8020_(0))) {
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            ItemStack stackInSlot;
            Ingredient requiredIngredient = (Ingredient)this.ingredients.get(i);
            if (requiredIngredient.test(stackInSlot = container.m_8020_(i + 1))) continue;
            return false;
        }
        return true;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public Ingredient getTool() {
        return this.tool;
    }

    public ItemStack assemble(SimpleContainer container, RegistryAccess registryAccess) {
        ItemStack result = this.output.m_41777_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Upgrade", this.upgrade);
        ListTag toolTypesTag = new ListTag();
        this.toolTypes.forEach(t -> toolTypesTag.add((Object)StringTag.m_129297_((String)t)));
        tag.m_128365_("ToolTypes", (Tag)toolTypesTag);
        ListTag toolKindsTag = new ListTag();
        this.toolKinds.forEach(k -> toolKindsTag.add((Object)StringTag.m_129297_((String)k)));
        tag.m_128365_("ToolKinds", (Tag)toolKindsTag);
        ListTag ingredientsTag = new ListTag();
        this.ingredientJsons.forEach(json -> ingredientsTag.add((Object)StringTag.m_129297_((String)json.toString())));
        tag.m_128365_("Ingredients", (Tag)ingredientsTag);
        result.m_41751_(tag);
        return result;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.FORGE_SCROLL_UPGRADE;
    }

    public RecipeType<?> m_6671_() {
        return Type.FORGE_SCROLL_UPGRADE;
    }

    public static class Serializer
    implements RecipeSerializer<ForgeScrollUpgradeRecipe> {
        public static final Serializer FORGE_SCROLL_UPGRADE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("obsidanum", "forge_scroll_upgrade");

        public ForgeScrollUpgradeRecipe fromJson(ResourceLocation recipeId, JsonObject serializedRecipe) {
            Ingredient tool;
            if (serializedRecipe.has("tool")) {
                JsonObject toolJson = GsonHelper.m_13930_((JsonObject)serializedRecipe, (String)"tool");
                if (toolJson.has("tag")) {
                    ResourceLocation tagId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)toolJson, (String)"tag"));
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                    tool = Ingredient.m_204132_((TagKey)tag);
                } else {
                    Item item = GsonHelper.m_13909_((JsonObject)toolJson, (String)"item");
                    tool = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
                }
            } else {
                tool = Ingredient.f_43901_;
            }
            ItemStack output = ItemStack.f_41583_;
            String upgrade = GsonHelper.m_13906_((JsonObject)serializedRecipe, (String)"upgrade");
            NonNullList toolTypes = NonNullList.m_122779_();
            if (serializedRecipe.has("tool_types")) {
                JsonArray toolTypesJson = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"tool_types");
                for (Iterator element : toolTypesJson) {
                    toolTypes.add((Object)element.getAsString());
                }
            }
            NonNullList toolKinds = NonNullList.m_122779_();
            if (serializedRecipe.has("tool_kinds")) {
                JsonArray toolKindsJson = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"tool_kinds");
                for (JsonElement element : toolKindsJson) {
                    toolKinds.add((Object)element.getAsString());
                }
            }
            JsonArray ingredientsJson = GsonHelper.m_13933_((JsonObject)serializedRecipe, (String)"ingredients");
            NonNullList ingredientJsons = NonNullList.m_122779_();
            NonNullList ingredients = NonNullList.m_122779_();
            for (JsonElement element : ingredientsJson) {
                Ingredient ingredient;
                JsonObject ingredientJson = element.getAsJsonObject();
                ingredientJsons.add((Object)ingredientJson.deepCopy());
                if (ingredientJson.has("tag")) {
                    ResourceLocation tagId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)ingredientJson, (String)"tag"));
                    TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                    ingredient = Ingredient.m_204132_((TagKey)tag);
                } else {
                    Item item = GsonHelper.m_13909_((JsonObject)ingredientJson, (String)"item");
                    ingredient = Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
                }
                ingredients.add((Object)ingredient);
            }
            return new ForgeScrollUpgradeRecipe((NonNullList<Ingredient>)ingredients, tool, (NonNullList<String>)toolTypes, (NonNullList<String>)toolKinds, output, recipeId, upgrade, (NonNullList<JsonObject>)ingredientJsons);
        }

        @Nullable
        public ForgeScrollUpgradeRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient tool = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int toolTypesSize = buffer.m_130242_();
            NonNullList toolTypes = NonNullList.m_122780_((int)toolTypesSize, (Object)"");
            for (int i = 0; i < toolTypesSize; ++i) {
                toolTypes.set(i, (Object)buffer.m_130277_());
            }
            int toolKindsSize = buffer.m_130242_();
            NonNullList toolKinds = NonNullList.m_122780_((int)toolKindsSize, (Object)"");
            for (int i = 0; i < toolKindsSize; ++i) {
                toolKinds.set(i, (Object)buffer.m_130277_());
            }
            int ingredientSize = buffer.readInt();
            NonNullList ingredients = NonNullList.m_122780_((int)ingredientSize, (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredientSize; ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            NonNullList ingredientJsons = NonNullList.m_122779_();
            int jsonCount = buffer.m_130242_();
            for (int i = 0; i < jsonCount; ++i) {
                String jsonStr = buffer.m_130277_();
                JsonObject json = JsonParser.parseString((String)jsonStr).getAsJsonObject();
                ingredientJsons.add((Object)json);
            }
            ItemStack output = buffer.m_130267_();
            String upgrade = buffer.m_130277_();
            return new ForgeScrollUpgradeRecipe((NonNullList<Ingredient>)ingredients, tool, (NonNullList<String>)toolTypes, (NonNullList<String>)toolKinds, output, recipeId, upgrade, (NonNullList<JsonObject>)ingredientJsons);
        }

        public void toNetwork(FriendlyByteBuf buffer, ForgeScrollUpgradeRecipe recipe) {
            recipe.tool.m_43923_(buffer);
            buffer.m_130130_(recipe.toolTypes.size());
            for (String type : recipe.toolTypes) {
                buffer.m_130070_(type);
            }
            buffer.m_130130_(recipe.toolKinds.size());
            for (String kind : recipe.toolKinds) {
                buffer.m_130070_(kind);
            }
            buffer.writeInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130130_(recipe.ingredientJsons.size());
            for (JsonObject json : recipe.ingredientJsons) {
                buffer.m_130070_(json.toString());
            }
            buffer.writeItemStack(recipe.output, true);
            buffer.m_130070_(recipe.upgrade);
        }
    }

    public static class Type
    implements RecipeType<ForgeScrollUpgradeRecipe> {
        public static final Type FORGE_SCROLL_UPGRADE = new Type();
        public static final String ID = "forge_scroll_upgrade";
    }
}

