/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.bluebeetlemod.network;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.mcreator.bluebeetlemod.BlueBeetleModMod;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlueBeetleModModVariables {
    public static double time_sneaking = 0.0;
    public static double falling_timer = 0.0;
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        BlueBeetleModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        BlueBeetleModMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    public static class PlayerVariablesSyncMessage {
        private final int target;
        private final PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
            this.target = buffer.readInt();
        }

        public PlayerVariablesSyncMessage(PlayerVariables data, int entityid) {
            this.data = data;
            this.target = entityid;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
            buffer.writeInt(message.target);
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.m_9236_().m_6815_(message.target).getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.scarab_integrated = message.data.scarab_integrated;
                    variables.hud_on = message.data.hud_on;
                    variables.boost = message.data.boost;
                    variables.air_manuver = message.data.air_manuver;
                    variables.beetle_flying = message.data.beetle_flying;
                    variables.integrating_scarab = message.data.integrating_scarab;
                    variables.IntegrationLog = message.data.IntegrationLog;
                    variables.ec_overloaded = message.data.ec_overloaded;
                    variables.ec_charged = message.data.ec_charged;
                    variables.fs_level = message.data.fs_level;
                    variables.EntityInEyeline = message.data.EntityInEyeline;
                    variables.EntityName = message.data.EntityName;
                    variables.EntityHealth = message.data.EntityHealth;
                    variables.EntityDistance = message.data.EntityDistance;
                    variables.EntityHeartbeat = message.data.EntityHeartbeat;
                    variables.ThreatInTheArea = message.data.ThreatInTheArea;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public boolean scarab_integrated = false;
        public boolean hud_on = true;
        public boolean boost = false;
        public boolean air_manuver = false;
        public boolean beetle_flying = false;
        public boolean integrating_scarab = false;
        public String IntegrationLog = "";
        public boolean ec_overloaded = false;
        public boolean ec_charged = false;
        public double fs_level = 0.0;
        public boolean EntityInEyeline = false;
        public String EntityName = "\"\"";
        public String EntityHealth = "\"\"";
        public String EntityDistance = "\"\"";
        public String EntityHeartbeat = "\"\"";
        public boolean ThreatInTheArea = false;

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                BlueBeetleModMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)entity.m_9236_()).m_46472_()), (Object)new PlayerVariablesSyncMessage(this, entity.m_19879_()));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("scarab_integrated", this.scarab_integrated);
            nbt.m_128379_("hud_on", this.hud_on);
            nbt.m_128379_("boost", this.boost);
            nbt.m_128379_("air_manuver", this.air_manuver);
            nbt.m_128379_("beetle_flying", this.beetle_flying);
            nbt.m_128379_("integrating_scarab", this.integrating_scarab);
            nbt.m_128359_("IntegrationLog", this.IntegrationLog);
            nbt.m_128379_("ec_overloaded", this.ec_overloaded);
            nbt.m_128379_("ec_charged", this.ec_charged);
            nbt.m_128347_("fs_level", this.fs_level);
            nbt.m_128379_("EntityInEyeline", this.EntityInEyeline);
            nbt.m_128359_("EntityName", this.EntityName);
            nbt.m_128359_("EntityHealth", this.EntityHealth);
            nbt.m_128359_("EntityDistance", this.EntityDistance);
            nbt.m_128359_("EntityHeartbeat", this.EntityHeartbeat);
            nbt.m_128379_("ThreatInTheArea", this.ThreatInTheArea);
            return nbt;
        }

        public void readNBT(Tag tag) {
            CompoundTag nbt;
            if (tag == null) {
                tag = this.writeNBT();
            }
            if ((nbt = (CompoundTag)tag) == null) {
                nbt = (CompoundTag)this.writeNBT();
            }
            this.scarab_integrated = nbt.m_128471_("scarab_integrated");
            this.hud_on = nbt.m_128471_("hud_on");
            this.boost = nbt.m_128471_("boost");
            this.air_manuver = nbt.m_128471_("air_manuver");
            this.beetle_flying = nbt.m_128471_("beetle_flying");
            this.integrating_scarab = nbt.m_128471_("integrating_scarab");
            this.IntegrationLog = nbt.m_128461_("IntegrationLog");
            this.ec_overloaded = nbt.m_128471_("ec_overloaded");
            this.ec_charged = nbt.m_128471_("ec_charged");
            this.fs_level = nbt.m_128459_("fs_level");
            this.EntityInEyeline = nbt.m_128471_("EntityInEyeline");
            this.EntityName = nbt.m_128461_("EntityName");
            this.EntityHealth = nbt.m_128461_("EntityHealth");
            this.EntityDistance = nbt.m_128461_("EntityDistance");
            this.EntityHeartbeat = nbt.m_128461_("EntityHeartbeat");
            this.ThreatInTheArea = nbt.m_128471_("ThreatInTheArea");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("blue_beetle_mod", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.EntityHeartbeat = original.EntityHeartbeat;
            if (!event.isWasDeath()) {
                clone.scarab_integrated = original.scarab_integrated;
                clone.hud_on = original.hud_on;
                clone.boost = original.boost;
                clone.air_manuver = original.air_manuver;
                clone.beetle_flying = original.beetle_flying;
                clone.integrating_scarab = original.integrating_scarab;
                clone.IntegrationLog = original.IntegrationLog;
                clone.ec_overloaded = original.ec_overloaded;
                clone.ec_charged = original.ec_charged;
                clone.fs_level = original.fs_level;
                clone.EntityInEyeline = original.EntityInEyeline;
                clone.EntityName = original.EntityName;
                clone.EntityHealth = original.EntityHealth;
                clone.EntityDistance = original.EntityDistance;
                clone.ThreatInTheArea = original.ThreatInTheArea;
            }
            if (!event.getEntity().m_9236_().m_5776_()) {
                for (Entity entityiterator : new ArrayList(event.getEntity().m_9236_().m_6907_())) {
                    ((PlayerVariables)entityiterator.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables(entityiterator);
                }
            }
        }
    }
}

