/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import zombieinfection.HumanoidRenderer;
import zombieinfection.Infectable;
import zombieinfection.ZombieModel;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractZombieRenderer<M extends ZombieModel>
extends HumanoidRenderer<AbstractClientPlayer, M> {
    private static final ResourceLocation ZOMBIE_LOCATION = new ResourceLocation("textures/entity/zombie/zombie.png");

    protected AbstractZombieRenderer(EntityRendererProvider.Context p_173910_, M p_173911_, M p_173912_, M p_173913_) {
        super(p_173910_, p_173911_, 0.5f);
        this.m_115326_((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, p_173912_, p_173913_, p_173910_.m_266367_()));
    }

    public ResourceLocation getTextureLocation(AbstractClientPlayer player) {
        return ZOMBIE_LOCATION;
    }

    protected boolean isShaking(AbstractClientPlayer player) {
        Infectable infectable;
        return player instanceof Infectable && (infectable = (Infectable)player).isShaking();
    }

    protected void setupRotations(AbstractClientPlayer p_117802_, PoseStack p_117803_, float p_117804_, float p_117805_, float p_117806_) {
        if (p_117802_.m_21255_()) {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
            float f1 = (float)p_117802_.m_21256_() + p_117806_;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!p_117802_.m_21209_()) {
                p_117803_.m_252781_(Axis.f_252529_.m_252977_(f2 * (-90.0f - p_117802_.m_146909_())));
            }
            Vec3 vec3 = p_117802_.m_20252_(p_117806_);
            Vec3 vec31 = p_117802_.m_272267_(p_117806_);
            double d0 = vec31.m_165925_();
            double d1 = vec3.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec31.f_82479_ * vec3.f_82479_ + vec31.f_82481_ * vec3.f_82481_) / Math.sqrt(d0 * d1);
                double d3 = vec31.f_82479_ * vec3.f_82481_ - vec31.f_82481_ * vec3.f_82479_;
                p_117803_.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else {
            super.m_7523_((LivingEntity)p_117802_, p_117803_, p_117804_, p_117805_, p_117806_);
        }
    }
}

