/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderArmEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import zombieinfection.AbstractZombieRenderer;
import zombieinfection.HandModel;
import zombieinfection.HandRenderer;
import zombieinfection.Infectable;
import zombieinfection.Infector;
import zombieinfection.ZombieType;

@Mod.EventBusSubscriber
public class Events {
    @OnlyIn(value=Dist.CLIENT)
    private static EntityRendererProvider.Context getContext() {
        Minecraft minecraft = Minecraft.m_91087_();
        return new EntityRendererProvider.Context(minecraft.m_91290_(), minecraft.m_91291_(), minecraft.m_91289_(), minecraft.f_91063_.f_109055_, minecraft.m_91098_(), minecraft.m_167973_(), minecraft.f_91062_);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void playerRender(RenderPlayerEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof Infectable) {
            Infectable infectable = (Infectable)player;
            ZombieType infection = infectable.getInfection();
            if (infection == null || infection.info().rendererGetter == null) {
                return;
            }
            AbstractZombieRenderer renderer = infection.info().createRenderer(Events.getContext());
            renderer.m_7392_((LivingEntity)((AbstractClientPlayer)player), 0.0f, event.getPartialTick(), event.getPoseStack(), event.getMultiBufferSource(), event.getPackedLight());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void armRender(RenderArmEvent event) {
        AbstractClientPlayer player = event.getPlayer();
        if (player instanceof Infectable) {
            Infectable infectable = (Infectable)player;
            ZombieType infection = infectable.getInfection();
            if (infection == null || infection.info().getHand() == null) {
                return;
            }
            PoseStack pose = event.getPoseStack();
            int packedLight = event.getPackedLight();
            MultiBufferSource buffer = event.getMultiBufferSource();
            EntityRendererProvider.Context context = Events.getContext();
            HandRenderer renderer = new HandRenderer(context, new HandModel(context.m_174023_(ModelLayers.f_171223_), false));
            renderer.render(player, 0.0f, 0.0f, pose, buffer, packedLight);
            if (infection.info().getHand().outerTexture != null) {
                HandRenderer outer = new HandRenderer(context, new HandModel(context.m_174023_(ModelLayers.f_171223_), true));
                outer.render(player, 0.0f, 0.0f, pose, buffer, packedLight);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void attacked(LivingHurtEvent event) {
        Infector infector;
        LivingEntity attacker;
        Entity entity;
        Infectable infectable;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Infectable && (infectable = (Infectable)livingEntity).entity().m_21223_() <= event.getAmount() && (entity = event.getSource().m_7639_()) instanceof LivingEntity && (attacker = (LivingEntity)entity).m_21205_().m_41619_() && attacker instanceof Infector && infectable.infect(infector = (Infector)attacker)) {
            event.setCanceled(true);
        }
    }
}

