/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import zombieinfection.Infector;
import zombieinfection.ZombieType;

public interface Infectable {
    public void setHealth(float var1);

    public float getMaxHealth();

    default public LivingEntity entity() {
        return (LivingEntity)this;
    }

    default public boolean isInfected() {
        ZombieType type = this.getInfection();
        return type != null && type != ZombieType.None;
    }

    default public ZombieType getInfection() {
        return ZombieType.None;
    }

    default public void setInfection(ZombieType type) {
        this.handleAttributes(this.entity().m_9236_().m_6436_(this.entity().m_20183_()).m_19057_());
        if (type != ZombieType.None) {
            this.clearZombieAttackers();
        }
    }

    default public void clearZombieAttackers() {
        for (Zombie zombie : this.entity().m_9236_().m_45976_(Zombie.class, this.entity().m_20191_().m_82400_(32.0))) {
            if (zombie.m_5448_() != this.entity()) continue;
            zombie.m_6710_(null);
        }
    }

    default public boolean infect(Infector infector) {
        if (this.isInfected()) {
            return false;
        }
        ZombieType type = infector.getInfectType();
        if (type == null || type == ZombieType.None) {
            return false;
        }
        this.m_21153_(this.m_21233_());
        this.setInfection(type);
        return true;
    }

    default public boolean isUnderWaterConverting() {
        return false;
    }

    default public boolean isConverting() {
        return false;
    }

    default public boolean isAggressive() {
        return false;
    }

    default public boolean isShaking() {
        return this.isUnderWaterConverting() || this.isConverting();
    }

    default public boolean convertsInWater() {
        return !this.isConverting() && this.getInfection().info().drownInto != null;
    }

    default public boolean isSunSensitive() {
        return this.getInfection().info().dayBurning;
    }

    default public void handleAttributes(float specialMultiplier) {
        AttributeSupplier supplier = (this.getInfection() != ZombieType.None ? Zombie.m_34328_() : Player.m_36340_()).m_22265_();
        AttributeMap attributes = this.entity().m_21204_();
        for (Attribute attribute : BuiltInRegistries.f_256951_) {
            if (!attributes.m_22171_(attribute) || !supplier.m_22258_(attribute)) continue;
            double value = supplier.m_22253_(attribute);
            if (this.getInfection() != ZombieType.None && attribute == Attributes.f_22279_) {
                value /= 4.0;
            }
            attributes.m_22146_(attribute).m_22100_(value);
        }
        if (!this.isInfected()) {
            return;
        }
        this.randomizeReinforcementsChance();
        attributes.m_22146_(Attributes.f_22278_).m_22125_(new AttributeModifier("Random spawn bonus", this.entity().m_217043_().m_188500_() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        if (this.entity().m_217043_().m_188501_() < specialMultiplier * 0.05f) {
            attributes.m_22146_(Attributes.f_22276_).m_22125_(new AttributeModifier("Leader zombie bonus", this.entity().m_217043_().m_188500_() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    default public void randomizeReinforcementsChance() {
    }
}

