/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection;

import com.google.common.base.Function;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.loading.FMLEnvironment;
import zombieinfection.AbstractZombieRenderer;
import zombieinfection.DrownedRenderer;
import zombieinfection.HandData;
import zombieinfection.HuskRenderer;
import zombieinfection.ZombieRenderer;
import zombieinfection.ZombieType;

public class ZombieInfo {
    public EntityType type = EntityType.f_20501_;
    public ZombieType drownInto = ZombieType.Drowned;
    public SoundEvent deathSound = SoundEvents.f_12603_;
    public SoundEvent hurtSound = SoundEvents.f_12608_;
    public SoundEvent stepSound = SoundEvents.f_12614_;
    public Function<Object, Object> rendererGetter = null;
    public Object hand;
    public String textureId = "zombie";
    public String outerTextureId = null;
    public boolean dayBurning = true;
    public boolean allowSprint = false;
    public boolean allowSwim = false;

    public ZombieInfo disable() {
        this.clearSounds();
        this.noBurn();
        this.sprinting();
        this.swimming();
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            this.renderer((Function<Object, Object>)((Function)null));
        }
        this.drown(null);
        return this;
    }

    public ZombieInfo refresh() {
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            this.renderer(this.type);
            this.refreshHandData();
        }
        return this;
    }

    public ZombieInfo type(EntityType type) {
        return this.type(type, true);
    }

    public ZombieInfo type(EntityType type, boolean changeRenderer) {
        this.type = type;
        if (changeRenderer && FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            this.renderer(type);
        }
        return this;
    }

    public ZombieInfo drown(ZombieType type) {
        this.drownInto = type;
        return this;
    }

    public ZombieInfo noBurn() {
        this.dayBurning = false;
        return this;
    }

    public ZombieInfo sprinting() {
        this.allowSprint = true;
        return this;
    }

    public ZombieInfo swimming() {
        this.allowSwim = true;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ZombieInfo renderer(EntityType type) {
        if (type == EntityType.f_20501_) {
            this.renderer((Function<Object, Object>)((Function)context -> new ZombieRenderer((EntityRendererProvider.Context)context)));
        }
        if (type == EntityType.f_20458_) {
            this.renderer((Function<Object, Object>)((Function)context -> new HuskRenderer((EntityRendererProvider.Context)context)));
        }
        if (type == EntityType.f_20562_) {
            this.renderer((Function<Object, Object>)((Function)context -> new DrownedRenderer((EntityRendererProvider.Context)context)));
        }
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    private ZombieInfo renderer(Function<Object, Object> renderFunc) {
        this.rendererGetter = renderFunc;
        return this;
    }

    public ZombieInfo texture(String id, boolean outer) {
        if (!outer) {
            this.textureId = id;
        }
        if (outer) {
            this.outerTextureId = id;
        }
        if (FMLEnvironment.dist != Dist.DEDICATED_SERVER) {
            this.refreshHandData();
        }
        return this;
    }

    public ZombieInfo clearSounds() {
        this.deathSound = null;
        this.hurtSound = null;
        this.stepSound = null;
        return this;
    }

    public ZombieInfo death(SoundEvent sound) {
        this.deathSound = sound;
        return this;
    }

    public ZombieInfo hurt(SoundEvent sound) {
        this.hurtSound = sound;
        return this;
    }

    public ZombieInfo step(SoundEvent sound) {
        this.stepSound = sound;
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractZombieRenderer createRenderer(EntityRendererProvider.Context context) {
        return this.rendererGetter == null ? null : (AbstractZombieRenderer)((Object)this.rendererGetter.apply((Object)context));
    }

    public ResourceLocation getTexture(boolean outerLayer) {
        if (outerLayer) {
            return this.outerTextureId == null ? null : new ResourceLocation("textures/entity/zombie/" + this.outerTextureId + ".png");
        }
        return new ResourceLocation("textures/entity/zombie/" + this.textureId + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    private ZombieInfo refreshHandData() {
        this.hand = this.getHandData();
        return this;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandData getHand() {
        return (HandData)this.hand;
    }

    @OnlyIn(value=Dist.CLIENT)
    private HandData getHandData() {
        HandData hand = new HandData();
        hand.texture = this.getTexture(false);
        hand.outerTexture = this.getTexture(true);
        hand.setScale(1.0f, 1.0f, 1.0f);
        hand.setPosition(5.25f, 21.5f, -1.1f);
        hand.setRotation(3.2f, 1.6f, 0.15f);
        return hand;
    }
}

