/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection;

import java.util.function.IntFunction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.entity.EntityType;
import zombieinfection.ZombieInfo;

public enum ZombieType {
    None(new ZombieInfo().disable().type(EntityType.f_20532_, false)),
    Drowned(new ZombieInfo().type(EntityType.f_20562_).death(SoundEvents.f_11817_).hurt(SoundEvents.f_11819_).step(SoundEvents.f_11875_).swimming().texture("drowned", false).texture("drowned_outer_layer", true)),
    Default(new ZombieInfo().refresh()),
    Husk(new ZombieInfo().type(EntityType.f_20458_).drown(Default).noBurn().death(SoundEvents.f_12045_).hurt(SoundEvents.f_12046_).step(SoundEvents.f_12047_).texture("husk", false));

    private static final IntFunction<ZombieType> MappedID;
    private final ZombieInfo info;
    private final int id = this.ordinal();

    private ZombieType(ZombieInfo info) {
        this.info = info;
    }

    public static ZombieType byId(int id) {
        return MappedID.apply(id);
    }

    public String getName() {
        return this.toString();
    }

    public ZombieInfo info() {
        return this.info;
    }

    public int getId() {
        return this.id;
    }

    static {
        MappedID = ByIdMap.m_262839_(ZombieType::getId, (Object[])ZombieType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
    }
}

