/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import zombieinfection.Infectable;
import zombieinfection.Infector;
import zombieinfection.ZombieType;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements Infectable,
Infector {
    @Unique
    private static final EntityDataAccessor<Integer> ZombieVariant = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    @Override
    public ZombieType getInfectType() {
        return this.getInfection();
    }

    @Override
    public ZombieType getInfection() {
        return ZombieType.byId((Integer)this.entity().m_20088_().m_135370_(ZombieVariant));
    }

    @Override
    public void setInfection(ZombieType type) {
        if (this.getInfection() == type) {
            return;
        }
        this.entity().m_20088_().m_135381_(ZombieVariant, (Object)type.getId());
        Infectable.super.setInfection(type);
    }

    private boolean isSunBurnTick() {
        if (this.entity().m_9236_().m_46461_() && !this.entity().m_9236_().f_46443_) {
            if (this.entity().m_20071_() || this.entity().f_146808_ || this.entity().f_146809_) {
                return false;
            }
            if (!this.entity().m_9236_().m_45527_(BlockPos.m_274561_((double)this.entity().m_20185_(), (double)this.entity().m_20188_(), (double)this.entity().m_20189_()))) {
                return false;
            }
            float light = this.entity().m_213856_();
            if ((double)light > 0.5 && (double)(this.entity().m_217043_().m_188501_() * 30.0f) < ((double)light - 0.4) * 2.0) {
                return true;
            }
        }
        return false;
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData() {
        this.entity().m_20088_().m_135372_(ZombieVariant, (Object)0);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag compound) {
        if (compound.m_128441_("ZombieVariant")) {
            this.setInfection(ZombieType.byId(compound.m_128451_("ZombieVariant")));
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag compound) {
        compound.m_128405_("ZombieVariant", this.getInfection().getId());
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")})
    private void aiStep() {
        if (this.entity().m_6084_() && this.isSunSensitive() && this.isSunBurnTick()) {
            ItemStack helmet = this.entity().m_6844_(EquipmentSlot.HEAD);
            if (!helmet.m_41619_()) {
                if (helmet.m_41763_()) {
                    helmet.m_41721_(helmet.m_41773_() + this.entity().m_217043_().m_188503_(2));
                    if (helmet.m_41773_() >= helmet.m_41776_()) {
                        this.entity().m_21166_(EquipmentSlot.HEAD);
                        this.entity().m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
            } else {
                this.entity().m_20254_(8);
            }
        }
    }
}

