/*
 * Decompiled with CFR 0.152.
 */
package zombieinfection.mixins;

import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import zombieinfection.Infectable;
import zombieinfection.Infector;
import zombieinfection.ZombieType;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity
implements Infectable,
Infector {
    @Unique
    private static final EntityDataAccessor<Integer> ZombieVariant = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private static final EntityDataAccessor<Boolean> Curing = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private static final EntityDataAccessor<Boolean> Drowning = SynchedEntityData.m_135353_(Player.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    private int inWaterTime;
    @Unique
    private int conversionTime;
    @Unique
    private int curingTime;
    @Unique
    private UUID curingUUID;
    @Shadow
    @Final
    private Abilities f_36077_;

    private PlayerMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Override
    public ZombieType getInfectType() {
        return this.getInfection();
    }

    @Override
    public ZombieType getInfection() {
        return ZombieType.byId((Integer)this.f_19804_.m_135370_(ZombieVariant));
    }

    @Override
    public void setInfection(ZombieType type) {
        if (this.getInfection() == type) {
            return;
        }
        this.f_19804_.m_135381_(ZombieVariant, (Object)type.getId());
        Infectable.super.setInfection(type);
    }

    private boolean isSunBurnTick() {
        if (this.m_9236_().m_46461_() && !this.m_9236_().f_46443_) {
            if (this.m_20071_() || this.f_146808_ || this.f_146809_) {
                return false;
            }
            if (!this.m_9236_().m_45527_(BlockPos.m_274561_((double)this.m_20185_(), (double)this.m_20188_(), (double)this.m_20189_()))) {
                return false;
            }
            float light = this.m_213856_();
            if ((double)light > 0.5 && (double)(this.f_19796_.m_188501_() * 30.0f) < ((double)light - 0.4) * 2.0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isConverting() {
        return (Boolean)this.f_19804_.m_135370_(Curing);
    }

    @Override
    public boolean isUnderWaterConverting() {
        return (Boolean)this.f_19804_.m_135370_(Drowning);
    }

    private void startUnderWaterConversion(int time) {
        this.conversionTime = time;
        this.f_19804_.m_135381_(Drowning, (Object)true);
    }

    private void doUnderWaterConversion() {
        this.inWaterTime = -1;
        this.f_19804_.m_135381_(Drowning, (Object)false);
        this.setInfection(this.getInfection().info().drownInto);
        if (!this.m_20067_()) {
            this.m_9236_().m_5898_((Player)null, 1040, this.m_20183_(), 0);
        }
    }

    private int getConversionProgress() {
        int advance = 1;
        if (this.f_19796_.m_188501_() < 0.01f) {
            int detected = 0;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x = (int)this.m_20185_() - 4; x < (int)this.m_20185_() + 4 && detected < 14; ++x) {
                for (int y = (int)this.m_20186_() - 4; y < (int)this.m_20186_() + 4 && detected < 14; ++y) {
                    for (int z = (int)this.m_20189_() - 4; z < (int)this.m_20189_() + 4 && detected < 14; ++z) {
                        BlockState state = this.m_9236_().m_8055_((BlockPos)pos.m_122178_(x, y, z));
                        if (!state.m_60713_(Blocks.f_50183_) && !(state.m_60734_() instanceof BedBlock)) continue;
                        if (this.f_19796_.m_188501_() < 0.3f) {
                            ++advance;
                        }
                        ++detected;
                    }
                }
            }
        }
        return advance;
    }

    private void startConverting(UUID uuid, int time) {
        this.curingUUID = uuid;
        this.curingTime = time;
        this.f_19804_.m_135381_(Curing, (Object)true);
        this.m_21195_(MobEffects.f_19613_);
        this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, time, Math.min(this.m_9236_().m_46791_().m_19028_() - 1, 0)));
        this.m_9236_().m_7605_((Entity)this, (byte)16);
    }

    private void finishConversion(ServerLevel server) {
        Player cureCause;
        if (this.curingUUID != null && (cureCause = server.m_46003_(this.curingUUID)) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)cureCause;
            Advancement advancement = player.f_8924_.m_129889_().m_136041_(new ResourceLocation("minecraft:story/cure_zombie_villager"));
            player.m_8960_().m_135988_(advancement, "cured_zombie_villager");
        }
        this.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        server.m_5898_(null, 1027, this.m_20183_(), 0);
        this.f_19804_.m_135381_(Curing, (Object)false);
        this.setInfection(ZombieType.None);
        this.curingUUID = null;
    }

    public void m_7355_(BlockPos pos, BlockState state) {
        SoundEvent stepSound = this.getInfection().info().stepSound;
        if (stepSound != null) {
            this.m_5496_(stepSound, 0.15f, 1.0f);
            return;
        }
        super.m_7355_(pos, state);
    }

    public MobType m_6336_() {
        return this.isInfected() ? MobType.f_21641_ : super.m_6336_();
    }

    public void m_7350_(EntityDataAccessor<?> data) {
        super.m_7350_(data);
        if (ZombieVariant.equals(data)) {
            this.m_6210_();
        }
    }

    protected void m_21137_(ItemStack stack, int useTick) {
        if (this.isInfected() && !this.isConverting() && !this.m_9236_().f_46443_ && stack.m_150930_(Items.f_42436_) && this.m_21023_(MobEffects.f_19613_)) {
            if (!this.f_36077_.f_35937_) {
                stack.m_41774_(1);
            }
            this.startConverting(this.m_20148_(), this.f_19796_.m_188503_(2401) + 3600);
        } else {
            super.m_21137_(stack, useTick);
        }
    }

    @Inject(method={"defineSynchedData()V"}, at={@At(value="TAIL")})
    private void defineSynchedData(CallbackInfo callback) {
        this.f_19804_.m_135372_(ZombieVariant, (Object)0);
        this.f_19804_.m_135372_(Curing, (Object)false);
        this.f_19804_.m_135372_(Drowning, (Object)false);
    }

    @Inject(method={"handleEntityEvent(B)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleEntityEvent(byte event, CallbackInfo callback) {
        if (event != 16) {
            return;
        }
        if (!this.m_20067_()) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20188_(), this.m_20189_(), SoundEvents.f_12644_, this.m_5720_(), 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() * 0.7f + 0.3f, false);
        }
        callback.cancel();
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag compound, CallbackInfo callback) {
        if (compound.m_128441_("ZombieVariant")) {
            this.setInfection(ZombieType.byId(compound.m_128451_("ZombieVariant")));
        }
        if (compound.m_128441_("InWaterTime")) {
            this.inWaterTime = compound.m_128451_("InWaterTime");
        }
        if (compound.m_128425_("DrownedConversionTime", 99) && compound.m_128451_("DrownedConversionTime") > -1) {
            this.startUnderWaterConversion(compound.m_128451_("DrownedConversionTime"));
        }
        if (compound.m_128425_("ConversionTime", 99) && compound.m_128451_("ConversionTime") > -1) {
            this.startConverting(compound.m_128403_("ConversionPlayer") ? compound.m_128342_("ConversionPlayer") : null, compound.m_128451_("ConversionTime"));
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag compound, CallbackInfo callback) {
        if (this.isInfected()) {
            compound.m_128405_("ZombieVariant", this.getInfection().getId());
            compound.m_128405_("InWaterTime", this.m_20069_() ? this.inWaterTime : -1);
            compound.m_128405_("DrownedConversionTime", this.isUnderWaterConverting() ? this.conversionTime : -1);
            compound.m_128405_("ConversionTime", this.isConverting() ? this.curingTime : -1);
            if (this.curingUUID != null) {
                compound.m_128362_("ConversionPlayer", this.curingUUID);
            }
        }
    }

    @Inject(method={"doHurtTarget(Lnet/minecraft/world/entity/Entity;)Z"}, at={@At(value="RETURN")})
    private void doHurtTarget(Entity target, CallbackInfoReturnable<Boolean> callback) {
        if (((Boolean)callback.getReturnValue()).booleanValue() && this.m_21205_().m_41619_()) {
            float difficulty = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            if (this.getInfection() == ZombieType.Husk && target instanceof LivingEntity) {
                LivingEntity victim = (LivingEntity)target;
                victim.m_147207_(new MobEffectInstance(MobEffects.f_19612_, 140 * (int)difficulty), (Entity)this);
            }
            if (this.m_6060_() && this.f_19796_.m_188501_() < difficulty * 0.3f) {
                target.m_20254_(2 * (int)difficulty);
            }
        }
    }

    @Inject(method={"getHurtSound(Lnet/minecraft/world/damagesource/DamageSource;)Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getHurtSound(DamageSource source, CallbackInfoReturnable<SoundEvent> callback) {
        SoundEvent hurtSound;
        if (this.getInfection() == ZombieType.Drowned && this.entity().m_20069_()) {
            callback.setReturnValue((Object)SoundEvents.f_11820_);
        }
        if ((hurtSound = this.getInfection().info().hurtSound) != null) {
            callback.setReturnValue((Object)hurtSound);
        }
    }

    @Inject(method={"getDeathSound()Lnet/minecraft/sounds/SoundEvent;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDeathSound(CallbackInfoReturnable<SoundEvent> callback) {
        SoundEvent deathSound;
        if (this.getInfection() == ZombieType.Drowned && this.entity().m_20069_()) {
            callback.setReturnValue((Object)SoundEvents.f_11818_);
        }
        if ((deathSound = this.getInfection().info().deathSound) != null) {
            callback.setReturnValue((Object)deathSound);
        }
    }

    @Inject(method={"getStandingEyeHeight(Lnet/minecraft/world/entity/Pose;Lnet/minecraft/world/entity/EntityDimensions;)F"}, at={@At(value="RETURN")}, cancellable=true)
    private void getStandingEyeHeight(Pose pose, EntityDimensions hitbox, CallbackInfoReturnable<Float> callback) {
        if (this.isInfected() && this.getInfection().info().type != EntityType.f_20532_) {
            float eyeLevel = switch (pose) {
                default -> 1.74f;
                case Pose.CROUCHING -> 1.32f;
                case Pose.FALL_FLYING -> 0.42f;
                case Pose.SPIN_ATTACK -> 0.42f;
            };
            callback.setReturnValue((Object)Float.valueOf(eyeLevel));
        }
    }

    @Inject(method={"getDimensions(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/entity/EntityDimensions;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> callback) {
        if (this.isInfected() && this.getInfection().info().type != EntityType.f_20532_) {
            callback.setReturnValue((Object)PlayerMixin.dynamicHitbox(this.getInfection().info().type.m_20680_(), pose));
        }
    }

    private static EntityDimensions dynamicHitbox(EntityDimensions hitbox, Pose pose) {
        float smallerSide = Math.min(hitbox.f_20377_, hitbox.f_20378_);
        EntityDimensions smallHitbox = EntityDimensions.m_20395_((float)smallerSide, (float)smallerSide);
        EntityDimensions tinyHitbox = EntityDimensions.m_20395_((float)(smallerSide * 0.666f), (float)(smallerSide * 0.666f));
        hitbox = switch (pose) {
            default -> hitbox;
            case Pose.FALL_FLYING -> smallHitbox;
            case Pose.SLEEPING -> tinyHitbox;
            case Pose.SPIN_ATTACK -> smallHitbox;
            case Pose.CROUCHING -> EntityDimensions.m_20395_((float)hitbox.f_20377_, (float)(hitbox.f_20378_ * 0.833f));
            case Pose.DYING -> tinyHitbox;
        };
        return hitbox;
    }

    @Inject(method={"getMyRidingOffset()D"}, at={@At(value="RETURN")}, cancellable=true)
    private void getMyRidingOffset(CallbackInfoReturnable<Double> callback) {
        if (this.isInfected()) {
            callback.setReturnValue((Object)(this.m_6162_() ? 0.0 : -0.45));
        }
    }

    @Inject(method={"canSprint()Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void canSprint(CallbackInfoReturnable<Boolean> callback) {
        if (!this.getInfection().info().allowSprint) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"updateSwimming()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateSwimming(CallbackInfo callback) {
        if (this.f_36077_.f_35935_) {
            return;
        }
        if (!this.getInfection().info().allowSwim) {
            this.m_20282_(false);
            callback.cancel();
            return;
        }
        if (!this.getInfection().info().allowSprint) {
            if (this.m_6069_()) {
                this.m_20282_((this.m_20069_() || this.isInFluidType((fluidType, height) -> this.canSwimInFluidType((FluidType)fluidType))) && !this.m_20159_());
            } else {
                this.m_20282_((this.m_5842_() || this.canStartSwimming()) && !this.m_20159_());
            }
            callback.cancel();
            return;
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo callback) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (this.m_6084_() && this.isConverting()) {
                int progress = this.getConversionProgress();
                this.curingTime -= progress;
                if (this.curingTime <= 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20492_, timer -> {
                    this.curingTime = timer;
                })) {
                    this.finishConversion(server);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && this.m_6084_()) {
            if (this.isUnderWaterConverting()) {
                --this.conversionTime;
                if (this.conversionTime < 0 && ForgeEventFactory.canLivingConvert((LivingEntity)this, (EntityType)EntityType.f_20562_, timer -> {
                    this.conversionTime = timer;
                })) {
                    this.doUnderWaterConversion();
                }
            } else if (this.convertsInWater()) {
                if (this.m_204029_(FluidTags.f_13131_)) {
                    ++this.inWaterTime;
                    if (this.inWaterTime >= 600) {
                        this.startUnderWaterConversion(300);
                    }
                } else {
                    this.inWaterTime = -1;
                }
            }
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="HEAD")})
    private void aiStep(CallbackInfo callback) {
        if (this.m_6084_() && this.getInfection().info().dayBurning && this.isSunBurnTick()) {
            ItemStack helmet = this.entity().m_6844_(EquipmentSlot.HEAD);
            if (!helmet.m_41619_()) {
                if (helmet.m_41763_()) {
                    helmet.m_41721_(helmet.m_41773_() + this.m_217043_().m_188503_(2));
                    if (helmet.m_41773_() >= helmet.m_41776_()) {
                        this.m_21166_(EquipmentSlot.HEAD);
                        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                    }
                }
            } else {
                this.m_20254_(8);
            }
        }
    }
}

