/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import com.shim.celestialexploration.blocks.CelestialProperties;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AirlockDoorBlock
extends Block {
    public static final EnumProperty<CelestialProperties.AirlockDoorHingeSide> HINGE = CelestialProperties.HINGE;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SW_CORNER_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NW_CORNER_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)5.0);
    protected static final VoxelShape NE_CORNER_AABB = Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    protected static final VoxelShape SE_CORNER_AABB = Block.m_49796_((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final Vec2 MAX_SIZE = new Vec2(5.0f, 5.0f);

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        boolean notOpen;
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        boolean bl = notOpen = (Boolean)state.m_61143_((Property)OPEN) == false;
        if (!notOpen && state.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.NON_HINGE) {
            return Shapes.m_83040_();
        }
        boolean hingeOnRight = state.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT;
        return switch (direction) {
            case Direction.EAST -> {
                if (notOpen) {
                    yield EAST_AABB;
                }
                if (hingeOnRight) {
                    yield SW_CORNER_AABB;
                }
                yield NW_CORNER_AABB;
            }
            case Direction.SOUTH -> {
                if (notOpen) {
                    yield SOUTH_AABB;
                }
                if (hingeOnRight) {
                    yield NW_CORNER_AABB;
                }
                yield NE_CORNER_AABB;
            }
            case Direction.WEST -> {
                if (notOpen) {
                    yield WEST_AABB;
                }
                if (hingeOnRight) {
                    yield NE_CORNER_AABB;
                }
                yield SE_CORNER_AABB;
            }
            case Direction.NORTH -> {
                if (notOpen) {
                    yield NORTH_AABB;
                }
                if (hingeOnRight) {
                    yield SE_CORNER_AABB;
                }
                yield SW_CORNER_AABB;
            }
            default -> notOpen ? EAST_AABB : (hingeOnRight ? SW_CORNER_AABB : NW_CORNER_AABB);
        };
    }

    public AirlockDoorBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)((Object)CelestialProperties.AirlockDoorHingeSide.LEFT)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_52803_) {
        p_52803_.m_61104_(new Property[]{FACING, OPEN, HINGE, POWERED});
    }

    public boolean m_7898_(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockBelow = pos.m_7495_();
        BlockPos blockAbove = pos.m_7494_();
        BlockState blockstateBelow = levelReader.m_8055_(blockBelow);
        BlockState blockstateAbove = levelReader.m_8055_(blockAbove);
        return blockstateBelow.m_60783_((BlockGetter)levelReader, blockBelow, Direction.UP) || blockstateAbove.m_60783_((BlockGetter)levelReader, blockAbove, Direction.DOWN) || blockstateBelow.m_60734_() instanceof AirlockDoorBlock || blockstateAbove.m_60734_() instanceof AirlockDoorBlock;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing;
        int oppositeNeighbor = this.neighborHasOppositeHinge(context);
        boolean shouldHaveHinge = !this.hasNeighbor(context) || this.aboveOrBelowHinge(context) || oppositeNeighbor > 0 || this.hasReachedMaxWidth(context);
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        boolean powered = level.m_46753_(clickedPos) || level.m_46753_(clickedPos.m_7494_()) || level.m_46753_(clickedPos.m_7495_());
        BlockState blockBelow = context.m_43725_().m_8055_(clickedPos.m_7495_());
        BlockState blockAbove = context.m_43725_().m_8055_(clickedPos.m_7494_());
        Direction direction = blockBelow.m_60734_() instanceof AirlockDoorBlock ? (Direction)blockBelow.m_61143_((Property)FACING) : (facing = blockAbove.m_60734_() instanceof AirlockDoorBlock ? (Direction)blockAbove.m_61143_((Property)FACING) : context.m_8125_());
        CelestialProperties.AirlockDoorHingeSide hingeSide = shouldHaveHinge ? (blockBelow.m_60734_() instanceof AirlockDoorBlock ? (CelestialProperties.AirlockDoorHingeSide)((Object)blockBelow.m_61143_(HINGE)) : (blockAbove.m_60734_() instanceof AirlockDoorBlock ? (CelestialProperties.AirlockDoorHingeSide)((Object)blockAbove.m_61143_(HINGE)) : (oppositeNeighbor == 1 ? CelestialProperties.AirlockDoorHingeSide.LEFT : (oppositeNeighbor == 2 ? CelestialProperties.AirlockDoorHingeSide.RIGHT : this.getHinge(context))))) : CelestialProperties.AirlockDoorHingeSide.NON_HINGE;
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HINGE, (Comparable)((Object)hingeSide))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
    }

    public boolean hasReachedMaxWidth(BlockPlaceContext context) {
        BlockState block;
        Level blockgetter = context.m_43725_();
        Direction direction = context.m_8125_();
        Direction clockWise = direction.m_122427_();
        Direction counterClockWise = direction.m_122428_();
        int distToLeft = 0;
        int distToRight = 0;
        int i = 0;
        while ((float)i < AirlockDoorBlock.MAX_SIZE.f_82470_) {
            block = blockgetter.m_8055_(context.m_8083_().m_5484_(counterClockWise, i + 1));
            if (block.m_60734_() instanceof AirlockDoorBlock && block.m_61143_(HINGE) != CelestialProperties.AirlockDoorHingeSide.NON_HINGE) {
                return false;
            }
            ++distToLeft;
            ++i;
        }
        if ((float)distToLeft > AirlockDoorBlock.MAX_SIZE.f_82470_) {
            return true;
        }
        i = 0;
        while ((float)i < AirlockDoorBlock.MAX_SIZE.f_82470_ + 1.0f) {
            block = blockgetter.m_8055_(context.m_8083_().m_5484_(clockWise, i + 1));
            if (block.m_60734_() instanceof AirlockDoorBlock && block.m_61143_(HINGE) != CelestialProperties.AirlockDoorHingeSide.NON_HINGE) {
                return false;
            }
            ++distToRight;
            ++i;
        }
        return (float)(distToRight + distToLeft) > AirlockDoorBlock.MAX_SIZE.f_82470_ - 1.0f;
    }

    public boolean hasNeighbor(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        Direction direction = context.m_8125_();
        Direction directionOne = direction.m_122427_();
        Direction directionTwo = direction.m_122428_();
        BlockState above = blockgetter.m_8055_(context.m_8083_().m_7494_());
        BlockState below = blockgetter.m_8055_(context.m_8083_().m_7495_());
        BlockState toLeft = blockgetter.m_8055_(context.m_8083_().m_142300_(directionOne));
        BlockState toRight = blockgetter.m_8055_(context.m_8083_().m_142300_(directionTwo));
        return this.isSameAndFacing(toLeft, direction) || this.isSameAndFacing(toRight, direction) || this.isSameAndFacing(above, direction) || this.isSameAndFacing(below, direction);
    }

    public int neighborHasOppositeHinge(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        Direction direction = context.m_8125_();
        Direction directionOne = direction.m_122427_();
        Direction directionTwo = direction.m_122428_();
        BlockState toLeft = blockgetter.m_8055_(context.m_8083_().m_142300_(directionTwo));
        BlockState toRight = blockgetter.m_8055_(context.m_8083_().m_142300_(directionOne));
        if (toLeft.m_60734_() instanceof AirlockDoorBlock && ((CelestialProperties.AirlockDoorHingeSide)((Object)toLeft.m_61143_(HINGE))).toString().equals("right")) {
            return 1;
        }
        if (toRight.m_60734_() instanceof AirlockDoorBlock && ((CelestialProperties.AirlockDoorHingeSide)((Object)toRight.m_61143_(HINGE))).toString().equals("left")) {
            return 2;
        }
        return 0;
    }

    public boolean isSameAndFacing(BlockState compared, Direction direction) {
        if (!(compared.m_60734_() instanceof AirlockDoorBlock)) {
            return false;
        }
        return compared.m_61143_((Property)FACING) == direction;
    }

    public boolean aboveOrBelowHinge(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        BlockState above = blockgetter.m_8055_(context.m_8083_().m_7494_());
        BlockState below = blockgetter.m_8055_(context.m_8083_().m_7495_());
        if (above.m_60734_() instanceof AirlockDoorBlock && AirlockDoorBlock.isHinge(above)) {
            return true;
        }
        return below.m_60734_() instanceof AirlockDoorBlock && AirlockDoorBlock.isHinge(below);
    }

    public boolean isOpen(BlockState p_52816_) {
        return (Boolean)p_52816_.m_61143_((Property)OPEN);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (this.f_60442_ == Material.f_76279_) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.m_61122_((Property)OPEN);
        level.m_7731_(pos, state, 10);
        level.m_5898_(player, (Boolean)state.m_61143_((Property)OPEN) != false ? this.getOpenSound() : this.getCloseSound(), pos, 0);
        level.m_142346_((Entity)player, this.isOpen(state) ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        level.m_46672_(pos, (Block)this);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_6861_(BlockState self, Level level, BlockPos selfPos, Block block, BlockPos neighborPos, boolean p_52781_) {
        BlockState neighbor = level.m_8055_(neighborPos);
        if (neighbor.m_60734_() instanceof AirlockDoorBlock) {
            boolean isOpen = (Boolean)neighbor.m_61143_((Property)OPEN);
            if (neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.NON_HINGE || self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.NON_HINGE) {
                if (neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.NON_HINGE && self.m_61143_(HINGE) != CelestialProperties.AirlockDoorHingeSide.NON_HINGE) {
                    if (!(self.m_61143_((Property)FACING) == Direction.NORTH && selfPos.m_123341_() < neighborPos.m_123341_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.NORTH && selfPos.m_123341_() > neighborPos.m_123341_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || self.m_61143_((Property)FACING) == Direction.SOUTH && selfPos.m_123341_() < neighborPos.m_123341_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || self.m_61143_((Property)FACING) == Direction.SOUTH && selfPos.m_123341_() > neighborPos.m_123341_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.WEST && selfPos.m_123343_() > neighborPos.m_123343_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.WEST && selfPos.m_123343_() < neighborPos.m_123343_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || self.m_61143_((Property)FACING) == Direction.EAST && selfPos.m_123343_() < neighborPos.m_123343_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.EAST && selfPos.m_123343_() > neighborPos.m_123343_() && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || neighbor.m_61143_((Property)FACING) != self.m_61143_((Property)FACING))) {
                        level.m_46597_(selfPos, (BlockState)self.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(isOpen)));
                    }
                } else if (neighbor.m_61143_(HINGE) != CelestialProperties.AirlockDoorHingeSide.NON_HINGE && self.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.NON_HINGE) {
                    if (!(self.m_61143_((Property)FACING) == Direction.NORTH && selfPos.m_123341_() < neighborPos.m_123341_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || self.m_61143_((Property)FACING) == Direction.NORTH && selfPos.m_123341_() > neighborPos.m_123341_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.SOUTH && selfPos.m_123341_() < neighborPos.m_123341_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.SOUTH && selfPos.m_123341_() > neighborPos.m_123341_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || self.m_61143_((Property)FACING) == Direction.WEST && selfPos.m_123343_() < neighborPos.m_123343_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.WEST && selfPos.m_123343_() > neighborPos.m_123343_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || self.m_61143_((Property)FACING) == Direction.EAST && selfPos.m_123343_() > neighborPos.m_123343_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.RIGHT || self.m_61143_((Property)FACING) == Direction.EAST && selfPos.m_123343_() < neighborPos.m_123343_() && neighbor.m_61143_(HINGE) == CelestialProperties.AirlockDoorHingeSide.LEFT || neighbor.m_61143_((Property)FACING) != self.m_61143_((Property)FACING))) {
                        level.m_46597_(selfPos, (BlockState)self.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(isOpen)));
                    }
                } else if (neighbor.m_61143_((Property)FACING) == self.m_61143_((Property)FACING)) {
                    level.m_46597_(selfPos, (BlockState)self.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(isOpen)));
                }
            }
        }
        boolean neighborSignal = level.m_46753_(selfPos);
        if (!this.m_49966_().m_60713_(block) && neighborSignal != (Boolean)self.m_61143_((Property)POWERED)) {
            if (neighborSignal != (Boolean)self.m_61143_((Property)OPEN)) {
                this.playSound(level, selfPos, neighborSignal);
                level.m_151555_(neighborSignal ? GameEvent.f_157796_ : GameEvent.f_157793_, selfPos);
            }
            level.m_46597_(selfPos, (BlockState)((BlockState)self.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(neighborSignal))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(neighborSignal)));
        }
    }

    private void playSound(Level p_52760_, BlockPos p_52761_, boolean p_52762_) {
        p_52760_.m_5898_(null, p_52762_ ? this.getOpenSound() : this.getCloseSound(), p_52761_, 0);
    }

    private int getCloseSound() {
        return 1011;
    }

    private int getOpenSound() {
        return 1005;
    }

    public static boolean isHinge(BlockState state) {
        return state.m_61143_(HINGE) != CelestialProperties.AirlockDoorHingeSide.NON_HINGE;
    }

    private CelestialProperties.AirlockDoorHingeSide getHinge(BlockPlaceContext context) {
        Level blockgetter = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        Direction direction = context.m_8125_();
        BlockPos blockAboveClicked = clickedPos.m_7494_();
        Direction direction1 = direction.m_122428_();
        BlockPos blockpos2 = clickedPos.m_142300_(direction1);
        BlockState blockstate = blockgetter.m_8055_(blockpos2);
        BlockPos blockpos3 = blockAboveClicked.m_142300_(direction1);
        BlockState blockstate1 = blockgetter.m_8055_(blockpos3);
        Direction direction2 = direction.m_122427_();
        BlockPos blockpos4 = clickedPos.m_142300_(direction2);
        BlockState blockstate2 = blockgetter.m_8055_(blockpos4);
        BlockPos blockpos5 = blockAboveClicked.m_142300_(direction2);
        BlockState blockstate3 = blockgetter.m_8055_(blockpos5);
        int i = (blockstate.m_60838_((BlockGetter)blockgetter, blockpos2) ? -1 : 0) + (blockstate1.m_60838_((BlockGetter)blockgetter, blockpos3) ? -1 : 0) + (blockstate2.m_60838_((BlockGetter)blockgetter, blockpos4) ? 1 : 0) + (blockstate3.m_60838_((BlockGetter)blockgetter, blockpos5) ? 1 : 0);
        if (i <= 0) {
            if (i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3 = context.m_43720_();
                double d0 = vec3.f_82479_ - (double)clickedPos.m_123341_();
                double d1 = vec3.f_82481_ - (double)clickedPos.m_123343_();
                return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? CelestialProperties.AirlockDoorHingeSide.LEFT : CelestialProperties.AirlockDoorHingeSide.RIGHT;
            }
            return CelestialProperties.AirlockDoorHingeSide.LEFT;
        }
        return CelestialProperties.AirlockDoorHingeSide.RIGHT;
    }

    public BlockState m_6843_(BlockState p_52790_, Rotation p_52791_) {
        return (BlockState)p_52790_.m_61124_((Property)FACING, (Comparable)p_52791_.m_55954_((Direction)p_52790_.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState p_52787_, Mirror p_52788_) {
        return p_52788_ == Mirror.NONE ? p_52787_ : (BlockState)p_52787_.m_60717_(p_52788_.m_54846_((Direction)p_52787_.m_61143_((Property)FACING))).m_61122_(HINGE);
    }
}

