/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import com.google.common.collect.Lists;
import com.shim.celestialexploration.blocks.BaseMagRailBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;

public class MagRailState {
    private final Level level;
    private final BlockPos pos;
    private final BaseMagRailBlock block;
    private BlockState state;
    private final boolean isStraight;
    private final List<BlockPos> connections = Lists.newArrayList();
    private final boolean canMakeSlopes;

    public MagRailState(Level level, BlockPos pos, BlockState state) {
        this.level = level;
        this.pos = pos;
        this.state = state;
        this.block = (BaseMagRailBlock)state.m_60734_();
        RailShape railshape = this.block.getRailDirection(state, (BlockGetter)level, pos, null);
        this.isStraight = !this.block.isFlexibleRail(state, (BlockGetter)level, pos);
        this.canMakeSlopes = this.block.canMakeSlopes(state, (BlockGetter)level, pos);
        this.updateConnections(railshape);
    }

    public List<BlockPos> getConnections() {
        return this.connections;
    }

    private void updateConnections(RailShape shape) {
        this.connections.clear();
        switch (shape) {
            case NORTH_SOUTH: {
                this.connections.add(this.pos.m_142127_());
                this.connections.add(this.pos.m_142128_());
                break;
            }
            case EAST_WEST: {
                this.connections.add(this.pos.m_142125_());
                this.connections.add(this.pos.m_142126_());
                break;
            }
            case ASCENDING_EAST: {
                this.connections.add(this.pos.m_142125_());
                this.connections.add(this.pos.m_142126_().m_7494_());
                break;
            }
            case ASCENDING_WEST: {
                this.connections.add(this.pos.m_142125_().m_7494_());
                this.connections.add(this.pos.m_142126_());
                break;
            }
            case ASCENDING_NORTH: {
                this.connections.add(this.pos.m_142127_().m_7494_());
                this.connections.add(this.pos.m_142128_());
                break;
            }
            case ASCENDING_SOUTH: {
                this.connections.add(this.pos.m_142127_());
                this.connections.add(this.pos.m_142128_().m_7494_());
                break;
            }
            case SOUTH_EAST: {
                this.connections.add(this.pos.m_142126_());
                this.connections.add(this.pos.m_142128_());
                break;
            }
            case SOUTH_WEST: {
                this.connections.add(this.pos.m_142125_());
                this.connections.add(this.pos.m_142128_());
                break;
            }
            case NORTH_WEST: {
                this.connections.add(this.pos.m_142125_());
                this.connections.add(this.pos.m_142127_());
                break;
            }
            case NORTH_EAST: {
                this.connections.add(this.pos.m_142126_());
                this.connections.add(this.pos.m_142127_());
            }
        }
    }

    private void removeSoftConnections() {
        for (int i = 0; i < this.connections.size(); ++i) {
            MagRailState railstate = this.getRail(this.connections.get(i));
            if (railstate != null && railstate.connectsTo(this)) {
                this.connections.set(i, railstate.pos);
                continue;
            }
            this.connections.remove(i--);
        }
    }

    private boolean hasRail(BlockPos pos) {
        return BaseMagRailBlock.isRail(this.level, pos) || BaseMagRailBlock.isRail(this.level, pos.m_7494_()) || BaseMagRailBlock.isRail(this.level, pos.m_7495_());
    }

    @Nullable
    private MagRailState getRail(BlockPos pos) {
        BlockState blockstate = this.level.m_8055_(pos);
        if (BaseMagRailBlock.isRail(blockstate)) {
            return new MagRailState(this.level, pos, blockstate);
        }
        BlockPos $$1 = pos.m_7494_();
        blockstate = this.level.m_8055_($$1);
        if (BaseMagRailBlock.isRail(blockstate)) {
            return new MagRailState(this.level, $$1, blockstate);
        }
        $$1 = pos.m_7495_();
        blockstate = this.level.m_8055_($$1);
        return BaseMagRailBlock.isRail(blockstate) ? new MagRailState(this.level, $$1, blockstate) : null;
    }

    private boolean connectsTo(MagRailState state) {
        return this.hasConnection(state.pos);
    }

    private boolean hasConnection(BlockPos pos) {
        for (int i = 0; i < this.connections.size(); ++i) {
            BlockPos blockpos = this.connections.get(i);
            if (blockpos.m_123341_() != pos.m_123341_() || blockpos.m_123343_() != pos.m_123343_()) continue;
            return true;
        }
        return false;
    }

    public int countPotentialConnections() {
        int i = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.hasRail(this.pos.m_142300_(direction))) continue;
            ++i;
        }
        return i;
    }

    private boolean canConnectTo(MagRailState railState) {
        return this.connectsTo(railState) || this.connections.size() != 2;
    }

    private void connectTo(MagRailState railState) {
        this.connections.add(railState.pos);
        BlockPos posNorth = this.pos.m_142127_();
        BlockPos posSouth = this.pos.m_142128_();
        BlockPos posWest = this.pos.m_142125_();
        BlockPos posEast = this.pos.m_142126_();
        boolean hasNorth = this.hasConnection(posNorth);
        boolean hasSouth = this.hasConnection(posSouth);
        boolean hasWest = this.hasConnection(posWest);
        boolean hasEast = this.hasConnection(posEast);
        RailShape railshape = null;
        if (hasNorth || hasSouth) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if (hasWest || hasEast) {
            railshape = RailShape.EAST_WEST;
        }
        if (!this.isStraight) {
            if (hasSouth && hasEast && !hasNorth && !hasWest) {
                railshape = RailShape.SOUTH_EAST;
            }
            if (hasSouth && hasWest && !hasNorth && !hasEast) {
                railshape = RailShape.SOUTH_WEST;
            }
            if (hasNorth && hasWest && !hasSouth && !hasEast) {
                railshape = RailShape.NORTH_WEST;
            }
            if (hasNorth && hasEast && !hasSouth && !hasWest) {
                railshape = RailShape.NORTH_EAST;
            }
        }
        if (railshape == RailShape.NORTH_SOUTH && this.canMakeSlopes) {
            if (BaseMagRailBlock.isRail(this.level, posNorth.m_7494_())) {
                railshape = RailShape.ASCENDING_NORTH;
            }
            if (BaseMagRailBlock.isRail(this.level, posSouth.m_7494_())) {
                railshape = RailShape.ASCENDING_SOUTH;
            }
        }
        if (railshape == RailShape.EAST_WEST && this.canMakeSlopes) {
            if (BaseMagRailBlock.isRail(this.level, posEast.m_7494_())) {
                railshape = RailShape.ASCENDING_EAST;
            }
            if (BaseMagRailBlock.isRail(this.level, posWest.m_7494_())) {
                railshape = RailShape.ASCENDING_WEST;
            }
        }
        if (railshape == null) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if (!this.block.isValidRailShape(railshape)) {
            this.connections.remove(railState.pos);
            return;
        }
        this.state = (BlockState)this.state.m_61124_(this.block.getShapeProperty(), (Comparable)railshape);
        this.level.m_7731_(this.pos, this.state, 3);
    }

    private boolean hasNeighborRail(BlockPos p_55447_) {
        MagRailState railstate = this.getRail(p_55447_);
        if (railstate == null) {
            return false;
        }
        railstate.removeSoftConnections();
        return railstate.canConnectTo(this);
    }

    public MagRailState place(boolean p_55432_, boolean p_55433_, RailShape railShape) {
        boolean hasNorthWest;
        boolean hasEastOrWest;
        BlockPos posNorth = this.pos.m_142127_();
        BlockPos posSouth = this.pos.m_142128_();
        BlockPos posWest = this.pos.m_142125_();
        BlockPos posEast = this.pos.m_142126_();
        boolean hasNorth = this.hasNeighborRail(posNorth);
        boolean hasSouth = this.hasNeighborRail(posSouth);
        boolean hasWest = this.hasNeighborRail(posWest);
        boolean hasEast = this.hasNeighborRail(posEast);
        RailShape railshape = null;
        boolean hasNorthOrSouth = hasNorth || hasSouth;
        boolean bl = hasEastOrWest = hasWest || hasEast;
        if (hasNorthOrSouth && !hasEastOrWest) {
            railshape = RailShape.NORTH_SOUTH;
        }
        if (hasEastOrWest && !hasNorthOrSouth) {
            railshape = RailShape.EAST_WEST;
        }
        boolean hasSouthEast = hasSouth && hasEast;
        boolean hasSouthWest = hasSouth && hasWest;
        boolean hasNorthEast = hasNorth && hasEast;
        boolean bl2 = hasNorthWest = hasNorth && hasWest;
        if (!this.isStraight) {
            if (hasSouthEast && !hasNorth && !hasWest) {
                railshape = RailShape.SOUTH_EAST;
            }
            if (hasSouthWest && !hasNorth && !hasEast) {
                railshape = RailShape.SOUTH_WEST;
            }
            if (hasNorthWest && !hasSouth && !hasEast) {
                railshape = RailShape.NORTH_WEST;
            }
            if (hasNorthEast && !hasSouth && !hasWest) {
                railshape = RailShape.NORTH_EAST;
            }
        }
        if (railshape == null) {
            if (hasNorthOrSouth && hasEastOrWest) {
                railshape = railShape;
            } else if (hasNorthOrSouth) {
                railshape = RailShape.NORTH_SOUTH;
            } else if (hasEastOrWest) {
                railshape = RailShape.EAST_WEST;
            }
            if (!this.isStraight) {
                if (p_55432_) {
                    if (hasSouthEast) {
                        railshape = RailShape.SOUTH_EAST;
                    }
                    if (hasSouthWest) {
                        railshape = RailShape.SOUTH_WEST;
                    }
                    if (hasNorthEast) {
                        railshape = RailShape.NORTH_EAST;
                    }
                    if (hasNorthWest) {
                        railshape = RailShape.NORTH_WEST;
                    }
                } else {
                    if (hasNorthWest) {
                        railshape = RailShape.NORTH_WEST;
                    }
                    if (hasNorthEast) {
                        railshape = RailShape.NORTH_EAST;
                    }
                    if (hasSouthWest) {
                        railshape = RailShape.SOUTH_WEST;
                    }
                    if (hasSouthEast) {
                        railshape = RailShape.SOUTH_EAST;
                    }
                }
            }
        }
        if (railshape == RailShape.NORTH_SOUTH && this.canMakeSlopes) {
            if (BaseMagRailBlock.isRail(this.level, posNorth.m_7494_())) {
                railshape = RailShape.ASCENDING_NORTH;
            }
            if (BaseMagRailBlock.isRail(this.level, posSouth.m_7494_())) {
                railshape = RailShape.ASCENDING_SOUTH;
            }
        }
        if (railshape == RailShape.EAST_WEST && this.canMakeSlopes) {
            if (BaseMagRailBlock.isRail(this.level, posEast.m_7494_())) {
                railshape = RailShape.ASCENDING_EAST;
            }
            if (BaseMagRailBlock.isRail(this.level, posWest.m_7494_())) {
                railshape = RailShape.ASCENDING_WEST;
            }
        }
        if (railshape == null || !this.block.isValidRailShape(railshape)) {
            railshape = railShape;
        }
        this.updateConnections(railshape);
        this.state = (BlockState)this.state.m_61124_(this.block.getShapeProperty(), (Comparable)railshape);
        if (p_55433_ || this.level.m_8055_(this.pos) != this.state) {
            this.level.m_7731_(this.pos, this.state, 3);
            for (BlockPos connection : this.connections) {
                MagRailState railstate = this.getRail(connection);
                if (railstate == null) continue;
                railstate.removeSoftConnections();
                if (!railstate.canConnectTo(this)) continue;
                railstate.connectTo(this);
            }
        }
        return this;
    }

    public BlockState getState() {
        return this.state;
    }
}

