/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.blockentities.TaxiStationBlockEntity;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.registry.CelestialBlockEntities;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public class TaxiStationBlock
extends BaseEntityBlock {
    public TaxiStationBlock(BlockBehaviour.Properties p_49224_) {
        super(p_49224_);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TaxiStationBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return TaxiStationBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)CelestialBlockEntities.TAXI_STATION_BLOCK_ENTITY.get()), TaxiStationBlockEntity::tick);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        TaxiCapability.ITaxi taxiCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.TAXI_CAPABILITY);
        if (taxiCap != null) {
            taxiCap.removeTaxiStations(pos);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        TaxiCapability.ITaxi taxiCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.TAXI_CAPABILITY);
        if (taxiCap != null && !taxiCap.existsAtThisPos(pos)) {
            taxiCap.addTaxiStations(new TaxiCapability.TaxiStationData(pos, (ResourceKey<Level>)level.m_46472_(), (Component)new TextComponent(state.m_60734_().m_49954_().getString() + " " + (taxiCap.getTaxiStations().size() + 1))));
        }
        if (!level.m_5776_()) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof TaxiStationBlockEntity) {
                TaxiStationBlockEntity blockEntity = (TaxiStationBlockEntity)entity;
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)blockEntity, (BlockPos)pos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }
}

