/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.blockentities.WorkbenchBlockEntity;
import com.shim.celestialexploration.registry.CelestialBlockEntities;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialFluids;
import com.shim.celestialexploration.registry.CelestialItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class WorkbenchBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public WorkbenchBlock(BlockBehaviour.Properties p_48687_) {
        super(p_48687_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.FALSE));
    }

    public BlockState m_5573_(BlockPlaceContext p_48689_) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)p_48689_.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_48725_) {
        p_48725_.m_61104_(new Property[]{FACING, LIT});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (state.m_60734_() != newState.m_60734_() && (blockEntity = level.m_7702_(pos)) instanceof WorkbenchBlockEntity) {
            ((WorkbenchBlockEntity)blockEntity).drops();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_()) {
            BlockEntity entity = level.m_7702_(pos);
            if (entity instanceof WorkbenchBlockEntity) {
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((WorkbenchBlockEntity)entity), (BlockPos)pos);
            } else {
                throw new IllegalStateException("Our Container provider is missing!");
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WorkbenchBlockEntity) {
            int i;
            FluidTank tank = ((WorkbenchBlockEntity)blockEntity).getFluidTank();
            if (tank.isEmpty()) {
                return;
            }
            ItemStack itemStack = WorkbenchBlock.getFullBucketItem(tank.getFluid());
            boolean numItems = false;
            int j = 0;
            for (i = 0; i < tank.getFluidAmount() / 1000; ++i) {
                itemStack = WorkbenchBlock.getFullBucketItem(tank.getFluid());
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
                CelestialExploration.LOGGER.debug("i:" + i + " fluidAmount / 1000: " + tank.getFluidAmount() / 1000);
                ++j;
            }
            itemStack = WorkbenchBlock.getPartialBucketItem(tank.getFluid());
            tank.drain(j * 1000, IFluidHandler.FluidAction.EXECUTE);
            for (i = 0; i < tank.getFluidAmount() / 100; ++i) {
                itemStack = WorkbenchBlock.getPartialBucketItem(tank.getFluid());
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)itemStack);
                CelestialExploration.LOGGER.debug("i:" + i + " fluidAmount / 100: " + tank.getFluidAmount() / 100);
            }
            CelestialExploration.LOGGER.debug("Fluid amount:" + tank.getFluidAmount());
        }
        super.m_5707_(level, pos, state, player);
    }

    private static ItemStack getFullBucketItem(FluidStack fluid) {
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_IRON.get(), 1))) {
            return new ItemStack((ItemLike)Items.f_41913_);
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_STEEL.get(), 1))) {
            return new ItemStack((ItemLike)CelestialBlocks.STEEL_BLOCK.get());
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_COPPER.get(), 1))) {
            return new ItemStack((ItemLike)Items.f_151000_);
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_GOLD.get(), 1))) {
            return new ItemStack((ItemLike)Items.f_41912_);
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_ALUMINUM.get(), 1))) {
            return new ItemStack((ItemLike)CelestialBlocks.ALUMINUM_BLOCK.get());
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack getPartialBucketItem(FluidStack fluid) {
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_IRON.get(), 1))) {
            return new ItemStack((ItemLike)Items.f_42416_);
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_STEEL.get(), 1))) {
            return new ItemStack((ItemLike)CelestialItems.STEEL_INGOT.get());
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_COPPER.get(), 1))) {
            return new ItemStack((ItemLike)Items.f_151052_);
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_GOLD.get(), 1))) {
            return new ItemStack((ItemLike)Items.f_42417_);
        }
        if (fluid.containsFluid(new FluidStack((Fluid)CelestialFluids.MOLTEN_ALUMINUM.get(), 1))) {
            return new ItemStack((ItemLike)CelestialItems.ALUMINUM_INGOT.get());
        }
        return ItemStack.f_41583_;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WorkbenchBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return WorkbenchBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)CelestialBlockEntities.WORKBENCH_BLOCK_ENTITY.get()), WorkbenchBlockEntity::tick);
    }
}

