/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.blocks.blockentities;

import com.google.common.collect.Lists;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.WorkbenchBlock;
import com.shim.celestialexploration.inventory.menus.WorkbenchMenu;
import com.shim.celestialexploration.item.BasinItem;
import com.shim.celestialexploration.recipes.WorkbenchCraftingRecipe;
import com.shim.celestialexploration.recipes.WorkbenchSmeltingRecipe;
import com.shim.celestialexploration.registry.CelestialBlockEntities;
import com.shim.celestialexploration.util.CelestialUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorkbenchBlockEntity
extends BlockEntity
implements MenuProvider {
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 100;
    private int fuelBurnTime = 0;
    private int maxFuelBurnTime;
    private int fluidLevel;
    public static int maxFluidLevel = 4000;
    private int fluidType;
    private final ItemStackHandler itemHandler = new ItemStackHandler(12){

        protected void onContentsChanged(int slot) {
            WorkbenchBlockEntity.this.m_6596_();
        }
    };
    protected FluidTank fluidHandler = new FluidTank(maxFluidLevel){

        protected void onContentsChanged() {
            WorkbenchBlockEntity.this.m_6596_();
        }
    };
    private LazyOptional<IFluidHandler> lazyFluidHandler = LazyOptional.of(() -> this.fluidHandler);
    private LazyOptional<IItemHandler> lazyItemHandler = LazyOptional.empty();
    private final Object2IntOpenHashMap<ResourceLocation> recipesUsed = new Object2IntOpenHashMap();

    public WorkbenchBlockEntity(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)CelestialBlockEntities.WORKBENCH_BLOCK_ENTITY.get(), worldPosition, blockState);
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> WorkbenchBlockEntity.this.progress;
                    case 1 -> WorkbenchBlockEntity.this.maxProgress;
                    case 2 -> WorkbenchBlockEntity.this.fuelBurnTime;
                    case 3 -> WorkbenchBlockEntity.this.maxFuelBurnTime;
                    case 4 -> WorkbenchBlockEntity.this.fluidLevel;
                    case 5 -> maxFluidLevel;
                    case 6 -> WorkbenchBlockEntity.this.fluidType;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        WorkbenchBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        WorkbenchBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        WorkbenchBlockEntity.this.fuelBurnTime = value;
                        break;
                    }
                    case 3: {
                        WorkbenchBlockEntity.this.maxFuelBurnTime = value;
                        break;
                    }
                    case 4: {
                        WorkbenchBlockEntity.this.fluidLevel = value;
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        WorkbenchBlockEntity.this.fluidType = value;
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public FluidTank getFluidTank() {
        return this.fluidHandler;
    }

    @NotNull
    public Component m_5446_() {
        return new TranslatableComponent("container.celestialexploration.workbench");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return new WorkbenchMenu(containerId, inventory, this, this.data, ContainerLevelAccess.m_39289_((Level)player.m_183503_(), (BlockPos)this.m_58899_()));
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.lazyItemHandler.cast();
        }
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.lazyFluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.lazyItemHandler = LazyOptional.of(() -> this.itemHandler);
        this.lazyFluidHandler = LazyOptional.of(() -> this.fluidHandler);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
        this.lazyFluidHandler.invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        tag.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        tag.m_128405_("workbench_smelting.progress", this.progress);
        tag.m_128405_("workbench_smelting.fuelBurnTime", this.fuelBurnTime);
        tag.m_128405_("workbench_smelting.fluidLevel", this.fluidLevel);
        tag.m_128405_("workbench_smelting.fluidType", this.fluidType);
        this.fluidHandler.writeToNBT(tag);
        super.m_183515_(tag);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.fluidHandler.readFromNBT(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        this.progress = nbt.m_128451_("workbench_smelting.progress");
        this.fuelBurnTime = nbt.m_128451_("workbench_smelting.fuelBurnTime");
        this.fluidLevel = nbt.m_128451_("workbench_smelting.fluidLevel");
        this.fluidType = nbt.m_128451_("workbench_smelting.fluidType");
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.f_58857_ != null);
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, WorkbenchBlockEntity blockEntity) {
        IFluidHandlerItem cap;
        boolean lit = blockEntity.isLit();
        boolean changed = false;
        SimpleContainer inventory = new SimpleContainer(blockEntity.itemHandler.getSlots());
        if (blockEntity.fluidHandler.getFluidAmount() <= 100) {
            blockEntity.fluidHandler.drain(blockEntity.fluidHandler.getFluid(), IFluidHandler.FluidAction.EXECUTE);
            blockEntity.fluidLevel = 0;
        }
        if (blockEntity.fluidHandler.getFluidAmount() == 999) {
            blockEntity.fluidHandler.setFluid(new FluidStack(blockEntity.fluidHandler.getFluid(), 1000));
            blockEntity.fluidLevel = 1000;
        } else if (blockEntity.fluidHandler.getFluidAmount() == 1999 || blockEntity.fluidHandler.getFluidAmount() == 1998) {
            blockEntity.fluidHandler.setFluid(new FluidStack(blockEntity.fluidHandler.getFluid(), 2000));
            blockEntity.fluidLevel = 2000;
        } else if (blockEntity.fluidHandler.getFluidAmount() >= 2997 && blockEntity.fluidHandler.getFluidAmount() < 3000) {
            blockEntity.fluidHandler.setFluid(new FluidStack(blockEntity.fluidHandler.getFluid(), 3000));
            blockEntity.fluidLevel = 3000;
        } else if (blockEntity.fluidHandler.getFluidAmount() >= 3996 && blockEntity.fluidHandler.getFluidAmount() < 4000) {
            blockEntity.fluidHandler.setFluid(new FluidStack(blockEntity.fluidHandler.getFluid(), 4000));
            blockEntity.fluidLevel = 4000;
        }
        for (int i = 0; i < blockEntity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, blockEntity.itemHandler.getStackInSlot(i));
        }
        if (lit) {
            --blockEntity.fuelBurnTime;
        }
        ItemStack fuelItem = blockEntity.itemHandler.getStackInSlot(1);
        ItemStack smeltItem = blockEntity.itemHandler.getStackInSlot(0);
        Item item = smeltItem.m_41720_();
        if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            if (WorkbenchBlockEntity.hasRecipe(blockEntity) && WorkbenchBlockEntity.canAddFluid(blockEntity, new FluidStack(bucket.getFluid(), 1000))) {
                WorkbenchBlockEntity.smeltItem(blockEntity);
                blockEntity.itemHandler.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42446_, 1));
            }
        }
        if (smeltItem.m_41720_() instanceof BasinItem && (cap = (IFluidHandlerItem)CelestialExploration.getCapability(smeltItem, CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY)) != null && WorkbenchBlockEntity.canAddFluid(blockEntity, new FluidStack(cap.getFluidInTank(0), 1))) {
            WorkbenchBlockEntity.addFluidViaBasin(blockEntity, smeltItem);
        }
        if (blockEntity.isLit() || !fuelItem.m_41619_() && !smeltItem.m_41619_()) {
            Optional recipe;
            if (!blockEntity.isLit() && WorkbenchBlockEntity.hasRecipe(blockEntity) && (recipe = level.m_7465_().m_44015_((RecipeType)WorkbenchSmeltingRecipe.Type.INSTANCE, (Container)inventory, level)).isPresent() && WorkbenchBlockEntity.canAddFluid(blockEntity, ((WorkbenchSmeltingRecipe)recipe.get()).getResultFluid())) {
                blockEntity.maxFuelBurnTime = blockEntity.fuelBurnTime = ForgeHooks.getBurnTime((ItemStack)fuelItem, (RecipeType)RecipeType.f_44108_);
                if (blockEntity.isLit()) {
                    changed = true;
                    if (fuelItem.hasContainerItem()) {
                        blockEntity.itemHandler.setStackInSlot(1, fuelItem.getContainerItem());
                    } else if (!fuelItem.m_41619_()) {
                        fuelItem.m_41774_(1);
                        if (fuelItem.m_41619_()) {
                            blockEntity.itemHandler.setStackInSlot(1, fuelItem.getContainerItem());
                        }
                    }
                }
            }
            if (blockEntity.isLit() && WorkbenchBlockEntity.hasRecipe(blockEntity)) {
                recipe = level.m_7465_().m_44015_((RecipeType)WorkbenchSmeltingRecipe.Type.INSTANCE, (Container)inventory, level);
                if (recipe.isPresent() && WorkbenchBlockEntity.canAddFluid(blockEntity, ((WorkbenchSmeltingRecipe)recipe.get()).getResultFluid()) && WorkbenchBlockEntity.hasRoomForFluid(blockEntity, (WorkbenchSmeltingRecipe)recipe.get())) {
                    blockEntity.maxProgress = ((WorkbenchSmeltingRecipe)recipe.get()).getCookingTime();
                    ++blockEntity.progress;
                    if (blockEntity.progress == blockEntity.maxProgress) {
                        blockEntity.progress = 0;
                        blockEntity.maxProgress = ((WorkbenchSmeltingRecipe)recipe.get()).getCookingTime();
                        WorkbenchBlockEntity.smeltItem(blockEntity);
                        blockEntity.setRecipeUsed((Recipe)recipe.get());
                        changed = true;
                    }
                }
            } else {
                blockEntity.progress = 0;
            }
        } else if (!blockEntity.isLit() && blockEntity.progress > 0) {
            blockEntity.progress = Mth.m_14045_((int)(blockEntity.progress - 2), (int)0, (int)blockEntity.maxProgress);
        }
        if (lit != blockEntity.isLit()) {
            changed = true;
            state = (BlockState)state.m_61124_((Property)WorkbenchBlock.LIT, (Comparable)Boolean.valueOf(blockEntity.isLit()));
            level.m_7731_(pos, state, 3);
        }
        if (changed) {
            WorkbenchBlockEntity.m_155232_((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private boolean isLit() {
        return this.fuelBurnTime > 0;
    }

    private static boolean hasRecipe(WorkbenchBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        Optional match = level.m_7465_().m_44015_((RecipeType)WorkbenchSmeltingRecipe.Type.INSTANCE, (Container)inventory, level);
        return match.isPresent();
    }

    public void setRecipeUsed(@javax.annotation.Nullable Recipe<?> p_58345_) {
        if (p_58345_ != null) {
            ResourceLocation resourcelocation = p_58345_.m_6423_();
            this.recipesUsed.addTo((Object)resourcelocation, 1);
        }
    }

    public void awardUsedRecipesAndPopExperience(ServerPlayer player) {
        List<Recipe<?>> list = this.getRecipesToAwardAndPopExperience(player.m_183503_(), player.m_20182_());
        player.m_7281_(list);
        this.recipesUsed.clear();
    }

    public List<Recipe<?>> getRecipesToAwardAndPopExperience(ServerLevel level, Vec3 pos) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.recipesUsed.object2IntEntrySet()) {
            level.m_7465_().m_44043_((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add(recipe);
                WorkbenchBlockEntity.createExperience(level, pos, entry.getIntValue(), ((WorkbenchCraftingRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private static void createExperience(ServerLevel level, Vec3 position, int p_155001_, float p_155002_) {
        int i = Mth.m_14143_((float)((float)p_155001_ * p_155002_));
        float f = Mth.m_14187_((float)((float)p_155001_ * p_155002_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        ExperienceOrb.m_147082_((ServerLevel)level, (Vec3)position, (int)i);
    }

    private static void smeltItem(WorkbenchBlockEntity entity) {
        Level level = entity.f_58857_;
        SimpleContainer inventory = new SimpleContainer(entity.itemHandler.getSlots());
        for (int i = 0; i < entity.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, entity.itemHandler.getStackInSlot(i));
        }
        assert (level != null);
        Optional recipe = level.m_7465_().m_44015_((RecipeType)WorkbenchSmeltingRecipe.Type.INSTANCE, (Container)inventory, level);
        if (recipe.isPresent()) {
            entity.itemHandler.extractItem(0, 1, false);
            FluidStack fluid = ((WorkbenchSmeltingRecipe)recipe.get()).getResultFluid();
            fluid.setAmount((int)(1000.0f * ((WorkbenchSmeltingRecipe)recipe.get()).getBuckets()));
            entity.fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            entity.fluidLevel = entity.fluidHandler.getFluidAmount();
            entity.fluidType = CelestialUtil.getIdFromFluid(entity.fluidHandler.getFluid());
        }
    }

    private static void addFluidViaBasin(WorkbenchBlockEntity blockEntity, ItemStack basin) {
        IFluidHandlerItem cap = (IFluidHandlerItem)CelestialExploration.getCapability(basin, CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
        if (cap != null) {
            int amount = Math.min(blockEntity.fluidHandler.getSpace(), cap.getFluidInTank(0).getAmount());
            FluidStack fluid = new FluidStack(cap.getFluidInTank(0), amount);
            blockEntity.fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
            blockEntity.fluidLevel = blockEntity.fluidHandler.getFluidAmount();
            blockEntity.fluidType = CelestialUtil.getIdFromFluid(blockEntity.fluidHandler.getFluid());
            cap.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private static boolean canAddFluid(WorkbenchBlockEntity blockEntity, FluidStack result) {
        if (blockEntity.fluidHandler.isEmpty()) {
            return true;
        }
        if (!blockEntity.fluidHandler.getFluid().isFluidEqual(result)) {
            return false;
        }
        if (!blockEntity.fluidHandler.isFluidValid(result)) {
            return false;
        }
        return blockEntity.fluidHandler.getSpace() != 0;
    }

    private static boolean hasRoomForFluid(WorkbenchBlockEntity blockEntity, WorkbenchSmeltingRecipe recipe) {
        return blockEntity.fluidHandler.getSpace() >= (int)(recipe.getBuckets() * 1000.0f);
    }
}

