/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.capabilities;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.packets.CelestialPacketHandler;
import com.shim.celestialexploration.packets.LightTravelDataPacket;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightTravelCapability {

    public static class LightTravelProvider
    implements ICapabilityProvider,
    ICapabilitySerializable<CompoundTag> {
        public static Capability<LightTravelHandler> LIGHT_TRAVEL = CapabilityManager.get((CapabilityToken)new CapabilityToken<LightTravelHandler>(){});
        private LightTravelHandler lightTravelHandler = null;
        private final LazyOptional<LightTravelHandler> lazyLightTravel = LazyOptional.of(this::createLightTravelHandler);

        @Nonnull
        private LightTravelHandler createLightTravelHandler() {
            if (this.lightTravelHandler == null) {
                this.lightTravelHandler = new LightTravelHandler();
            }
            return this.lightTravelHandler;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY.orEmpty(cap, this.lazyLightTravel.cast());
        }

        public CompoundTag serializeNBT() {
            return ((LightTravelHandler)this.lazyLightTravel.orElseThrow(NullPointerException::new)).getData();
        }

        public void deserializeNBT(CompoundTag nbt) {
            ((LightTravelHandler)this.lazyLightTravel.orElseThrow(NullPointerException::new)).setData(nbt);
        }
    }

    public static class LightTravelHandler
    implements ILightTravel {
        boolean beenToSpace = false;
        boolean beenToMars = false;
        boolean beenToVenus = false;
        boolean beenToMercury = false;
        boolean beenToJupiter = false;
        PlanetCooldown overworldCooldown = new PlanetCooldown();
        PlanetCooldown marsCooldown = new PlanetCooldown();
        PlanetCooldown venusCooldown = new PlanetCooldown();
        PlanetCooldown mercuryCooldown = new PlanetCooldown();
        PlanetCooldown jupiterCooldown = new PlanetCooldown();

        @Override
        public boolean hasBeenToSpace() {
            return this.beenToSpace;
        }

        @Override
        public boolean hasBeenToMars() {
            return this.beenToMars;
        }

        @Override
        public boolean hasBeenToVenus() {
            return this.beenToVenus;
        }

        @Override
        public boolean hasBeenToMercury() {
            return this.beenToMercury;
        }

        @Override
        public boolean hasBeenToJupiter() {
            return this.beenToJupiter;
        }

        @Override
        public void setBeenToSpace() {
            this.beenToSpace = true;
        }

        @Override
        public void setBeenToMars() {
            this.beenToMars = true;
        }

        @Override
        public void setBeenToVenus() {
            this.beenToVenus = true;
        }

        @Override
        public void setBeenToMercury() {
            this.beenToMercury = true;
        }

        @Override
        public void setBeenToJupiter() {
            this.beenToJupiter = true;
        }

        @Override
        public PlanetCooldown getOverworldCooldown() {
            return this.overworldCooldown;
        }

        @Override
        public PlanetCooldown getMarsCooldown() {
            return this.marsCooldown;
        }

        @Override
        public PlanetCooldown getVenusCooldown() {
            return this.venusCooldown;
        }

        @Override
        public PlanetCooldown getMercuryCooldown() {
            return this.mercuryCooldown;
        }

        @Override
        public PlanetCooldown getJupiterCooldown() {
            return this.jupiterCooldown;
        }

        @Override
        public void sync(Player player) {
            ServerPlayer serverPlayer;
            ILightTravel travelCap;
            if (player instanceof ServerPlayer && (travelCap = CelestialExploration.getCapability((Entity)(serverPlayer = (ServerPlayer)player), CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY)) != null) {
                PacketDistributor.PacketTarget targetPlayer = PacketDistributor.PLAYER.with(() -> serverPlayer);
                CelestialPacketHandler.INSTANCE.send(targetPlayer, (Object)new LightTravelDataPacket(serverPlayer.m_142049_(), travelCap.getData()));
            }
        }

        @Override
        public CompoundTag getData() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("mars", this.beenToMars);
            nbt.m_128379_("space", this.beenToSpace);
            nbt.m_128379_("venus", this.beenToVenus);
            nbt.m_128379_("mercury", this.beenToMercury);
            nbt.m_128379_("jupiter", this.beenToJupiter);
            nbt.m_128365_("mercury_cooldown", (Tag)this.mercuryCooldown.save());
            nbt.m_128365_("venus_cooldown", (Tag)this.venusCooldown.save());
            nbt.m_128365_("overworld_cooldown", (Tag)this.overworldCooldown.save());
            nbt.m_128365_("mars_cooldown", (Tag)this.marsCooldown.save());
            nbt.m_128365_("jupiter_cooldown", (Tag)this.jupiterCooldown.save());
            return nbt;
        }

        @Override
        public void setData(CompoundTag nbt) {
            if (nbt.m_128441_("mars")) {
                this.beenToMars = nbt.m_128471_("mars");
            }
            if (nbt.m_128441_("space")) {
                this.beenToSpace = nbt.m_128471_("space");
            }
            if (nbt.m_128441_("venus")) {
                this.beenToVenus = nbt.m_128471_("venus");
            }
            if (nbt.m_128441_("mercury")) {
                this.beenToMercury = nbt.m_128471_("mercury");
            }
            if (nbt.m_128441_("jupiter")) {
                this.beenToJupiter = nbt.m_128471_("jupiter");
            }
            if (nbt.m_128441_("mars_cooldown")) {
                this.marsCooldown.load(nbt.m_128469_("mars_cooldown"));
            }
            if (nbt.m_128441_("overworld_cooldown")) {
                this.overworldCooldown.load(nbt.m_128469_("overworld_cooldown"));
            }
            if (nbt.m_128441_("venus_cooldown")) {
                this.venusCooldown.load(nbt.m_128469_("venus_cooldown"));
            }
            if (nbt.m_128441_("mercury_cooldown")) {
                this.mercuryCooldown.load(nbt.m_128469_("mercury_cooldown"));
            }
            if (nbt.m_128441_("jupiter_cooldown")) {
                this.jupiterCooldown.load(nbt.m_128469_("jupiter_cooldown"));
            }
        }
    }

    public static class PlanetCooldown {
        int currentCooldown = 0;
        int numTimesReset = 0;

        public void resetCooldown() {
            this.currentCooldown = (Integer)CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_MAX_COOLDOWN.get() - (Integer)CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_COOLDOWN_DECREMENT.get() * this.numTimesReset;
            if (this.currentCooldown < (Integer)CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_MIN_COOLDOWN.get()) {
                this.currentCooldown = (Integer)CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_MIN_COOLDOWN.get();
            }
            CelestialExploration.LOGGER.debug("maxCooldown: " + CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_MAX_COOLDOWN.get() + ", cooldownDecrement: " + CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_COOLDOWN_DECREMENT.get() + ", timesReset: " + this.numTimesReset + ", totalDecrement: " + (Integer)CelestialCommonConfig.SPACESHIP_LIGHT_TRAVEL_COOLDOWN_DECREMENT.get() * this.numTimesReset);
            ++this.numTimesReset;
        }

        public int getCurrentCooldown() {
            return this.currentCooldown;
        }

        public boolean isCooldownEnded() {
            return this.currentCooldown == 0;
        }

        public void decrementCooldown() {
            if (this.currentCooldown > 0) {
                --this.currentCooldown;
            }
        }

        public String getFormattedCooldown() {
            int minutes = this.currentCooldown / 20 / 60;
            int seconds = this.currentCooldown / 20 % 60;
            String cooldown = minutes + "m " + seconds + "s";
            return cooldown;
        }

        public void load(CompoundTag nbt) {
            if (nbt.m_128441_("cooldown")) {
                this.currentCooldown = nbt.m_128451_("cooldown");
            }
            if (nbt.m_128441_("timesReset")) {
                this.numTimesReset = nbt.m_128451_("timesReset");
            }
        }

        public CompoundTag save() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("cooldown", this.currentCooldown);
            nbt.m_128405_("timesReset", this.numTimesReset);
            return nbt;
        }
    }

    public static interface ILightTravel {
        public boolean hasBeenToSpace();

        public boolean hasBeenToMars();

        public boolean hasBeenToVenus();

        public boolean hasBeenToMercury();

        public boolean hasBeenToJupiter();

        public void setBeenToSpace();

        public void setBeenToMars();

        public void setBeenToVenus();

        public void setBeenToMercury();

        public void setBeenToJupiter();

        public PlanetCooldown getOverworldCooldown();

        public PlanetCooldown getMarsCooldown();

        public PlanetCooldown getVenusCooldown();

        public PlanetCooldown getMercuryCooldown();

        public PlanetCooldown getJupiterCooldown();

        public void sync(Player var1);

        public CompoundTag getData();

        public void setData(CompoundTag var1);
    }
}

