/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.capabilities;

import com.shim.celestialexploration.capabilities.ISpaceFlight;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.capabilities.VehicleFlightHandler;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpaceFlightCapabilityProvider
implements ICapabilityProvider,
ICapabilitySerializable<CompoundTag> {
    public static Capability<LoxTankCapability.LoxTankHandler> LOX_TANK = CapabilityManager.get((CapabilityToken)new CapabilityToken<LoxTankCapability.LoxTankHandler>(){});
    private final LazyOptional<ISpaceFlight> lazySpaceshipFlight = LazyOptional.of(VehicleFlightHandler::new);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return CelestialCapabilities.SPACE_FLIGHT_CAPABILITY.orEmpty(cap, this.lazySpaceshipFlight);
    }

    public CompoundTag serializeNBT() {
        return ((ISpaceFlight)this.lazySpaceshipFlight.orElseThrow(NullPointerException::new)).getData();
    }

    public void deserializeNBT(CompoundTag nbt) {
        ((ISpaceFlight)this.lazySpaceshipFlight.orElseThrow(NullPointerException::new)).setData(nbt);
    }
}

