/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestialexploration.world.renderer.DatapackSkyHandler;
import com.shim.celestialexploration.world.renderer.DimensionRenderers;
import com.shim.celestialexploration.world.renderer.StormWeatherHandler;
import com.shim.celestialexploration.world.renderer.StormWeatherParticleHandler;
import java.util.Map;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.client.IWeatherParticleRenderHandler;
import net.minecraftforge.client.IWeatherRenderHandler;

public class CelestialDimensionEffectsManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final ResourceLocation DEFAULT_MOON_TEXTURE = new ResourceLocation("minecraft", "textures/environment/moon_phases");
    private static final ResourceLocation DEFAULT_SUN_TEXTURE = new ResourceLocation("minecraft", "textures/environment/sun");
    private static final float DEFAULT_MOON_SIZE = 18.0f;
    private static final float DEFAULT_SUN_SIZE = 30.0f;

    public CelestialDimensionEffectsManager() {
        super(GSON, "celestialexploration/dimension_effects");
    }

    public ResourceLocation expandEnvironmentRL(String texture) {
        String[] resource = texture.split(":");
        String namespace = resource[0];
        String path = resource[1];
        return new ResourceLocation(namespace, "textures/environment/" + path + ".png");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        elements.forEach((dimensionPath, element) -> {
            IWeatherParticleRenderHandler particleHandler;
            IWeatherRenderHandler weatherHandler;
            String weather;
            JsonObject sky;
            JsonObject json = element.getAsJsonObject();
            ResourceLocation effectsLoc = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"effects"));
            DatapackSkyHandler skyHandler = null;
            if (json.has("sky") && !(sky = GsonHelper.m_13930_((JsonObject)json, (String)"sky")).isJsonNull()) {
                DatapackSkyHandler.CelestialObject moon4;
                DatapackSkyHandler.CelestialObject moon3;
                DatapackSkyHandler.CelestialObject moon2;
                DatapackSkyHandler.CelestialObject moon1;
                float size;
                ResourceLocation texture;
                JsonObject moon;
                DatapackSkyHandler.CelestialObject sun2;
                DatapackSkyHandler.CelestialObject sun1;
                String stars = GsonHelper.m_13851_((JsonObject)sky, (String)"stars", (String)"none");
                String milkyway = GsonHelper.m_13851_((JsonObject)sky, (String)"milkyway", (String)"none");
                if (sky.has("sun")) {
                    JsonObject sun = GsonHelper.m_13930_((JsonObject)sky, (String)"sun");
                    ResourceLocation texture2 = sun.has("texture") ? this.expandEnvironmentRL(GsonHelper.m_13906_((JsonObject)sun, (String)"texture")) : DEFAULT_SUN_TEXTURE;
                    float size2 = GsonHelper.m_13820_((JsonObject)sun, (String)"size", (float)30.0f);
                    sun1 = new DatapackSkyHandler.CelestialObject(texture2, size2);
                    ResourceLocation binaryStarTexture = sun.has("binary_star_texture") ? this.expandEnvironmentRL(GsonHelper.m_13906_((JsonObject)sun, (String)"binary_star_texture")) : null;
                    float binaryStarSize = GsonHelper.m_13820_((JsonObject)sun, (String)"binary_star_size", (float)30.0f);
                    sun2 = binaryStarTexture != null ? new DatapackSkyHandler.CelestialObject(binaryStarTexture, binaryStarSize) : null;
                } else {
                    sun1 = null;
                    sun2 = null;
                }
                String ringColor = GsonHelper.m_13851_((JsonObject)sky, (String)"ring_color", null);
                if (sky.has("moon_1")) {
                    moon = GsonHelper.m_13930_((JsonObject)sky, (String)"moon_1");
                    texture = moon.has("texture") ? this.expandEnvironmentRL(GsonHelper.m_13906_((JsonObject)moon, (String)"texture")) : DEFAULT_MOON_TEXTURE;
                    size = GsonHelper.m_13820_((JsonObject)moon, (String)"size", (float)18.0f);
                    moon1 = new DatapackSkyHandler.CelestialObject(texture, size);
                } else {
                    moon1 = null;
                }
                if (sky.has("moon_2")) {
                    moon = GsonHelper.m_13930_((JsonObject)sky, (String)"moon_2");
                    texture = moon.has("texture") ? this.expandEnvironmentRL(GsonHelper.m_13906_((JsonObject)moon, (String)"texture")) : DEFAULT_MOON_TEXTURE;
                    size = GsonHelper.m_13820_((JsonObject)moon, (String)"size", (float)18.0f);
                    moon2 = new DatapackSkyHandler.CelestialObject(texture, size);
                } else {
                    moon2 = null;
                }
                if (sky.has("moon_3")) {
                    moon = GsonHelper.m_13930_((JsonObject)sky, (String)"moon_3");
                    texture = moon.has("texture") ? this.expandEnvironmentRL(GsonHelper.m_13906_((JsonObject)moon, (String)"texture")) : DEFAULT_MOON_TEXTURE;
                    size = GsonHelper.m_13820_((JsonObject)moon, (String)"size", (float)18.0f);
                    moon3 = new DatapackSkyHandler.CelestialObject(texture, size);
                } else {
                    moon3 = null;
                }
                if (sky.has("moon_4")) {
                    moon = GsonHelper.m_13930_((JsonObject)sky, (String)"moon_4");
                    texture = moon.has("texture") ? this.expandEnvironmentRL(GsonHelper.m_13906_((JsonObject)moon, (String)"texture")) : DEFAULT_MOON_TEXTURE;
                    size = GsonHelper.m_13820_((JsonObject)moon, (String)"size", (float)18.0f);
                    moon4 = new DatapackSkyHandler.CelestialObject(texture, size);
                } else {
                    moon4 = null;
                }
                skyHandler = new DatapackSkyHandler(stars, milkyway, sun1, sun2, ringColor, moon1, moon2, moon3, moon4);
            }
            if ((weather = GsonHelper.m_13851_((JsonObject)json, (String)"weather", (String)"none")).equalsIgnoreCase("none")) {
                weatherHandler = null;
                particleHandler = null;
            } else if (weather.equalsIgnoreCase("dust_storms")) {
                weatherHandler = new StormWeatherHandler();
                particleHandler = new StormWeatherParticleHandler();
            } else {
                weatherHandler = (ticks, partialTick, level, minecraft, lightTexture, camX, camY, camZ) -> {};
                particleHandler = (ticks, level, minecraft, camera) -> {};
            }
            float cloudLevel = GsonHelper.m_13820_((JsonObject)json, (String)"cloud_level", (float)Float.NaN);
            boolean hasGround = GsonHelper.m_13855_((JsonObject)json, (String)"has_ground", (boolean)true);
            DimensionSpecialEffects.SkyType skyType = json.has("sky_type") ? DimensionSpecialEffects.SkyType.valueOf((String)GsonHelper.m_13906_((JsonObject)json, (String)"sky_type").toUpperCase()) : DimensionSpecialEffects.SkyType.NORMAL;
            boolean forceBrightLightmap = GsonHelper.m_13855_((JsonObject)json, (String)"force_bright_lightmap", (boolean)false);
            boolean constantAmbientLight = GsonHelper.m_13855_((JsonObject)json, (String)"constant_ambientLight", (boolean)false);
            boolean hasSunrise = GsonHelper.m_13855_((JsonObject)json, (String)"has_sunrise", (boolean)false);
            DimensionRenderers.DatapackSkyEffects effects = new DimensionRenderers.DatapackSkyEffects(cloudLevel, hasGround, skyType, forceBrightLightmap, constantAmbientLight, hasSunrise, skyHandler, weatherHandler, particleHandler);
            DimensionSpecialEffects.f_108857_.put((Object)effectsLoc, (Object)effects);
        });
    }
}

