/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.util.teleportation.CelestialCoordinateTeleport;
import com.shim.celestialexploration.util.teleportation.CelestialScaledTeleport;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;

public class CelestialDimensionManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public CelestialDimensionManager() {
        super(GSON, "celestialexploration/dimensions");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        CelestialUtil.clearDimensionLocations();
        elements.forEach((dimensionPath, element) -> {
            JsonObject json = element.getAsJsonObject();
            String dimName = GsonHelper.m_13906_((JsonObject)json, (String)"dimension");
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimName));
            if (json.has("space_chunk_coordinates")) {
                JsonObject coordinates = GsonHelper.m_13930_((JsonObject)json, (String)"space_chunk_coordinates");
                if (!coordinates.isJsonNull() && coordinates.has("x") && coordinates.has("z")) {
                    int x = GsonHelper.m_13927_((JsonObject)coordinates, (String)"x");
                    int z = GsonHelper.m_13927_((JsonObject)coordinates, (String)"z");
                    CelestialUtil.setDimensionLocation((ResourceKey<Level>)dimension, new CelestialCoordinateTeleport(x, z));
                }
            } else if (json.has("coordinate_scale")) {
                double scale = GsonHelper.m_144784_((JsonObject)json, (String)"coordinate_scale");
                if (scale <= 0.0) {
                    throw new IllegalStateException("Coordinate scale of " + dimension + " must be greater than 0!");
                }
                CelestialUtil.setDimensionLocation((ResourceKey<Level>)dimension, new CelestialScaledTeleport(scale));
            }
        });
    }
}

