/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.util.teleportation.TeleportUtil;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class CelestialPlanetManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public CelestialPlanetManager() {
        super(GSON, "celestialexploration/planets");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager p_10794_, ProfilerFiller p_10795_) {
        TeleportUtil.clearDimensionStructureBlocks();
        CelestialUtil.clearPlanetLocations();
        elements.forEach((dimensionPath, element) -> {
            JsonObject coordinates;
            JsonObject json = element.getAsJsonObject();
            String dimName = GsonHelper.m_13906_((JsonObject)json, (String)"target_dimension");
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(dimName));
            if (json.has("spawn_chunk_coordinates") && !(coordinates = GsonHelper.m_13930_((JsonObject)json, (String)"spawn_chunk_coordinates")).isJsonNull() && coordinates.has("x") && coordinates.has("z")) {
                int x = GsonHelper.m_13927_((JsonObject)coordinates, (String)"x");
                int z = GsonHelper.m_13927_((JsonObject)coordinates, (String)"z");
                CelestialUtil.setPlanetLocation((ResourceKey<Level>)dimension, new Vec3((double)x, 0.0, (double)z));
            }
            if (json.has("blocks")) {
                JsonArray blocks = GsonHelper.m_13933_((JsonObject)json, (String)"blocks");
                ArrayList<Block> blocksList = new ArrayList<Block>();
                for (int i = 0; i < blocks.size(); ++i) {
                    blocksList.add(i, Block.m_49814_((Item)GsonHelper.m_13874_((JsonElement)blocks.get(i), (String)"block")));
                }
                TeleportUtil.addDimensionStructureBlocks((ResourceKey<Level>)dimension, blocksList);
            }
        });
    }
}

