/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen;

import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.registry.CelestialEffects;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialFluids;
import com.shim.celestialexploration.registry.CelestialItems;
import com.shim.celestialexploration.world.biome.CelestialBiomeKeys;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class CelestialLangProvider
extends LanguageProvider {
    public CelestialLangProvider(DataGenerator gen, String locale) {
        super(gen, "celestialexploration", locale);
    }

    public void addBiome(ResourceKey<Biome> biome, String localization) {
        this.add("biome.celestialexploration." + biome.m_135782_().m_135815_(), localization);
    }

    public void addDimension(ResourceKey<Level> dimension, String localization) {
        this.add("dimension.celestialexploration." + dimension.m_135782_().m_135815_(), localization);
    }

    public void addAdvancement(String advancement, String title, String description) {
        this.add("advancements.celestial." + advancement + ".title", title);
        this.add("advancements.celestial." + advancement + ".description", description);
    }

    public void addFluid(Block fluidBlock, String fluid, String localization) {
        this.add(fluidBlock, localization);
        this.add("fluid.celestialexploration." + fluid, localization);
    }

    protected void addTranslations() {
        for (RegistryObject<? extends Block> registryObject : CelestialBlocks.BLOCK_LANG_EN_US.keySet()) {
            this.add((Block)registryObject.get(), CelestialBlocks.BLOCK_LANG_EN_US.get(registryObject));
        }
        for (RegistryObject<? extends Block> registryObject : CelestialItems.ITEM_LANG_EN_US.keySet()) {
            this.add((Item)registryObject.get(), CelestialItems.ITEM_LANG_EN_US.get(registryObject));
        }
        for (RegistryObject<? extends Block> registryObject : CelestialEntities.ENTITY_LANG_EN_US.keySet()) {
            this.add((EntityType)registryObject.get(), CelestialEntities.ENTITY_LANG_EN_US.get(registryObject));
        }
        this.add("entity.minecraft.villager.celestialexploration.astronomer", "Astronomer");
        this.add("entity.minecraft.villager.celestialexploration.engineer", "Engineer");
        this.add("celestialexploration.villager.unemployed", "Unemployed");
        this.addFluid((Block)CelestialFluids.LOX_BLOCK.get(), "lox", "Molten Iron");
        this.addFluid((Block)CelestialFluids.MOLTEN_IRON_BLOCK.get(), "molten_iron", "Molten Iron");
        this.addFluid((Block)CelestialFluids.MOLTEN_STEEL_BLOCK.get(), "molten_steel", "Molten Steel");
        this.addFluid((Block)CelestialFluids.MOLTEN_COPPER_BLOCK.get(), "copper", "Molten Copper");
        this.addFluid((Block)CelestialFluids.MOLTEN_GOLD_BLOCK.get(), "molten_gold", "Molten Gold");
        this.addFluid((Block)CelestialFluids.SULFUR_BLOCK.get(), "sulfur", "Sulfur");
        this.addFluid((Block)CelestialFluids.MOLTEN_ALUMINUM_BLOCK.get(), "molten_aluminum", "Molten Aluminum");
        this.addFluid((Block)CelestialFluids.METALLIC_HYDROGEN_BLOCK.get(), "metallic_hydrogen", "Liquid Metallic Hydrogen");
        this.add((Item)CelestialFluids.METALLIC_HYDROGEN_BUCKET.get(), "Liquid Metallic Hydrogen Bucket");
        this.add((Item)CelestialFluids.SULFUR_BUCKET.get(), "Sulfur Bucket");
        this.addBiome(CelestialBiomeKeys.SPACE, "Outer Space");
        this.addBiome(CelestialBiomeKeys.MOON_CRATERS, "Lunar Craters");
        this.addBiome(CelestialBiomeKeys.MOON_DESERT, "Lunar Desert");
        this.addBiome(CelestialBiomeKeys.MOON_LAVA_FLATS, "Lunar Lava Flats");
        this.addBiome(CelestialBiomeKeys.MOON_LOWER_PLAINS, "Lunar Lower Plains");
        this.addBiome(CelestialBiomeKeys.MOON_PLAINS, "Lunar Plains");
        this.addBiome(CelestialBiomeKeys.MARS_CRATERS, "Martian Craters");
        this.addBiome(CelestialBiomeKeys.MARS_DEEP_CRATERS, "Martian Deep Craters");
        this.addBiome(CelestialBiomeKeys.MARS_DESERT, "Martian Desert");
        this.addBiome(CelestialBiomeKeys.MARS_DUNES, "Martian Dunes");
        this.addBiome(CelestialBiomeKeys.MARS_DRY_ICE_FLATS, "Martian Dry Ice Flats");
        this.addBiome(CelestialBiomeKeys.MARS_DRY_ICE_PEAKS, "Martian Dry Ice Peaks");
        this.addBiome(CelestialBiomeKeys.MARS_ERODED_FLATS, "Martian Eroded Flats");
        this.addBiome(CelestialBiomeKeys.MARS_VOLCANO_FLATS, "Martian Volcano Flats");
        this.addBiome(CelestialBiomeKeys.MARS_FLATS, "Martian Flats");
        this.addBiome(CelestialBiomeKeys.VENUS_DESERT, "Venusian Desert");
        this.addBiome(CelestialBiomeKeys.VENUS_LOWER_PLAINS, "Venusian Lower Plains");
        this.addBiome(CelestialBiomeKeys.VENUS_PLAINS, "Venusian Plains");
        this.addBiome(CelestialBiomeKeys.VENUS_SULFUR_FLATS, "Venusian Sulfur Flats");
        this.addBiome(CelestialBiomeKeys.SULFUR_RIVER, "Sulfuric River");
        this.addBiome(CelestialBiomeKeys.SULFUR_OCEAN, "Sulfuric Ocean");
        this.addBiome(CelestialBiomeKeys.MERCURY_CRATERED_PLAINS, "Mercurian Cratered Plains");
        this.addBiome(CelestialBiomeKeys.MERCURY_DESERT, "Mercurian Desert");
        this.addBiome(CelestialBiomeKeys.MERCURY_DEEP_CRATERED_PLAINS, "Mercurian Deep Cratered Plains");
        this.addBiome(CelestialBiomeKeys.MERCURY_PLAINS, "Mercurian Plains");
        this.addBiome(CelestialBiomeKeys.MERCURY_RIDGES, "Mercurian Ridges");
        this.addBiome(CelestialBiomeKeys.JUPITER_ETHER, "Jovian Ether");
        this.addBiome(CelestialBiomeKeys.JUPITER_LESSER_STORM, "Jovian Lesser Storm");
        this.addBiome(CelestialBiomeKeys.JUPITER_GREAT_STORM, "Jovian Greater Storm");
        this.addBiome(CelestialBiomeKeys.EUROPA_RIVER, "Europan River");
        this.addBiome(CelestialBiomeKeys.EUROPA_DESERT, "Europan Desert");
        this.addBiome(CelestialBiomeKeys.EUROPA_JAGGED_PLAINS, "Europan Jagged Plains");
        this.addBiome(CelestialBiomeKeys.EUROPA_OCEAN, "Europan Ocean");
        this.addBiome(CelestialBiomeKeys.EUROPA_LOWER_PLAINS, "Europan Lower Plains");
        this.addBiome(CelestialBiomeKeys.EUROPA_PLAINS, "Europan Plains");
        this.addBiome(CelestialBiomeKeys.CALLISTO_CRATERED_PLAINS, "Callistoan Cratered Desert");
        this.addBiome(CelestialBiomeKeys.CALLISTO_DESERT, "Callistoan Desert");
        this.addBiome(CelestialBiomeKeys.CALLISTO_LOWER_PLAINS, "Callistoan Lower Plains");
        this.addBiome(CelestialBiomeKeys.CALLISTO_PLAINS, "Callistoan Plains");
        this.addBiome(CelestialBiomeKeys.GANYMEDE_CRATERED_PLAINS, "Ganymedian Craters");
        this.addBiome(CelestialBiomeKeys.GANYMEDE_DESERT, "Ganymedian Desert");
        this.addBiome(CelestialBiomeKeys.GANYMEDE_LOWER_PLAINS, "Ganymedian Lower Plains");
        this.addBiome(CelestialBiomeKeys.GANYMEDE_PLAINS, "Ganymedian Plains");
        this.addDimension(CelestialDimensions.SPACE, "Outer Space");
        this.addDimension(CelestialDimensions.MERCURY, "Mercury");
        this.addDimension(CelestialDimensions.VENUS, "Venus");
        this.addDimension((ResourceKey<Level>)Level.f_46428_, "Overworld");
        this.addDimension(CelestialDimensions.MOON, "Moon");
        this.addDimension(CelestialDimensions.MARS, "Mars");
        this.addDimension(CelestialDimensions.JUPITER, "Jupiter");
        this.addDimension(CelestialDimensions.EUROPA, "Europa");
        this.addDimension(CelestialDimensions.CALLISTO, "Callisto");
        this.addDimension(CelestialDimensions.GANYMEDE, "Ganymede");
        this.add("container.celestialexploration.oxygen_compressor", "Oxygen Compressor");
        this.add("container.celestialexploration.workbench", "Workbench");
        this.add((MobEffect)CelestialEffects.LOW_GRAVITY.get(), "Low Gravity");
        this.add((MobEffect)CelestialEffects.EXTRA_LOW_GRAVITY.get(), "Extra Low Gravity");
        this.add((MobEffect)CelestialEffects.HIGH_GRAVITY.get(), "High Gravity");
        this.add((MobEffect)CelestialEffects.STATIC_EFFECT.get(), "Static Build Up");
        this.add("itemGroup.celestial_blocks_tab", "Celestial Blocks");
        this.add("itemGroup.spaceship_tab", "Spaceship Items");
        this.add("itemGroup.celestial_misc_tab", "Celestial Items");
        this.add("key.categories.spaceship_controls", "Spaceship Controls");
        this.add("key.celestialexploration.flight_ascent", "Spaceship Ascent");
        this.add("key.celestialexploration.flight_descent", "Spaceship Descent");
        this.add("key.celestialexploration.turn_left", "Spaceship Strafe Left");
        this.add("key.celestialexploration.turn_right", "Spaceship Strafe Right");
        this.add("key.celestialexploration.open_spaceship_inventory", "Open Spaceship Inventory");
        this.add("key.celestialexploration.spaceship_light_travel", "Spaceship Light Speed Travel");
        this.add("death.attack.celestialexploration.touched_sun", "%1$s discovered the sun is hot");
        this.add("death.attack.celestialexploration.cold_floor", "%1$s got cold feet");
        this.add("death.attack.celestialexploration.sulfur", "%1$s tried to swim in sulfur");
        this.add("death.attack.celestialexploration.metallic_hydrogen", "%1$s drowned in death metal");
        this.add("death.attack.celestialexploration.dust_storm", "%1$s was sand blasted to death");
        this.addAdvancement("root", "Exploration", "Exploration of outer space");
        this.addAdvancement("fly_into_sun", "Icarus", "Fly into the sun");
        this.addAdvancement("plant_potato", "Best Botanist On This Planet", "Plant potatoes on Mars");
        this.addAdvancement("obtain_spacesuit", "Space Pajamas", "Acquire a spacesuit");
        this.addAdvancement("obtain_spaceship", "Rocketman", "Craft a spaceship");
        this.addAdvancement("place_airlock", "Breathing Room", "Place an airlock door");
        this.addAdvancement("kill_mob_in_space", "Space Invaders", "Defeat a mob in outer space");
        this.addAdvancement("all_mechadogs", "Gotta Catch 'Em All", "Collect all colors of the MechaDogs");
        this.addAdvancement("enter_space", "To Infinity\u2026 and Beyond!", "Enter space");
        this.addAdvancement("enter_moon", "One Small Step For Man\u2026", "Reach the moon");
        this.addAdvancement("enter_mars", "The Red Planet", "Reach Mars");
        this.addAdvancement("enter_venus", "Goddess of Beauty\u2026 And Sulfur?", "Reach Venus");
        this.addAdvancement("enter_mercury", "Runner Up Dwarf Planet", "Reach Mercury");
        this.addAdvancement("enter_jupiter", "The Giant Gas Giant", "Reach Jupiter");
        this.addAdvancement("enter_io", "Jupiter I", "Reach Io");
        this.addAdvancement("enter_europa", "Jupiter II", "Reach Europa");
        this.addAdvancement("enter_callisto", "Jupiter IV", "Reach Callisto");
        this.addAdvancement("enter_ganymede", "Jupiter III", "Reach Ganymede");
        this.add("celestialexploration.spaceship.travel.mercury", "Travel to Mercury");
        this.add("celestialexploration.spaceship.travel.venus", "Travel to Venus");
        this.add("celestialexploration.spaceship.travel.overworld", "Travel to the Overworld");
        this.add("celestialexploration.spaceship.travel.mars", "Travel to Mars");
        this.add("celestialexploration.spaceship.travel.jupiter", "Travel to Jupiter");
        this.add("celestialexploration.spaceship.travel.message_1", "Press ");
        this.add("celestialexploration.spaceship.travel.message_2", " for light speed travel");
        this.add("celestialexploration.spaceship.travel.cooldown", "Light speed travel cooldown: ");
        this.add("celestialexploration.spaceship.travel_unavailable", "Light speed travel unavailable at this location");
        this.add("celestialexploration.spaceship.tab.inventory", "Inventory");
        this.add("celestialexploration.spaceship.tab.light_travel", "Light Speed Travel");
        this.add("celestialexploration.spaceship.tab.light_travel_hint", "Access this feature when in space");
        this.add("celestialexploration.spaceship.space_min_height", "Warning! Approaching dangerous depths of space!");
        this.add("recipe.celestialexploration.workbench.smelting", "Workbench Smelting");
        this.add("recipe.celestialexploration.workbench.crafting", "Workbench Crafting");
        this.add("recipe.celestialexploration.workbench.blocks", "blocks");
        this.add("recipe.celestialexploration.workbench.ingots", "ingots");
        this.add("item.celestialexploration.armor_details.when_worn", "When Worn");
        this.add("item.celestialexploration.armor_details.when_set_complete", "When Complete Set Worn");
        this.add("item.celestialexploration.armor_details.heavy_duty_full_spacesuit", "Grants jump boost");
        this.add("item.celestialexploration.armor_details.heavy_duty_spacesuit_helmet", "Negates liquid metallic hydrogen damage");
        this.add("item.celestialexploration.armor_details.heavy_duty_spacesuit_chestplate", "Piglin neutral");
        this.add("item.celestialexploration.armor_details.heavy_duty_spacesuit_boots", "Negates high gravity");
        this.add("item.celestialexploration.armor_details.thermal_full_spacesuit", "Grants speed boost");
        this.add("item.celestialexploration.armor_details.thermal_spacesuit_boots_1", "Negates low gravity");
        this.add("item.celestialexploration.armor_details.thermal_spacesuit_boots_2", "Can walk on powdered snow");
        this.add("celestialexploration.planet_details.location", "Coordinates");
        this.add("celestialexploration.planet_details.moons", "Notable Moons");
        this.add("celestialexploration.planet_details.no_moons", "none");
        this.add("celestialexploration.planet_details.resources", "Notable Resources");
        this.add("celestialexploration.planet_details.sun_name", "The Sun");
        this.add("celestialexploration.planet_details.sun_resources", "none");
        this.add("celestialexploration.planet_details.mercury_name", "Mercury");
        this.add("celestialexploration.planet_details.mercury_resources", "meteors, coal, diamond");
        this.add("celestialexploration.planet_details.venus_name", "Venus");
        this.add("celestialexploration.planet_details.venus_resources", "sulfur, lapis lazuli");
        this.add("celestialexploration.planet_details.overworld_name", "Overworld");
        this.add("celestialexploration.planet_details.overworld_resources", "overworld/vanilla resources");
        this.add("celestialexploration.planet_details.overworld_moons", "Moon");
        this.add("celestialexploration.planet_details.mars_name", "Mars");
        this.add("celestialexploration.planet_details.mars_resources", "iron");
        this.add("celestialexploration.planet_details.jupiter_name", "Jupiter");
        this.add("celestialexploration.planet_details.jupiter_resources", "none");
        this.add("celestialexploration.planet_details.jupiter_moons", "Europa, Io, Callisto, Ganymede");
        this.add("celestialexploration.planet_details.saturn_name", "Saturn");
        this.add("celestialexploration.planet_details.saturn_resources", "TBD");
        this.add("celestialexploration.planet_details.saturn_moons", "TBD");
        this.add("celestialexploration.planet_details.uranus_name", "Uranus");
        this.add("celestialexploration.planet_details.uranus_resources", "TBD");
        this.add("celestialexploration.planet_details.uranus_moons", "TBD");
        this.add("celestialexploration.planet_details.neptune_name", "Neptune");
        this.add("celestialexploration.planet_details.neptune_resources", "TBD");
        this.add("celestialexploration.planet_details.neptune_moons", "TBD");
        this.add("item.celestialexploration.door.airlock_panel_door", "One hinge can support up to 7 wide (inclusive). Double hinge can support up to 14 wide (inclusive). No max height.");
        this.add("item.celestialexploration.door.hangar_door", "One hinge can support up to 32 wide (inclusive). Double hinge can support up to 64 wide (inclusive). No max height.");
        this.add("celestialexploration.display_board.edit", "Edit Display Board Message");
    }
}

