/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialItems;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.AlternativesEntry;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseLootTableProvider
extends LootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected static final EntityPredicate.Builder ENTITY_ON_FIRE = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
    protected ExistingFileHelper fileHelper;
    protected final Map<ResourceLocation, Pair<LootTable.Builder, LootContextParamSet>> lootTables = new HashMap<ResourceLocation, Pair<LootTable.Builder, LootContextParamSet>>();
    private final DataGenerator generator;

    public BaseLootTableProvider(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
        this.generator = dataGeneratorIn;
    }

    protected abstract void addTables();

    protected LootTable.Builder createSimpleTable(Block block) {
        LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_6509_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected static LootTable.Builder createSlabItemTable(Block block) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)SlabBlock.f_56353_, (Comparable)SlabType.DOUBLE)))).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())));
    }

    protected LootTable.Builder createIronOreTable(Block block) {
        return this.createOreTable(block, Items.f_151050_);
    }

    protected LootTable.Builder createRedstoneOreTable(Block block) {
        return this.createOreTable(block, Items.f_42451_);
    }

    protected LootTable.Builder createCopperOreTable(Block block) {
        return this.createOreTable(block, Items.f_151051_);
    }

    protected LootTable.Builder createBauxiteOreTable(Block block) {
        return this.createOreTable(block, (Item)CelestialItems.RAW_BAUXITE.get());
    }

    protected LootTable.Builder createSulfurOreTable(Block block) {
        return this.createOreTable(block, (Item)CelestialItems.SULFUR_CRYSTAL.get());
    }

    protected LootTable.Builder createCoalOreTable(Block block) {
        return this.createOreTable(block, Items.f_42413_);
    }

    protected LootTable.Builder createOreTable(Block block, Item item) {
        LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)item).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79915_((Enchantment)Enchantments.f_44987_)).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createEntitySingleDropTable(ItemLike lootItem, float min, float max, boolean killedByPlayerCondition) {
        LootPool.Builder builder = killedByPlayerCondition ? LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)lootItem).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)false)).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_6509_(LootItemKilledByPlayerCondition.m_81901_()) : LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)lootItem).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)false)).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootPool.Builder createEntitySingleDropPool(ItemLike lootItem, float min, float max, boolean killedByPlayerCondition) {
        LootPool.Builder builder = killedByPlayerCondition ? LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)lootItem).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)false)).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)))).m_6509_(LootItemKilledByPlayerCondition.m_81901_()) : LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)lootItem).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165414_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max), (boolean)false)).m_5577_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))));
        return builder;
    }

    protected LootTable.Builder createSilkTouchTable(Block block, ItemLike lootItem, float min, float max) {
        LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)lootItem).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)min, (float)max))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected LootTable.Builder createCeramicTable(Block block) {
        LootPool.Builder builder = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)AlternativesEntry.m_79395_((LootPoolEntryContainer.Builder[])new LootPoolEntryContainer.Builder[]{LootItem.m_79579_((ItemLike)block).m_6509_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))))), LootItem.m_79579_((ItemLike)((ItemLike)CelestialBlocks.SILICA.get())).m_5577_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_5577_((LootItemFunction.Builder)ApplyBonusCount.m_79921_((Enchantment)Enchantments.f_44987_, (int)1)).m_5577_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_())}));
        return LootTable.m_79147_().m_79161_(builder);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createTable(LootTable.Builder builderIn, LootContextParamSet paramSetIn) {
        return new Pair((Object)builderIn, (Object)paramSetIn);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createAdvancementReward(LootTable.Builder builderIn) {
        return new Pair((Object)builderIn, (Object)LootContextParamSets.f_81418_);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createBlockTable(LootTable.Builder builderIn) {
        return new Pair((Object)builderIn, (Object)LootContextParamSets.f_81421_);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createChestTable(LootTable.Builder builderIn) {
        return new Pair((Object)builderIn, (Object)LootContextParamSets.f_81411_);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createEntityTable(LootTable.Builder builderIn) {
        return new Pair((Object)builderIn, (Object)LootContextParamSets.f_81415_);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createSelectorTable(LootTable.Builder builderIn) {
        return new Pair((Object)builderIn, (Object)LootContextParamSets.f_81413_);
    }

    protected static Pair<LootTable.Builder, LootContextParamSet> createGenericTable(LootTable.Builder builderIn) {
        return new Pair((Object)builderIn, (Object)LootContextParamSets.f_81420_);
    }

    protected static LootPoolEntryContainer.Builder<?> lootTable(ResourceLocation poolLocationIn, int poolWeightIn) {
        return LootTableReference.m_79776_((ResourceLocation)poolLocationIn).m_79707_(poolWeightIn);
    }

    protected static LootPoolEntryContainer.Builder<?> lootTable(ResourceLocation poolLocationIn) {
        return LootTableReference.m_79776_((ResourceLocation)poolLocationIn);
    }

    protected static ResourceLocation getBlockLootTable(Block blockIn, String suffixIn) {
        return new ResourceLocation(blockIn.getRegistryName().m_135827_(), "blocks/" + blockIn.getRegistryName().m_135815_() + suffixIn);
    }

    protected static ResourceLocation getBlockLootTable(Block blockIn) {
        return BaseLootTableProvider.getBlockLootTable(blockIn, "");
    }

    protected static ResourceLocation getEntityLootTable(EntityType<?> entity) {
        return new ResourceLocation(entity.getRegistryName().m_135827_(), "entity/" + entity.getRegistryName().m_135815_());
    }

    protected void entity(EntityType<?> entity, LootTable.Builder builder) {
        this.lootTables.put(BaseLootTableProvider.getEntityLootTable(entity), BaseLootTableProvider.createEntityTable(builder));
    }

    protected void block(Block block, LootTable.Builder builder) {
        this.lootTables.put(BaseLootTableProvider.getBlockLootTable(block), BaseLootTableProvider.createBlockTable(builder));
    }

    protected void block(Block block, String suffix, LootTable.Builder builder) {
        this.lootTables.put(BaseLootTableProvider.getBlockLootTable(block, suffix), BaseLootTableProvider.createBlockTable(builder));
    }

    public void m_6865_(HashCache cacheIn) {
        this.addTables();
        HashMap tables = Maps.newHashMap();
        for (Map.Entry<ResourceLocation, Pair<LootTable.Builder, LootContextParamSet>> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey(), ((LootTable.Builder)entry.getValue().getFirst()).m_79165_((LootContextParamSet)entry.getValue().getSecond()).m_79167_());
        }
        this.writeTables(cacheIn, tables);
    }

    private void writeTables(HashCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.m_123916_();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                LOGGER.error("Couldn't write loot table {}", (Object)path, (Object)e);
            }
        });
    }

    public String m_6055_() {
        return "Celestial Exploration LootTables";
    }
}

