/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen.util;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestialexploration.datagen.util.DimensionTeleport;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class DimensionTeleportProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public DimensionTeleportProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        DimensionTeleportProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<DimensionTeleport> consumer = teleport -> {
            if (!set.add(teleport.getId())) {
                throw new IllegalStateException("Duplicate dimension " + teleport.getId());
            }
            Path path1 = DimensionTeleportProvider.createPath(path, teleport);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)teleport.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save dimension {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<DimensionTeleport> consumer, ExistingFileHelper fileHelper) {
    }

    public DimensionTeleport.SpaceCoordinates coord(int x, int z) {
        return new DimensionTeleport.SpaceCoordinates(x, z);
    }

    private static Path createPath(Path p_123971_, DimensionTeleport p_123972_) {
        return p_123971_.resolve("data/" + modid + "/" + modid + "/dimensions/" + p_123972_.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Dimension Teleporters";
    }
}

