/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PlanetTeleport {
    private final ResourceLocation id;
    private final ResourceKey<Level> dimension;
    private final SpaceCoordinates coordinates;
    private final List<Block> blocksList;

    public PlanetTeleport(ResourceLocation id, ResourceKey<Level> dimension, SpaceCoordinates coordinates, List<Block> blocksList) {
        this.id = id;
        this.dimension = dimension;
        this.coordinates = coordinates;
        this.blocksList = blocksList;
    }

    public Builder deconstruct() {
        return new Builder(this.dimension, this.coordinates, this.blocksList);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public record SpaceCoordinates(int x, int z) {
        public JsonElement serializeToJson() {
            JsonObject json = new JsonObject();
            json.addProperty("x", (Number)this.x());
            json.addProperty("z", (Number)this.z());
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            byteBuf.writeInt(this.x());
            byteBuf.writeInt(this.z());
        }
    }

    public static class Builder {
        ResourceKey<Level> dimension;
        SpaceCoordinates coordinates;
        List<Block> blocksList;

        public Builder(ResourceKey<Level> dimension, SpaceCoordinates coordinates, List<Block> blocksList) {
            this.dimension = dimension;
            this.coordinates = coordinates;
            this.blocksList = blocksList;
        }

        private Builder() {
            this.blocksList = new ArrayList<Block>();
        }

        public static Builder teleporter() {
            return new Builder();
        }

        public Builder dimension(ResourceKey<Level> dimension) {
            this.dimension = dimension;
            return this;
        }

        public Builder coordinates(SpaceCoordinates coord) {
            this.coordinates = coord;
            return this;
        }

        public Builder block(Block block) {
            this.blocksList.add(block);
            return this;
        }

        public boolean canBuild(Function<ResourceLocation, PlanetTeleport> p_138393_) {
            return this.dimension != null && this.coordinates != null && this.blocksList != null;
        }

        public PlanetTeleport build(ResourceLocation resourceLocation) {
            if (!this.canBuild(loc -> null)) {
                throw new IllegalStateException("Tried to build incomplete teleport!");
            }
            return new PlanetTeleport(resourceLocation, this.dimension, this.coordinates, this.blocksList);
        }

        public PlanetTeleport save(Consumer<PlanetTeleport> consumer, String name) {
            PlanetTeleport dimension = this.build(new ResourceLocation(name));
            consumer.accept(dimension);
            return dimension;
        }

        public JsonObject serializeToJson() {
            JsonObject json = new JsonObject();
            json.addProperty("target_dimension", this.dimension.m_135782_().toString());
            json.add("spawn_chunk_coordinates", this.coordinates.serializeToJson());
            JsonArray jsonArray = new JsonArray();
            for (Block block : this.blocksList) {
                jsonArray.add(block.getRegistryName().toString());
            }
            json.add("blocks", (JsonElement)jsonArray);
            return json;
        }

        public void serializeToNetwork(FriendlyByteBuf byteBuf) {
            if (this.dimension == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                byteBuf.m_130085_(this.dimension.getRegistryName());
            }
            if (this.coordinates == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                this.coordinates.serializeToNetwork(byteBuf);
            }
            if (this.blocksList == null) {
                byteBuf.writeBoolean(false);
            } else {
                byteBuf.writeBoolean(true);
                for (Block block : this.blocksList) {
                    byteBuf.m_130085_(block.getRegistryName());
                }
            }
        }
    }
}

