/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.datagen.util;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import com.shim.celestialexploration.datagen.util.PlanetTeleport;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.slf4j.Logger;

public class PlanetTeleportProvider
implements DataProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;
    protected ExistingFileHelper fileHelper;
    protected static String modid;

    public PlanetTeleportProvider(DataGenerator generatorIn, String modid, ExistingFileHelper fileHelperIn) {
        this.generator = generatorIn;
        PlanetTeleportProvider.modid = modid;
        this.fileHelper = fileHelperIn;
    }

    public void m_6865_(HashCache cache) {
        Path path = this.generator.m_123916_();
        HashSet set = Sets.newHashSet();
        Consumer<PlanetTeleport> consumer = teleport -> {
            if (!set.add(teleport.getId())) {
                throw new IllegalStateException("Duplicate planet " + teleport.getId());
            }
            Path path1 = PlanetTeleportProvider.createPath(path, teleport);
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)teleport.deconstruct().serializeToJson(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save planet {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer, this.fileHelper);
    }

    protected void register(Consumer<PlanetTeleport> consumer, ExistingFileHelper fileHelper) {
    }

    public PlanetTeleport.SpaceCoordinates coord(int x, int z) {
        return new PlanetTeleport.SpaceCoordinates(x, z);
    }

    private static Path createPath(Path p_123971_, PlanetTeleport p_123972_) {
        return p_123971_.resolve("data/" + modid + "/" + modid + "/planets/" + p_123972_.getId().m_135815_() + ".json");
    }

    public String m_6055_() {
        return "Planet Teleporters";
    }
}

