/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.client.model;

import com.shim.celestialexploration.entity.robots.AbstractCerberus;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;

public class CerberusPart
extends PartEntity<AbstractCerberus> {
    public final String name;
    private final EntityDimensions size;
    private float xOffset;
    private float yOffset;
    private float zOffset;
    public boolean hasCollider;

    public CerberusPart(AbstractCerberus parentIn, String nameIn, float sizeXIn, float sizeYIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, boolean hasCollider) {
        super((Entity)parentIn);
        this.name = nameIn;
        this.size = EntityDimensions.m_20395_((float)sizeXIn, (float)sizeYIn);
        this.xOffset = xOffsetIn;
        this.yOffset = yOffsetIn;
        this.zOffset = zOffsetIn;
        this.hasCollider = hasCollider;
        this.m_6210_();
    }

    public float getWidth() {
        return this.size.f_20377_;
    }

    public float getHeight() {
        return this.size.f_20378_;
    }

    public float getDefaultXOffset() {
        return this.xOffset;
    }

    public float getDefaultYOffset() {
        return this.yOffset;
    }

    public float getDefaultZOffset() {
        return this.zOffset;
    }

    public void updatePosition(double offsetXIn, double offsetYIn, double offsetZIn) {
        Vec3 lastPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
        AbstractCerberus parent = (AbstractCerberus)this.getParent();
        Vec3 newPos = CerberusPart.translateWithXRotation(parent.m_20182_(), parent.f_20884_, offsetXIn, offsetYIn, offsetZIn);
        this.m_6034_(newPos.f_82479_, newPos.f_82480_, newPos.f_82481_);
        this.f_19854_ = lastPos.f_82479_;
        this.f_19855_ = lastPos.f_82480_;
        this.f_19856_ = lastPos.f_82481_;
        this.f_19790_ = lastPos.f_82479_;
        this.f_19791_ = lastPos.f_82480_;
        this.f_19792_ = lastPos.f_82481_;
    }

    public boolean m_6087_() {
        return this.hasCollider;
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return this.size;
    }

    public static Vec3 translateWithXRotation(@Nonnull Vec3 baseIn, double rotationIn, double xOffsetIn, double yOffsetIn, double zOffsetIn) {
        double rotation = Math.toRadians(rotationIn);
        double offsetXRotated = xOffsetIn * -Math.sin(rotation) + zOffsetIn * Math.cos(rotation);
        double offsetZRotated = xOffsetIn * Math.cos(rotation) + zOffsetIn * Math.sin(rotation);
        return new Vec3(baseIn.f_82479_ + offsetXRotated, baseIn.f_82480_ + yOffsetIn, baseIn.f_82481_ + offsetZRotated);
    }

    public boolean m_6469_(DamageSource damageSourceIn, float damageIn) {
        return this.hasCollider && ((AbstractCerberus)this.getParent()).m_6469_(damageSourceIn, damageIn);
    }

    public InteractionResult m_6096_(Player playerIn, InteractionHand handIn) {
        return this.hasCollider ? ((AbstractCerberus)this.getParent()).m_6096_(playerIn, handIn) : InteractionResult.PASS;
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag tagIn) {
    }

    protected void m_7380_(CompoundTag tagIn) {
    }
}

