/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.friendlies;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Team;

public class TamableFlyingCreature
extends PathfinderMob
implements OwnableEntity {
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(TamableFlyingCreature.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Optional<UUID>> DATA_OWNERUUID_ID = SynchedEntityData.m_135353_(TamableFlyingCreature.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private boolean orderedToSit;

    protected TamableFlyingCreature(EntityType<? extends TamableFlyingCreature> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.reassessTameGoals();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_OWNERUUID_ID, Optional.empty());
    }

    public void m_7380_(CompoundTag p_21819_) {
        super.m_7380_(p_21819_);
        if (this.m_142504_() != null) {
            p_21819_.m_128362_("Owner", this.m_142504_());
        }
    }

    public void m_7378_(CompoundTag p_21815_) {
        UUID uuid;
        super.m_7378_(p_21815_);
        if (p_21815_.m_128403_("Owner")) {
            uuid = p_21815_.m_128342_("Owner");
        } else {
            String s = p_21815_.m_128461_("Owner");
            uuid = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s);
        }
        if (uuid != null) {
            try {
                this.setOwnerUUID(uuid);
                this.setTame(true);
            }
            catch (Throwable throwable) {
                this.setTame(false);
            }
        }
    }

    public boolean m_6573_(Player p_21813_) {
        return !this.m_21523_();
    }

    protected void spawnTamingParticles(boolean p_21835_) {
        SimpleParticleType particleoptions = ParticleTypes.f_123750_;
        if (!p_21835_) {
            particleoptions = ParticleTypes.f_123762_;
        }
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)particleoptions, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public void m_7822_(byte p_21807_) {
        if (p_21807_ == 7) {
            this.spawnTamingParticles(true);
        } else if (p_21807_ == 6) {
            this.spawnTamingParticles(false);
        } else {
            super.m_7822_(p_21807_);
        }
    }

    public boolean isTame() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 4) != 0;
    }

    public void setTame(boolean p_21836_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        if (p_21836_) {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 | 4)));
        } else {
            this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(b0 & 0xFFFFFFFB)));
        }
        this.reassessTameGoals();
    }

    protected void reassessTameGoals() {
    }

    @Nullable
    public UUID m_142504_() {
        return ((Optional)this.f_19804_.m_135370_(DATA_OWNERUUID_ID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID p_21817_) {
        this.f_19804_.m_135381_(DATA_OWNERUUID_ID, Optional.ofNullable(p_21817_));
    }

    public void tame(Player p_21829_) {
        this.setTame(true);
        this.setOwnerUUID(p_21829_.m_142081_());
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.m_142504_();
            return uuid == null ? null : this.f_19853_.m_46003_(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean m_6779_(LivingEntity p_21822_) {
        return !this.isOwnedBy(p_21822_) && super.m_6779_(p_21822_);
    }

    public boolean isOwnedBy(LivingEntity p_21831_) {
        return p_21831_ == this.getOwner();
    }

    public boolean wantsToAttack(LivingEntity p_21810_, LivingEntity p_21811_) {
        return true;
    }

    public Team m_5647_() {
        LivingEntity livingentity;
        if (this.isTame() && (livingentity = this.getOwner()) != null) {
            return livingentity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(Entity p_21833_) {
        if (this.isTame()) {
            LivingEntity livingentity = this.getOwner();
            if (p_21833_ == livingentity) {
                return true;
            }
            if (livingentity != null) {
                return livingentity.m_7307_(p_21833_);
            }
        }
        return super.m_7307_(p_21833_);
    }

    public void m_6667_(DamageSource p_21809_) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(p_21809_);
        if (this.f_20890_ && !this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_) && this.getOwner() instanceof ServerPlayer) {
            this.getOwner().m_6352_(deathMessage, Util.f_137441_);
        }
    }
}

