/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.mob;

import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.client.dispatchers.GustDispatcher;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Gust
extends Monster
implements PowerableMob {
    private static final EntityDataAccessor<Integer> DATA_SWELL_DIR = SynchedEntityData.m_135353_(Gust.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IS_POWERED = SynchedEntityData.m_135353_(Gust.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_IS_IGNITED = SynchedEntityData.m_135353_(Gust.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;
    private int maxSwell = 30;
    private int explosionRadius = 3;
    private int droppedSkulls;
    private int nextHeightOffsetChangeTick;
    private float allowedHeightOffset = 0.5f;
    public final GustDispatcher dispatcher = new GustDispatcher(this);
    private final MoveAnalysis moveAnalysis = new MoveAnalysis((Entity)this);

    public Gust(EntityType<? extends Gust> p_32278_, Level p_32279_) {
        super(p_32278_, p_32279_);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SwellGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Ocelot.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Cat.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.25);
    }

    public static boolean checkGustSpawnRules(EntityType<Gust> entity, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        if (((ServerLevel)levelAccessor).m_6018_().m_46471_()) {
            return Gust.m_21400_(entity, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
        }
        return random.nextInt(20) == 0 && Gust.m_33008_((ServerLevelAccessor)((ServerLevelAccessor)levelAccessor), (BlockPos)pos, (Random)random) && Gust.m_21400_(entity, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }

    public int m_6056_() {
        return this.m_5448_() == null ? 3 : 3 + (int)(this.m_21223_() - 1.0f);
    }

    public boolean m_142535_(float p_149687_, float p_149688_, DamageSource p_149689_) {
        return false;
    }

    protected void m_7840_(double p_20809_, boolean p_20810_, BlockState p_20811_, BlockPos p_20812_) {
    }

    public void m_8107_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        LivingEntity livingentity;
        --this.nextHeightOffsetChangeTick;
        if (this.nextHeightOffsetChangeTick <= 0) {
            this.nextHeightOffsetChangeTick = 100;
            this.allowedHeightOffset = 0.5f + (float)this.f_19796_.nextGaussian() * 3.0f;
        }
        if ((livingentity = this.m_5448_()) != null && livingentity.m_20188_() > this.m_20188_() + (double)this.allowedHeightOffset && this.m_6779_(livingentity)) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(this.m_20184_().m_82520_(0.0, ((double)0.3f - vec3.f_82480_) * (double)0.3f, 0.0));
            this.f_19812_ = true;
        }
        super.m_8024_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SWELL_DIR, (Object)-1);
        this.f_19804_.m_135372_(DATA_IS_POWERED, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_IGNITED, (Object)false);
    }

    public void m_7380_(CompoundTag p_32304_) {
        super.m_7380_(p_32304_);
        if (((Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED)).booleanValue()) {
            p_32304_.m_128379_("powered", true);
        }
        p_32304_.m_128376_("Fuse", (short)this.maxSwell);
        p_32304_.m_128344_("ExplosionRadius", (byte)this.explosionRadius);
        p_32304_.m_128379_("ignited", this.isIgnited());
    }

    public void m_7378_(CompoundTag p_32296_) {
        super.m_7378_(p_32296_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)p_32296_.m_128471_("powered"));
        if (p_32296_.m_128425_("Fuse", 99)) {
            this.maxSwell = p_32296_.m_128448_("Fuse");
        }
        if (p_32296_.m_128425_("ExplosionRadius", 99)) {
            this.explosionRadius = p_32296_.m_128445_("ExplosionRadius");
        }
        if (p_32296_.m_128471_("ignited")) {
            this.ignite();
        }
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            int i;
            if (this.f_19853_.m_5776_()) {
                if (this.swell > 0) {
                    this.dispatcher.explode();
                } else {
                    this.dispatcher.idle();
                }
            }
            this.oldSwell = this.swell;
            if (this.isIgnited()) {
                this.setSwellDir(1);
            }
            if ((i = this.getSwellDir()) > 0 && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell += i;
            if (this.swell < 0) {
                this.swell = 0;
            }
            if (this.swell >= this.maxSwell) {
                this.swell = this.maxSwell;
                this.explodeGust();
            }
        }
        super.m_8119_();
    }

    public void m_6710_(@Nullable LivingEntity p_149691_) {
        if (!(p_149691_ instanceof Goat)) {
            super.m_6710_(p_149691_);
        }
    }

    protected SoundEvent m_7975_(DamageSource p_32309_) {
        return SoundEvents.f_11836_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    public boolean m_7327_(Entity p_32281_) {
        return true;
    }

    public boolean m_7090_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_POWERED);
    }

    public float getSwelling(float p_32321_) {
        return Mth.m_14179_((float)p_32321_, (float)this.oldSwell, (float)this.swell) / (float)(this.maxSwell - 2);
    }

    public int getSwellDir() {
        return (Integer)this.f_19804_.m_135370_(DATA_SWELL_DIR);
    }

    public void setSwellDir(int p_32284_) {
        this.f_19804_.m_135381_(DATA_SWELL_DIR, (Object)p_32284_);
    }

    public void m_8038_(ServerLevel p_32286_, LightningBolt p_32287_) {
        super.m_8038_(p_32286_, p_32287_);
        this.f_19804_.m_135381_(DATA_IS_POWERED, (Object)true);
    }

    protected InteractionResult m_6071_(Player p_32301_, InteractionHand p_32302_) {
        ItemStack itemstack = p_32301_.m_21120_(p_32302_);
        if (itemstack.m_150930_(Items.f_42409_)) {
            this.f_19853_.m_6263_(p_32301_, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11942_, this.m_5720_(), 1.0f, this.f_19796_.nextFloat() * 0.4f + 0.8f);
            if (!this.f_19853_.f_46443_) {
                this.ignite();
                itemstack.m_41622_(1, (LivingEntity)p_32301_, p_32290_ -> p_32290_.m_21190_(p_32302_));
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_32301_, p_32302_);
    }

    private void explodeGust() {
        if (!this.f_19853_.f_46443_) {
            Explosion.BlockInteraction explosion$blockinteraction = Explosion.BlockInteraction.DESTROY;
            if (!ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this)) {
                explosion$blockinteraction = Explosion.BlockInteraction.NONE;
            }
            if (!((Boolean)CelestialCommonConfig.GUST_GRIEFING.get()).booleanValue()) {
                explosion$blockinteraction = Explosion.BlockInteraction.NONE;
            }
            float f = this.m_7090_() ? 2.0f : 1.0f;
            this.f_20890_ = true;
            this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionRadius * f, explosion$blockinteraction);
            this.m_146870_();
            this.spawnLingeringCloud();
        }
    }

    public Explosion explode(@Nullable Entity p_46512_, double p_46513_, double p_46514_, double p_46515_, float p_46516_, Explosion.BlockInteraction p_46517_) {
        return this.explode(p_46512_, null, null, p_46513_, p_46514_, p_46515_, p_46516_, false, p_46517_);
    }

    public Explosion explode(@Nullable Entity p_46519_, double p_46520_, double p_46521_, double p_46522_, float p_46523_, boolean p_46524_, Explosion.BlockInteraction p_46525_) {
        return this.explode(p_46519_, null, null, p_46520_, p_46521_, p_46522_, p_46523_, p_46524_, p_46525_);
    }

    public Explosion explode(@Nullable Entity p_46526_, @Nullable DamageSource p_46527_, @Nullable ExplosionDamageCalculator p_46528_, double p_46529_, double p_46530_, double p_46531_, float p_46532_, boolean p_46533_, Explosion.BlockInteraction p_46534_) {
        Explosion explosion = new Explosion(this.f_19853_, p_46526_, p_46527_, p_46528_, p_46529_, p_46530_, p_46531_, p_46532_, p_46533_, p_46534_);
        if (ForgeEventFactory.onExplosionStart((Level)this.f_19853_, (Explosion)explosion)) {
            return explosion;
        }
        explosion.m_46061_();
        explosion.m_46075_(true);
        return explosion;
    }

    private void spawnLingeringCloud() {
        Collection collection = this.m_21220_();
        if (!collection.isEmpty()) {
            AreaEffectCloud areaeffectcloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
            areaeffectcloud.m_19712_(2.5f);
            areaeffectcloud.m_19732_(-0.5f);
            areaeffectcloud.m_19740_(10);
            areaeffectcloud.m_19734_(areaeffectcloud.m_19748_() / 2);
            areaeffectcloud.m_19738_(-areaeffectcloud.m_19743_() / (float)areaeffectcloud.m_19748_());
            for (MobEffectInstance mobeffectinstance : collection) {
                areaeffectcloud.m_19716_(new MobEffectInstance(mobeffectinstance));
            }
            this.f_19853_.m_7967_((Entity)areaeffectcloud);
        }
    }

    public boolean isIgnited() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_IGNITED);
    }

    public void ignite() {
        this.f_19804_.m_135381_(DATA_IS_IGNITED, (Object)true);
    }

    public boolean canDropMobsSkull() {
        return this.m_7090_() && this.droppedSkulls < 1;
    }

    public void increaseDroppedSkulls() {
        ++this.droppedSkulls;
    }

    public class SwellGoal
    extends Goal {
        private final Gust gust;
        @Nullable
        private LivingEntity target;

        public SwellGoal(Gust p_25919_) {
            this.gust = p_25919_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.gust.m_5448_();
            return this.gust.getSwellDir() > 0 || livingentity != null && this.gust.m_20280_((Entity)livingentity) < 9.0;
        }

        public void m_8056_() {
            this.gust.m_21573_().m_26573_();
            this.target = this.gust.m_5448_();
        }

        public void m_8041_() {
            this.target = null;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            if (this.target == null) {
                this.gust.setSwellDir(-1);
            } else if (this.gust.m_20280_((Entity)this.target) > 49.0) {
                this.gust.setSwellDir(-1);
            } else if (!this.gust.m_21574_().m_148306_((Entity)this.target)) {
                this.gust.setSwellDir(-1);
            } else {
                this.gust.setSwellDir(1);
            }
        }
    }
}

