/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.entity.vehicle;

import com.shim.celestialexploration.entity.vehicle.AbstractMagCart;
import com.shim.celestialexploration.entity.vehicle.AbstractMagCartContainer;
import com.shim.celestialexploration.registry.CelestialEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MagCartHopper
extends AbstractMagCartContainer
implements Hopper {
    public static final int MOVE_ITEM_SPEED = 4;
    private boolean enabled = true;
    private int cooldownTime = -1;
    private final BlockPos lastPosition = BlockPos.f_121853_;

    public MagCartHopper(EntityType<? extends MagCartHopper> p_38584_, Level p_38585_) {
        super(p_38584_, p_38585_);
    }

    public MagCartHopper(Level p_38587_, double p_38588_, double p_38589_, double p_38590_) {
        super((EntityType)CelestialEntities.HOPPER_MAGCART.get(), p_38588_, p_38589_, p_38590_, p_38587_);
    }

    @Override
    public AbstractMagCart.Type getMagCartType() {
        return AbstractMagCart.Type.HOPPER;
    }

    @Override
    public BlockState getDefaultDisplayBlockState() {
        return Blocks.f_50332_.m_49966_();
    }

    @Override
    public int getDefaultDisplayOffset() {
        return 1;
    }

    public int m_6643_() {
        return 5;
    }

    @Override
    public void activateMagCart(int p_38596_, int p_38597_, int p_38598_, boolean p_38599_) {
        boolean flag;
        boolean bl = flag = !p_38599_;
        if (flag != this.isEnabled()) {
            this.setEnabled(flag);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean p_38614_) {
        this.enabled = p_38614_;
    }

    public double m_6343_() {
        return this.m_20185_();
    }

    public double m_6358_() {
        return this.m_20186_() + 0.5;
    }

    public double m_6446_() {
        return this.m_20189_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.isEnabled()) {
            BlockPos blockpos = this.m_142538_();
            if (blockpos.equals((Object)this.lastPosition)) {
                --this.cooldownTime;
            } else {
                this.setCooldown(0);
            }
            if (!this.isOnCooldown()) {
                this.setCooldown(0);
                if (this.suckInItems()) {
                    this.setCooldown(4);
                    this.m_6596_();
                }
            }
        }
    }

    public boolean suckInItems() {
        if (HopperBlockEntity.m_155552_((Level)this.f_19853_, (Hopper)this)) {
            return true;
        }
        List list = this.f_19853_.m_6443_(ItemEntity.class, this.m_142469_().m_82377_(0.25, 0.0, 0.25), EntitySelector.f_20402_);
        if (!list.isEmpty()) {
            HopperBlockEntity.m_59331_((Container)this, (ItemEntity)((ItemEntity)list.get(0)));
        }
        return false;
    }

    @Override
    public void destroy(DamageSource p_38604_) {
        super.destroy(p_38604_);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19998_((ItemLike)Blocks.f_50332_);
        }
    }

    @Override
    protected void m_7380_(CompoundTag p_38608_) {
        super.m_7380_(p_38608_);
        p_38608_.m_128405_("TransferCooldown", this.cooldownTime);
        p_38608_.m_128379_("Enabled", this.enabled);
    }

    @Override
    protected void m_7378_(CompoundTag p_38606_) {
        super.m_7378_(p_38606_);
        this.cooldownTime = p_38606_.m_128451_("TransferCooldown");
        this.enabled = !p_38606_.m_128441_("Enabled") || p_38606_.m_128471_("Enabled");
    }

    public void setCooldown(int p_38611_) {
        this.cooldownTime = p_38611_;
    }

    public boolean isOnCooldown() {
        return this.cooldownTime > 0;
    }

    @Override
    public AbstractContainerMenu createMenu(int p_38601_, Inventory p_38602_) {
        return new HopperMenu(p_38601_, p_38602_, (Container)this);
    }
}

