/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.events;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.CelestialSkullRenderer;
import com.shim.celestialexploration.capabilities.LoxTankCapability;
import com.shim.celestialexploration.entity.client.layers.VillagerSpaceSuitLayer;
import com.shim.celestialexploration.entity.client.renderer.AstralHoglinRenderer;
import com.shim.celestialexploration.entity.client.renderer.AstralPiglinRenderer;
import com.shim.celestialexploration.entity.client.renderer.CelestialCatRenderer;
import com.shim.celestialexploration.entity.client.renderer.CobblesaurusRenderer;
import com.shim.celestialexploration.entity.client.renderer.CyborgPiglinRenderer;
import com.shim.celestialexploration.entity.client.renderer.DroneRenderer;
import com.shim.celestialexploration.entity.client.renderer.EurekaRenderer;
import com.shim.celestialexploration.entity.client.renderer.FlareRenderer;
import com.shim.celestialexploration.entity.client.renderer.GustRenderer;
import com.shim.celestialexploration.entity.client.renderer.GystRenderer;
import com.shim.celestialexploration.entity.client.renderer.LunarSlimeRenderer;
import com.shim.celestialexploration.entity.client.renderer.LurkerRenderer;
import com.shim.celestialexploration.entity.client.renderer.MagCartRenderer;
import com.shim.celestialexploration.entity.client.renderer.MarsMallowRenderer;
import com.shim.celestialexploration.entity.client.renderer.MechaCerberusRenderer;
import com.shim.celestialexploration.entity.client.renderer.MechaDogRenderer;
import com.shim.celestialexploration.entity.client.renderer.MeteorCrawlerRenderer;
import com.shim.celestialexploration.entity.client.renderer.OrbiterRenderer;
import com.shim.celestialexploration.entity.client.renderer.QuicksilverSlimeRenderer;
import com.shim.celestialexploration.entity.client.renderer.RoverRenderer;
import com.shim.celestialexploration.entity.client.renderer.RustSlimeRenderer;
import com.shim.celestialexploration.entity.client.renderer.SpaceTaxiRenderer;
import com.shim.celestialexploration.entity.client.renderer.SpaceshipRenderer;
import com.shim.celestialexploration.entity.client.renderer.SulfurCubeRenderer;
import com.shim.celestialexploration.entity.client.renderer.ViscousSlimeRenderer;
import com.shim.celestialexploration.entity.client.renderer.VoidCrawlerRenderer;
import com.shim.celestialexploration.entity.client.renderer.VoidFellowRenderer;
import com.shim.celestialexploration.entity.client.renderer.VoidedPiglinRenderer;
import com.shim.celestialexploration.entity.client.renderer.VoidedRenderer;
import com.shim.celestialexploration.entity.client.renderer.VoidedZoglinRenderer;
import com.shim.celestialexploration.entity.client.renderer.projectile.MeteorRenderer;
import com.shim.celestialexploration.inventory.screens.OxygenCompressorScreen;
import com.shim.celestialexploration.inventory.screens.PlanetChartScreen;
import com.shim.celestialexploration.inventory.screens.SpaceTaxiScreen;
import com.shim.celestialexploration.inventory.screens.SpaceshipScreen;
import com.shim.celestialexploration.inventory.screens.TaxiStationScreen;
import com.shim.celestialexploration.inventory.screens.WorkbenchScreen;
import com.shim.celestialexploration.item.armor.SpacesuitRenderer;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialFluids;
import com.shim.celestialexploration.registry.CelestialItems;
import com.shim.celestialexploration.registry.CelestialMenus;
import com.shim.celestialexploration.registry.CelestialModelLayers;
import com.shim.celestialexploration.registry.CelestialOverlays;
import com.shim.celestialexploration.util.Keybinds;
import com.shim.celestialexploration.world.renderer.DimensionRenderers;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererRegistry;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="celestialexploration", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class CelestialClientEventBus {
    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.AddLayers event) {
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        VillagerRenderer renderer = (VillagerRenderer)event.getRenderer(EntityType.f_20492_);
        if (renderer != null) {
            renderer.m_115326_(new VillagerSpaceSuitLayer(renderer));
        }
    }

    @SubscribeEvent
    public static void registerSkulls(EntityRenderersEvent.CreateSkullModels event) {
        event.registerSkullModel((SkullBlock.Type)CelestialSkullRenderer.Types.LURKER, (SkullModelBase)new SkullModel(event.getEntityModelSet().m_171103_(CelestialModelLayers.LURKER_HEAD)));
        event.registerSkullModel((SkullBlock.Type)CelestialSkullRenderer.Types.VOIDED, (SkullModelBase)new SkullModel(event.getEntityModelSet().m_171103_(CelestialModelLayers.VOIDED_HEAD)));
        event.registerSkullModel((SkullBlock.Type)CelestialSkullRenderer.Types.MECHADOG, (SkullModelBase)new SkullModel(event.getEntityModelSet().m_171103_(CelestialModelLayers.MECHADOG_HEAD)));
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        Keybinds.register(event);
        event.enqueueWork(DimensionRenderers::setDimensionEffects);
        event.enqueueWork(CelestialSkullRenderer::setSkullRenderers);
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)CelestialItems.LOX_TANK.get()), (ResourceLocation)new ResourceLocation("filled"), (stack, level, living, id) -> {
            LoxTankCapability.ILoxTank loxTank = CelestialExploration.getCapability(stack, CelestialCapabilities.LOX_TANK_CAPABILITY);
            if (loxTank != null) {
                return (float)loxTank.getFullness() / 8.0f;
            }
            return 0.0f;
        }));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.MARS_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.MOON_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.VENUS_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.MERCURY_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.JUPITER_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.EUROPA_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.CALLISTO_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.IO_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.GANYMEDE_PORTAL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_BLUE_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_WHITE_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_CYAN_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_MAGENTA_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_YELLOW_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_RED_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_YELLOW_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_MAGENTA_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_CYAN_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_BLUE_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_WHITE_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LUMINOUS_RED_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.REINFORCED_GLASS.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.REINFORCED_GLASS_PANE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.AIRLOCK_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.STEEL_DOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.STEEL_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.AIRLOCK_PANEL_DOOR_WINDOW.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.HANGAR_DOOR_WINDOW.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.JUPITER_ATMOSPHERE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.SATURN_ATMOSPHERE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.URANUS_ATMOSPHERE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.NEPTUNE_ATMOSPHERE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.LOX.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.LOX_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialFluids.LOX_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_IRON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_IRON_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialFluids.MOLTEN_IRON_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_STEEL.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_STEEL_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialFluids.MOLTEN_STEEL_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_COPPER.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_COPPER_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialFluids.MOLTEN_COPPER_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_GOLD.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)CelestialFluids.MOLTEN_GOLD_FLOWING.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialFluids.MOLTEN_GOLD_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.SOLAR_FLARE.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.RED_BUTTON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.YELLOW_BUTTON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.BLUE_BUTTON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.GREEN_BUTTON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.WHITE_BUTTON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.BLACK_BUTTON.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.LOX_TANK.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.STEEL_FRAME.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.STEEL_LADDER.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.MAG_RAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.POWERED_MAG_RAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.DETECTOR_MAG_RAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.ACTIVATOR_MAG_RAIL.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)CelestialBlocks.PENITENTE.get()), (RenderType)RenderType.m_110463_());
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.RUST_SLIME.get()), RustSlimeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.LUNAR_SLIME.get()), LunarSlimeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.QUICKSILVER_SLIME.get()), QuicksilverSlimeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.VISCOUS_SLIME.get()), ViscousSlimeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.MARS_MALLOW.get()), MarsMallowRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.LURKER.get()), LurkerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.SPACESHIP.get()), SpaceshipRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.SPACE_TAXI.get()), SpaceTaxiRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.VOIDFELLOW.get()), VoidFellowRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.CHEST_MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.CHEST_MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.COMMAND_BLOCK_MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.COMMAND_BLOCK_MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.FURNACE_MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.FURNACE_MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.HOPPER_MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.HOPPER_MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.SPAWNER_MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.SPAWNER_MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.TNT_MAGCART.get()), context -> new MagCartRenderer(context, CelestialModelLayers.TNT_MAGCART));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.VOIDED.get()), VoidedRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.SULFUR_CUBE.get()), SulfurCubeRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.VOIDED_PIGLIN.get()), VoidedPiglinRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.FLARE.get()), FlareRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.GYST.get()), GystRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.ASTRAL_PIGLIN.get()), AstralPiglinRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.CYBORG_PIGLIN.get()), CyborgPiglinRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.ASTRAL_HOGLIN.get()), AstralHoglinRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.VOIDED_ZOGLIN.get()), VoidedZoglinRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.METEOR_CRAWLER.get()), MeteorCrawlerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.VOID_CRAWLER.get()), VoidCrawlerRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.CELESTIAL_CAT.get()), CelestialCatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.EUREKA.get()), EurekaRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.METEOR.get()), MeteorRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.GUST.get()), GustRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.DRONE.get()), DroneRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.ROVER.get()), RoverRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.MECHADOG.get()), MechaDogRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.COBBLESAURUS.get()), CobblesaurusRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.ORBITER.get()), OrbiterRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.MECHACERBERUS.get()), context -> new MechaCerberusRenderer(context, 1.5f));
        EntityRenderers.m_174036_((EntityType)((EntityType)CelestialEntities.MECHACERBERUS_BOSS.get()), context -> new MechaCerberusRenderer(context, 2.5f));
        MenuScreens.m_96206_((MenuType)((MenuType)CelestialMenus.OXYGEN_COMPRESSOR_MENU.get()), OxygenCompressorScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CelestialMenus.PLANET_CHART_MENU.get()), PlanetChartScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CelestialMenus.SPACESHIP_MENU.get()), SpaceshipScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CelestialMenus.WORKBENCH_MENU.get()), WorkbenchScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CelestialMenus.SPACE_TAXI_MENU.get()), SpaceTaxiScreen::new);
        MenuScreens.m_96206_((MenuType)((MenuType)CelestialMenus.TAXI_STATION_MENU.get()), TaxiStationScreen::new);
        CelestialOverlays.registerOverlay(event);
        AzArmorRendererRegistry.register(() -> new SpacesuitRenderer("advanced_spacesuit"), (Item)((Item)CelestialItems.ADVANCED_SPACESUIT_HELMET.get()), (Item[])new Item[]{(Item)CelestialItems.ADVANCED_SPACESUIT_CHESTPLATE.get(), (Item)CelestialItems.ADVANCED_SPACESUIT_LEGGINGS.get(), (Item)CelestialItems.ADVANCED_SPACESUIT_BOOTS.get()});
        AzArmorRendererRegistry.register(() -> new SpacesuitRenderer("heavy_duty_spacesuit"), (Item)((Item)CelestialItems.HEAVY_DUTY_SPACESUIT_HELMET.get()), (Item[])new Item[]{(Item)CelestialItems.HEAVY_DUTY_SPACESUIT_CHESTPLATE.get(), (Item)CelestialItems.HEAVY_DUTY_SPACESUIT_LEGGINGS.get(), (Item)CelestialItems.HEAVY_DUTY_SPACESUIT_BOOTS.get()});
        AzArmorRendererRegistry.register(() -> new SpacesuitRenderer("thermal_spacesuit"), (Item)((Item)CelestialItems.THERMAL_SPACESUIT_HELMET.get()), (Item[])new Item[]{(Item)CelestialItems.THERMAL_SPACESUIT_CHESTPLATE.get(), (Item)CelestialItems.THERMAL_SPACESUIT_LEGGINGS.get(), (Item)CelestialItems.THERMAL_SPACESUIT_BOOTS.get()});
        AzArmorRendererRegistry.register(() -> new SpacesuitRenderer("basic_spacesuit"), (Item)((Item)CelestialItems.BASIC_SPACESUIT_HELMET.get()), (Item[])new Item[]{(Item)CelestialItems.BASIC_SPACESUIT_CHESTPLATE.get(), (Item)CelestialItems.BASIC_SPACESUIT_LEGGINGS.get(), (Item)CelestialItems.BASIC_SPACESUIT_BOOTS.get()});
        RecipeBookCategories.create((String)"celestialexploration:workbench_crafting", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CelestialBlocks.WORKBENCH.get())});
        RecipeBookCategories.create((String)"celestialexploration:workbench_smelting", (ItemStack[])new ItemStack[]{new ItemStack((ItemLike)CelestialBlocks.WORKBENCH.get())});
    }

    @SubscribeEvent
    public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
    }
}

