/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.events;

import com.mojang.datafixers.util.Either;
import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.blocks.AbstractPortalBlock;
import com.shim.celestialexploration.blocks.AirlockDoorBlock;
import com.shim.celestialexploration.blocks.HangarDoorBlock;
import com.shim.celestialexploration.capabilities.ISpaceFlight;
import com.shim.celestialexploration.capabilities.LightTravelCapability;
import com.shim.celestialexploration.capabilities.TaxiCapability;
import com.shim.celestialexploration.config.CelestialCommonConfig;
import com.shim.celestialexploration.entity.CelestialCatSpawner;
import com.shim.celestialexploration.entity.projectile.MeteorProjectile;
import com.shim.celestialexploration.entity.vehicle.Spaceship;
import com.shim.celestialexploration.item.armor.ThermalSpacesuitArmorItem;
import com.shim.celestialexploration.packets.CelestialPacketHandler;
import com.shim.celestialexploration.packets.SpaceFlightPacket;
import com.shim.celestialexploration.registry.CelestialBlocks;
import com.shim.celestialexploration.registry.CelestialCapabilities;
import com.shim.celestialexploration.registry.CelestialDamageSource;
import com.shim.celestialexploration.registry.CelestialDimensions;
import com.shim.celestialexploration.registry.CelestialEffects;
import com.shim.celestialexploration.registry.CelestialEntities;
import com.shim.celestialexploration.registry.CelestialTags;
import com.shim.celestialexploration.util.CelestialUtil;
import com.shim.celestialexploration.util.DimensionUtil;
import com.shim.celestialexploration.util.teleportation.TeleportUtil;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="celestialexploration", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CelestialForgeEventBus {
    @SubscribeEvent
    public static void onEntityMount(EntityMountEvent event) {
        Spaceship spaceship;
        Entity entity;
        if (event.isDismounting() && (entity = event.getEntityBeingMounted()) instanceof Spaceship && !(spaceship = (Spaceship)entity).m_146910_() && !event.getWorldObj().f_46443_) {
            event.setCanceled(spaceship.getTimeOnGround() < Spaceship.maxTimeOnGround);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.WorldTickEvent event) {
        Level level = event.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.haveTime()) {
                MeteorProjectile meteor;
                Random random;
                ServerPlayer player;
                new CelestialCatSpawner().m_7995_(serverLevel, true, true);
                if (serverLevel.m_46470_() && (player = serverLevel.m_8890_()) != null && serverLevel.m_204166_(player.m_142538_()).m_203656_(CelestialTags.Biomes.METEOR_SHOWER_BIOMES) && (random = new Random()).nextInt(3) == 0 && (meteor = (MeteorProjectile)((EntityType)CelestialEntities.METEOR.get()).m_20615_((Level)serverLevel)) != null) {
                    double height = Math.min(player.m_20182_().f_82480_ + (double)random.nextInt(128) - 16.0, (double)serverLevel.m_151558_());
                    meteor.m_6027_(player.m_20182_().f_82479_ + (double)random.nextInt(128) - 64.0, height, player.m_20182_().f_82481_ - (double)random.nextInt(64));
                    serverLevel.m_7967_((Entity)meteor);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        LightTravelCapability.ILightTravel travelCap;
        Player player = event.player;
        Player spaceVehicle = null;
        if (player.f_19853_.m_46472_().equals(CelestialDimensions.SPACE) && player.m_20182_().f_82480_ <= (double)player.f_19853_.m_141937_()) {
            player.m_5661_((Component)new TranslatableComponent("celestialexploration.spaceship.space_min_height"), true);
        }
        if (!player.f_19853_.m_5776_()) {
            ISpaceFlight flightCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.SPACE_FLIGHT_CAPABILITY);
            if (flightCap != null) {
                spaceVehicle = player;
            } else if (player.m_20202_() != null && (flightCap = CelestialExploration.getCapability(player.m_20202_(), CelestialCapabilities.SPACE_FLIGHT_CAPABILITY)) != null) {
                spaceVehicle = player.m_20202_();
            }
            if (spaceVehicle != null) {
                if (flightCap.canSpaceTravel((Entity)spaceVehicle) && flightCap.isTeleportHeight((Entity)spaceVehicle) && !spaceVehicle.f_19853_.m_46472_().equals(CelestialDimensions.SPACE)) {
                    ArrayList<Entity> passengers = flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle);
                    TeleportUtil.displayTeleportMessage((Entity)player, flightCap.getTeleportationCooldown(), CelestialDimensions.SPACE);
                    if (flightCap.getTeleportationCooldown() == 0) {
                        BlockPos pos = new BlockPos(spaceVehicle.m_20182_().f_82479_, spaceVehicle.m_20182_().f_82480_, spaceVehicle.m_20182_().f_82481_);
                        Vec3 teleportLocation = CelestialUtil.getDimensionToSpaceCoordinates((ResourceKey<Level>)spaceVehicle.f_19853_.m_46472_(), new ChunkPos(pos));
                        TeleportUtil.teleport((Entity)spaceVehicle, passengers, CelestialDimensions.SPACE, teleportLocation);
                        flightCap.resetTeleportationCooldown();
                    } else if (event.phase.equals((Object)TickEvent.Phase.END)) {
                        flightCap.decrementTeleportationCooldown();
                    }
                } else if (flightCap.canSpaceTravel((Entity)spaceVehicle) && spaceVehicle.f_19853_.m_46472_().equals(CelestialDimensions.SPACE)) {
                    Spaceship spaceship;
                    BlockHitResult hitResult = spaceVehicle.m_6688_().m_7306_((Entity)player) ? (spaceVehicle instanceof Spaceship && (spaceship = (Spaceship)spaceVehicle).getMaxSpeed() >= Spaceship.SPACESHIP_LOW_FUEL_SPEED ? (BlockHitResult)player.m_19907_(35.0, 0.0f, false) : (BlockHitResult)player.m_19907_(18.0, 0.0f, false)) : null;
                    if (hitResult != null) {
                        BlockState blockState = spaceVehicle.f_19853_.m_8055_(hitResult.m_82425_());
                        if (!spaceVehicle.f_19853_.m_5776_()) {
                            ResourceKey<Level> destination = TeleportUtil.getTeleportLocation(spaceVehicle.m_20182_(), blockState);
                            ArrayList<Entity> passengers = flightCap.getAdditionalEntitiesToTeleport((Entity)spaceVehicle);
                            if (destination != null) {
                                TeleportUtil.displayTeleportMessage((Entity)player, flightCap.getTeleportationCooldown(), destination);
                                if (flightCap.getTeleportationCooldown() == 0) {
                                    if (player instanceof ServerPlayer) {
                                        ServerPlayer serverPlayer = (ServerPlayer)player;
                                        CelestialPacketHandler.INSTANCE.sendTo((Object)new SpaceFlightPacket(flightCap.getTeleportationCooldown()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                                    }
                                    TeleportUtil.teleport((Entity)spaceVehicle, passengers, destination, spaceVehicle.m_20182_());
                                    flightCap.resetTeleportationCooldown();
                                } else {
                                    if (player instanceof ServerPlayer) {
                                        ServerPlayer serverPlayer = (ServerPlayer)player;
                                        CelestialPacketHandler.INSTANCE.sendTo((Object)new SpaceFlightPacket(flightCap.getTeleportationCooldown()), serverPlayer.f_8906_.m_6198_(), NetworkDirection.PLAY_TO_CLIENT);
                                    }
                                    flightCap.decrementTeleportationCooldown();
                                }
                            } else {
                                flightCap.resetTeleportationCooldown();
                            }
                        }
                    }
                }
            }
        }
        if ((travelCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY)) != null && event.phase.equals((Object)TickEvent.Phase.END)) {
            travelCap.getMercuryCooldown().decrementCooldown();
            travelCap.getVenusCooldown().decrementCooldown();
            travelCap.getOverworldCooldown().decrementCooldown();
            travelCap.getMarsCooldown().decrementCooldown();
            travelCap.getJupiterCooldown().decrementCooldown();
        }
        if (((Boolean)CelestialCommonConfig.STORMS.get()).booleanValue()) {
            if (player.f_19853_.m_46471_() && player.f_19853_.m_204166_(player.m_142538_()).m_203656_(CelestialTags.Biomes.DUST_STORM_BIOMES)) {
                ItemStack boots = player.m_150109_().m_36052_(0);
                ItemStack leggings = player.m_150109_().m_36052_(1);
                ItemStack breastplate = player.m_150109_().m_36052_(2);
                ItemStack helmet = player.m_150109_().m_36052_(3);
                if (helmet.m_41619_() && breastplate.m_41619_() && leggings.m_41619_() && boots.m_41619_()) {
                    player.m_6469_(CelestialDamageSource.DUST_STORM, 0.5f);
                }
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 300, 0, false, false, true));
            }
            if (!player.f_19853_.m_46471_() && player.f_19853_.m_204166_(player.m_142538_()).m_203656_(CelestialTags.Biomes.DUST_STORM_BIOMES)) {
                player.m_21195_(MobEffects.f_19597_);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityTakeDamage(LivingHurtEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().m_146707_() && ((Boolean)CelestialCommonConfig.USE_GRAVITY_EFFECTS.get()).booleanValue() && (entity.m_21023_((MobEffect)CelestialEffects.LOW_GRAVITY.get()) || entity.m_21023_((MobEffect)CelestialEffects.EXTRA_LOW_GRAVITY.get()))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void clickEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (event.getSide() == LogicalSide.SERVER && player != null) {
            if (event.getItemStack() != null && event.getItemStack().m_41720_() == Items.f_42409_) {
                if (((Boolean)CelestialCommonConfig.PORTALS.get()).booleanValue()) {
                    Level level = event.getWorld();
                    if (player.f_19853_.m_204166_(player.m_20097_()).m_203656_(CelestialTags.Biomes.CELESTIAL_BODIES) || player.f_19853_.m_46472_() == Level.f_46428_) {
                        block0: for (Direction direction : Direction.Plane.VERTICAL) {
                            BlockPos framePos = event.getPos().m_142300_(direction);
                            for (RegistryObject<? extends AbstractPortalBlock> block : CelestialBlocks.PORTAL_BLOCKS) {
                                if (!((AbstractPortalBlock)((Object)block.get())).trySpawnPortal((LevelAccessor)level, framePos)) continue;
                                level.m_5594_(player, framePos, SoundEvents.f_12288_, SoundSource.BLOCKS, 1.0f, 1.0f);
                                event.setCanceled(true);
                                event.setCancellationResult(InteractionResult.CONSUME);
                                continue block0;
                            }
                        }
                    }
                }
            } else if (event.getItemStack() != null && event.getItemStack().m_41720_() instanceof ShovelItem) {
                BlockPos pos;
                Level level = event.getWorld();
                BlockState block = level.m_8055_(pos = event.getHitVec().m_82425_());
                if (block.m_60713_((Block)CelestialBlocks.MOON_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.MOON_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.MARS_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.MARS_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.VENUS_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.VENUS_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.MERCURY_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.MERCURY_SAND_PATH.get()).m_49966_(), 1);
                } else if (block.m_60713_((Block)CelestialBlocks.IO_SAND.get())) {
                    level.m_7731_(pos, ((Block)CelestialBlocks.IO_SAND_PATH.get()).m_49966_(), 1);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoin(EntityJoinWorldEvent event) {
        Player player;
        LightTravelCapability.ILightTravel travelCap;
        Entity entity = event.getEntity();
        ResourceKey dimension = event.getWorld().m_46472_();
        Entity entity2 = event.getEntity();
        if (entity2 instanceof Player && (travelCap = CelestialExploration.getCapability((Entity)(player = (Player)entity2), CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY)) != null) {
            travelCap.sync(player);
        }
        if (((Boolean)CelestialCommonConfig.USE_GRAVITY_EFFECTS.get()).booleanValue()) {
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                ItemStack itemStack = player.m_6844_(EquipmentSlot.FEET);
                if (itemStack.m_41720_() instanceof ThermalSpacesuitArmorItem && ((ThermalSpacesuitArmorItem)itemStack.m_41720_()).isGravityBoots(itemStack)) {
                    player.m_21195_((MobEffect)CelestialEffects.LOW_GRAVITY.get());
                } else if (DimensionUtil.isLowGravityDimension((ResourceKey<Level>)dimension)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.LOW_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    player.m_21195_((MobEffect)CelestialEffects.LOW_GRAVITY.get());
                }
                if (DimensionUtil.isHighGravityDimension((ResourceKey<Level>)dimension)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.HIGH_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    player.m_21195_((MobEffect)CelestialEffects.HIGH_GRAVITY.get());
                }
            } else if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (DimensionUtil.isLowGravityDimension((ResourceKey<Level>)dimension) && !livingEntity.m_6095_().m_204039_(CelestialTags.Entities.LOW_GRAVITY_EXEMPT)) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.LOW_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    livingEntity.m_21195_((MobEffect)CelestialEffects.LOW_GRAVITY.get());
                }
                if (DimensionUtil.isHighGravityDimension((ResourceKey<Level>)dimension) && !livingEntity.m_6095_().m_204039_(CelestialTags.Entities.HIGH_GRAVITY_EXEMPT)) {
                    livingEntity.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.HIGH_GRAVITY.get(), 120000, 0, false, false, true));
                } else {
                    livingEntity.m_21195_((MobEffect)CelestialEffects.HIGH_GRAVITY.get());
                }
            }
        }
        if (((Boolean)CelestialCommonConfig.STORMS.get()).booleanValue()) {
            LivingEntity livingEntity;
            if (event.getWorld().m_46471_() && event.getWorld().m_204166_(entity.m_142538_()).m_203656_(CelestialTags.Biomes.DUST_STORM_BIOMES) && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player)) {
                    livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 7000, 0, false, false, true));
                }
            }
            if (!event.getWorld().m_46471_() && event.getWorld().m_204166_(entity.m_142538_()).m_203656_(CelestialTags.Biomes.DUST_STORM_BIOMES) && entity instanceof LivingEntity) {
                livingEntity = (LivingEntity)entity;
                if (!(entity instanceof Player)) {
                    livingEntity.m_21195_(MobEffects.f_19597_);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityEquipmentChange(LivingEquipmentChangeEvent event) {
        if (!((Boolean)CelestialCommonConfig.USE_GRAVITY_EFFECTS.get()).booleanValue()) {
            return;
        }
        Entity entity = event.getEntity();
        EquipmentSlot slot = event.getSlot();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ItemStack itemStack = event.getTo();
            if (slot != EquipmentSlot.FEET) {
                return;
            }
            if (itemStack.m_41720_() instanceof ThermalSpacesuitArmorItem && ((ThermalSpacesuitArmorItem)itemStack.m_41720_()).isGravityBoots(itemStack)) {
                player.m_21195_((MobEffect)CelestialEffects.LOW_GRAVITY.get());
                player.m_21195_((MobEffect)CelestialEffects.EXTRA_LOW_GRAVITY.get());
            } else {
                ResourceKey dimension = player.f_19853_.m_46472_();
                if (DimensionUtil.isLowGravityDimension((ResourceKey<Level>)dimension)) {
                    player.m_7292_(new MobEffectInstance((MobEffect)CelestialEffects.LOW_GRAVITY.get(), 120000, 0, false, false, true));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerChangeDimensions(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getPlayer();
        LightTravelCapability.ILightTravel travelCap = CelestialExploration.getCapability((Entity)player, CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY);
        if (travelCap != null) {
            if (event.getTo().equals(CelestialDimensions.SPACE)) {
                travelCap.setBeenToSpace();
            } else if (event.getTo().equals(CelestialDimensions.MARS)) {
                travelCap.setBeenToMars();
            } else if (event.getTo().equals(CelestialDimensions.VENUS)) {
                travelCap.setBeenToVenus();
            } else if (event.getTo().equals(CelestialDimensions.MERCURY)) {
                travelCap.setBeenToMercury();
            } else if (event.getTo().equals(CelestialDimensions.JUPITER)) {
                travelCap.setBeenToJupiter();
            }
            travelCap.sync(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal() != null && event.getPlayer() != null) {
            event.getOriginal().reviveCaps();
            LightTravelCapability.ILightTravel oldTravelData = (LightTravelCapability.ILightTravel)event.getOriginal().getCapability(CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY).orElse(null);
            LightTravelCapability.ILightTravel newTravelData = (LightTravelCapability.ILightTravel)event.getPlayer().getCapability(CelestialCapabilities.LIGHT_TRAVEL_CAPABILITY).orElse(null);
            if (oldTravelData != null && newTravelData != null) {
                newTravelData.setData(oldTravelData.getData());
            }
            TaxiCapability.ITaxi oldTaxiData = (TaxiCapability.ITaxi)event.getOriginal().getCapability(CelestialCapabilities.TAXI_CAPABILITY).orElse(null);
            TaxiCapability.ITaxi newTaxiData = (TaxiCapability.ITaxi)event.getPlayer().getCapability(CelestialCapabilities.TAXI_CAPABILITY).orElse(null);
            if (oldTaxiData != null && newTaxiData != null) {
                newTaxiData.setData(oldTaxiData.getData());
            }
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onToolTipRender(RenderTooltipEvent.GatherComponents event) {
        if (event.getItemStack().m_150930_(((AirlockDoorBlock)((Object)CelestialBlocks.AIRLOCK_PANEL_DOOR.get())).m_5456_())) {
            event.getTooltipElements().add(Either.left((Object)new TranslatableComponent("item.celestialexploration.door.airlock_panel_door")));
        }
        if (event.getItemStack().m_150930_(((HangarDoorBlock)((Object)CelestialBlocks.HANGAR_DOOR.get())).m_5456_())) {
            event.getTooltipElements().add(Either.left((Object)new TranslatableComponent("item.celestialexploration.door.hangar_door")));
        }
    }
}

