/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.integration;

import com.shim.celestialexploration.CelestialExploration;
import com.shim.celestialexploration.integration.WorkbenchCraftingRecipeCategory;
import com.shim.celestialexploration.integration.WorkbenchSmeltingRecipeCategory;
import com.shim.celestialexploration.recipes.WorkbenchCraftingRecipe;
import com.shim.celestialexploration.recipes.WorkbenchSmeltingRecipe;
import com.shim.celestialexploration.registry.CelestialBlocks;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    RecipeType<WorkbenchCraftingRecipe> workbenchCraftingRecipeType = new RecipeType(WorkbenchCraftingRecipeCategory.UID, WorkbenchCraftingRecipe.class);
    RecipeType<WorkbenchSmeltingRecipe> workbenchSmeltingRecipeType = new RecipeType(WorkbenchSmeltingRecipeCategory.UID, WorkbenchSmeltingRecipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("celestialexploration", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkbenchCraftingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WorkbenchSmeltingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        super.registerRecipeCatalysts(registration);
        registration.addRecipeCatalyst(new ItemStack((ItemLike)CelestialBlocks.WORKBENCH.get()), new RecipeType[]{this.workbenchCraftingRecipeType, this.workbenchSmeltingRecipeType});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager rm = Objects.requireNonNull(CelestialExploration.PROXY.getMinecraft().f_91073_).m_7465_();
        List craftingRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)WorkbenchCraftingRecipe.Type.INSTANCE);
        List smeltingRecipes = rm.m_44013_((net.minecraft.world.item.crafting.RecipeType)WorkbenchSmeltingRecipe.Type.INSTANCE);
        registration.addRecipes(this.workbenchCraftingRecipeType, craftingRecipes);
        registration.addRecipes(this.workbenchSmeltingRecipeType, smeltingRecipes);
    }
}

