/*
 * Decompiled with CFR 0.152.
 */
package com.shim.celestialexploration.integration;

import com.shim.celestialexploration.blocks.blockentities.WorkbenchBlockEntity;
import com.shim.celestialexploration.recipes.WorkbenchCraftingRecipe;
import com.shim.celestialexploration.registry.CelestialBlocks;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;

public class WorkbenchCraftingRecipeCategory
implements IRecipeCategory<WorkbenchCraftingRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("celestialexploration", "workbench_crafting");
    public static final ResourceLocation TEXTURE = new ResourceLocation("celestialexploration", "textures/gui/workbench.png");
    private final IDrawable background;
    private final IDrawable icon;

    public WorkbenchCraftingRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(TEXTURE, 0, 0, 176, 80);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CelestialBlocks.WORKBENCH.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends WorkbenchCraftingRecipe> getRecipeClass() {
        return WorkbenchCraftingRecipe.class;
    }

    public RecipeType<WorkbenchCraftingRecipe> getRecipeType() {
        return super.getRecipeType();
    }

    public Component getTitle() {
        return new TranslatableComponent("recipe.celestialexploration.workbench.crafting");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull WorkbenchCraftingRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        FluidStack fluid = new FluidStack(recipe.getFluid(), (int)(recipe.getBuckets() * 1000.0f));
        builder.addSlot(RecipeIngredientRole.INPUT, 52, 17).setFluidRenderer(WorkbenchBlockEntity.maxFluidLevel, true, 9, 52).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)fluid);
        int height = recipe.getHeight();
        int width = recipe.getWidth();
        int size = recipe.m_7527_().size();
        int xOffset = size < 3 ? (3 - size) * 18 / 2 : 0;
        int j = 0;
        for (int i = 0; i < size; ++i) {
            Ingredient item = (Ingredient)recipe.m_7527_().get(i);
            if (i + 1 > width * (j + 1)) {
                ++j;
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 66 + xOffset + i % width * 18, 17 + j * 18).addIngredients(item);
        }
        if (size == 1) {
            builder.setShapeless();
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 144, 35).addItemStack(recipe.m_8043_());
    }
}

